/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.itbjfcl.dc.services.payment;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.itbjfcl.dc.ITBJFCLMetaDataImpl;
import kd.ebg.aqap.banks.itbjfcl.dc.services.payment.QueryPayImpl;
import kd.ebg.aqap.banks.itbjfcl.dc.services.util.Helper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/FrontEnd/FrontEndServlet");
    }

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"Iss_Itreasury");
        Element instrReq = JDomUtils.addChild((Element)root, (String)"InstrReq");
        JDomUtils.addChild((Element)instrReq, (String)"OperationType", (String)"1");
        JDomUtils.addChild((Element)instrReq, (String)"SystemID", (String)"ERP");
        JDomUtils.addChild((Element)instrReq, (String)"BatchNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        JDomUtils.addChild((Element)instrReq, (String)"IsManual", (String)"0");
        JDomUtils.addChild((Element)instrReq, (String)"SendTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss SSS")));
        for (PaymentInfo paymentInfo : paymentInfos) {
            Element instrContent = JDomUtils.addChild((Element)instrReq, (String)"InstrContent");
            JDomUtils.addChild((Element)instrContent, (String)"ApplyCode", (String)paymentInfo.getBankDetailSeqID());
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            JDomUtils.addChild((Element)instrContent, (String)"CurrencyCode", (String)paymentInfo.getCurrency());
            String custNo = RequestContextUtils.getBankParameterValue((String)ITBJFCLMetaDataImpl.custno);
            JDomUtils.addChild((Element)instrContent, (String)"ClientCode", (String)custNo);
            JDomUtils.addChild((Element)instrContent, (String)"ExpectDate", (String)(paymentInfo.getBookingTime() != null ? paymentInfo.getBookingTime().toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) : LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
            PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfo);
            JDomUtils.addChild((Element)instrContent, (String)"Amount", (String)paymentInfo.getAmount().toString());
            boolean innerPayAcnt = Helper.isInnerAcnt((String)paymentInfo.getAccNo());
            String paytype = "";
            paytype = innerPayAcnt && !paymentInfo.is2SameBank() ? "1" : (innerPayAcnt && paymentInfo.is2SameBank() ? "2" : "3");
            JDomUtils.addChild((Element)instrContent, (String)"PayType", (String)paytype);
            JDomUtils.addChild((Element)instrContent, (String)"IsPrivatePayID", (String)(paymentInfo.is2Individual() ? "1" : "0"));
            JDomUtils.addChild((Element)instrContent, (String)"PayAccountNo", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)instrContent, (String)"RecAccountNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)instrContent, (String)"RecAccountName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)instrContent, (String)"RecBankName", (String)paymentInfo.getIncomeBankName());
            JDomUtils.addChild((Element)instrContent, (String)"RecBankProvince", (String)paymentInfo.getIncomeProvince());
            JDomUtils.addChild((Element)instrContent, (String)"RecBankCity", (String)paymentInfo.getIncomeCity());
            JDomUtils.addChild((Element)instrContent, (String)"RecBankCNAPSNO", (String)paymentInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)instrContent, (String)"RecBankUnionNO", (String)"");
            JDomUtils.addChild((Element)instrContent, (String)"RecBankAgencyNO", (String)"");
            JDomUtils.addChild((Element)instrContent, (String)"PayAbstract", (String)paymentInfo.getExplanation());
            JDomUtils.addChild((Element)instrContent, (String)"IsNonProductionID", (String)"0");
            JDomUtils.addChild((Element)instrContent, (String)"PlanProjectCode", (String)"");
            JDomUtils.addChild((Element)instrContent, (String)"CreateUserName", (String)paymentInfo.getPaybillCreator());
            JDomUtils.addChild((Element)instrContent, (String)"ComfirmUserName", (String)paymentInfo.getPaybillAuditor());
            JDomUtils.addChild((Element)instrContent, (String)"SignText", (String)"");
            JDomUtils.addChild((Element)instrContent, (String)"MoneyUseCode", (String)"");
            JDomUtils.addChild((Element)instrContent, (String)"MoneyUseExplain", (String)paymentInfo.getUseCN());
            JDomUtils.addChild((Element)instrContent, (String)"REVERSE1", (String)paymentInfo.getAbstractMsg());
            JDomUtils.addChild((Element)instrContent, (String)"REVERSE2", (String)"");
            JDomUtils.addChild((Element)instrContent, (String)"REVERSE3", (String)"");
            JDomUtils.addChild((Element)instrContent, (String)"REVERSE4", (String)"");
            JDomUtils.addChild((Element)instrContent, (String)"REVERSE5", (String)"");
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element instrRen = JDomUtils.getChildElement((Element)root, (String)"InstrRen");
        String processCode = JDomUtils.getChildText((Element)instrRen, (String)"ProcessCode");
        String processDesc = JDomUtils.getChildText((Element)instrRen, (String)"ProcessDesc");
        List elements = instrRen.getChildren("RenContent");
        for (Element renContent : elements) {
            String applyCode = JDomUtils.getChildText((Element)renContent, (String)"ApplyCode");
            String businessCode = JDomUtils.getChildText((Element)renContent, (String)"BusinessCode");
            String businessDesc = JDomUtils.getChildText((Element)renContent, (String)"BusinessDesc");
            String instructionStatusDesc = JDomUtils.getChildText((Element)renContent, (String)"InstructionStatusDesc");
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)applyCode);
            if (paymentInfo == null) continue;
            if ("0000".equalsIgnoreCase(businessCode) || "0001".equalsIgnoreCase(businessCode) || "0002".equalsIgnoreCase(businessCode) || "0004".equalsIgnoreCase(businessCode) || "0005".equalsIgnoreCase(businessCode) || "0007".equalsIgnoreCase(businessCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)businessCode, (String)businessDesc);
                continue;
            }
            if ("0003".equalsIgnoreCase(businessCode) || "0006".equalsIgnoreCase(businessCode) || "0008".equalsIgnoreCase(businessCode) || "0009".equalsIgnoreCase(businessCode) || "0010".equalsIgnoreCase(businessCode) || "9001".equalsIgnoreCase(businessCode) || "9999".equalsIgnoreCase(businessCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)businessCode, (String)(StringUtils.isNotEmpty((String)instructionStatusDesc) ? instructionStatusDesc : businessDesc));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), (String)businessCode, (String)businessDesc);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) || "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) || "pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType());
    }
}

