/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.services.login;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cexim.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cexim.dc.util.CEXIMDCBankResponse;
import kd.ebg.aqap.banks.cexim.dc.util.CommonPacker;
import kd.ebg.aqap.banks.cexim.dc.util.CommonParser;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class LoginUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(LoginUtils.class);
    private static LocalDateTime lastLoginTime;

    public static void login() {
        if (BankBusinessConfig.isAutoLogin()) {
            LoginUtils.doLogin();
        }
    }

    public static boolean doLogin() {
        EBContext context = EBContext.getContext();
        String key = context.getBankLoginID() + "_login";
        if (CosmicCache.contains((String)key) && StringUtils.isNotEmpty((String)CosmicCache.get((String)key))) {
            logger.info("\u7b7e\u5230\u5b58\u5728\u7f13\u5b58\uff0c\u672c\u6b21\u8df3\u8fc7\u7b7e\u5230");
            return true;
        }
        if (null == lastLoginTime || LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli() >= lastLoginTime.toInstant(ZoneOffset.of("+8")).toEpochMilli() + 0x6DDD00L) {
            logger.info("\u8fdb\u884c\u7b7e\u5230\u64cd\u4f5c");
            Element root = new Element("Transaction");
            Element headr = CommonPacker.createSystemHead("P1OPME001");
            root.addContent((Content)headr);
            Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
            body.addContent((Content)new Element("request"));
            logger.info("\u8fdb\u884c\u7b7e\u5230\u64cd\u4f5c");
            String req = JDomExtUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)EBContext.getContext().getCharsetName());
            String rsp = LoginUtils.sendAndRecv(req, logger);
            CEXIMDCBankResponse bankResp = CommonParser.getBankPreResponse((String)rsp);
            if (!bankResp.isSuccess()) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u5230\u5931\u8d25\u3002%s", (String)"LoginUtils_0", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), bankResp.getResponseCode() + bankResp.getResponseMessage()));
            }
            logger.info("\u7b7e\u5230\u64cd\u4f5c\u5b8c\u6210");
            lastLoginTime = LocalDateTime.now();
            CosmicCache.putIfAbsentWithExpire((String)key, (String)"1", (int)7200, (TimeUnit)TimeUnit.SECONDS);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendAndRecv(String rsqt, EBGLogger logger) {
        AbstractImpl scokect = new AbstractImpl();
        try {
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            IConnection conn = factory.createExchangeConnection();
            logger.info("connL {}", (Object)conn.getClass().getName());
            EBContext.getContext().setConnection(conn);
            conn.openConnection();
            try (OutputStream os = conn.getOutputStream();){
                Object object;
                String rsp = "";
                scokect.send(os, rsqt);
                try {
                    InputStream is = conn.getInputStream();
                    object = null;
                    try {
                        rsp = scokect.recv(is);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (object != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    EBContext.getContext().setThrowableAfterSend(t);
                }
                CEXIMDCBankResponse response = CommonParser.getFrontResponse((String)rsp);
                if (!response.isSuccess()) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"LoginUtils_1", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), response.getResponseCode() + response.getResponseMessage()));
                }
                rsp = response.getBankMsg();
                object = rsp;
                return object;
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7b7e\u5230\u5f02\u5e38", (String)"LoginUtils_2", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7b7e\u5230\u5f02\u5e38", (String)"LoginUtils_2", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

