/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_BankBatchSeqIdCreator;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.services.MappingAcctService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class RegionHisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(RegionHisBalanceImpl.class);

    public EBBankBalanceResponse hisBalance(BankBalanceRequest request) {
        List acnts = request.getBankAcntList();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        for (BankAcnt acnt : acnts) {
            try {
                request.getHeader().setAcnt(acnt);
                EBBankBalanceResponse response = this.doBiz(request);
                balanceInfos.addAll(response.getBalances());
            }
            catch (Exception e) {
                log.info("\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u51fa\u9519\uff1a", (Object)e);
                BalanceInfo balanceInfo = new BalanceInfo();
                balanceInfo.setBankAcnt(acnt);
                balanceInfo.setBankCurrency(request.getBankCurrency());
                balanceInfo.setError(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5386\u53f2\u4f59\u989d\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"RegionHisBalanceImpl_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), e.getCause()));
                balanceInfos.add(balanceInfo);
            }
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        MappingAcctService service = MappingAcctService.getInstance();
        Element root = BOCHK_DC_Packer.createRootWithHead((String)BOCHK_DC_BankBatchSeqIdCreator.getPackageId());
        Element Tx = JDomUtils.createRoot((String)"Tx");
        Element OtherBankHistREQ = JDomUtils.addChild((Element)Tx, (String)"OtherBankHistREQ");
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        String accNo = acnt.getAccNo();
        String iso = CurrencyUtils.convert2Iso((String)bankBalanceRequest.getCurrency(), (String)bankBalanceRequest.getHeader().getBankVersionID(), (String)bankBalanceRequest.getHeader().getCustomerID());
        accNo = service.mapping(accNo, iso);
        JDomUtils.addChild((Element)OtherBankHistREQ, (String)"AcctNo", (String)accNo);
        String swiftCode = BankBusinessConfig.getBicCode(acnt.getAccNo());
        JDomUtils.addChild((Element)OtherBankHistREQ, (String)"SwiftCode", (String)swiftCode);
        JDomUtils.addChild((Element)OtherBankHistREQ, (String)"ApiBkCode", (String)"");
        JDomUtils.addChild((Element)OtherBankHistREQ, (String)"Cur", (String)bankBalanceRequest.getBankCurrency());
        String from = bankBalanceRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        String to = bankBalanceRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        JDomUtils.addChild((Element)OtherBankHistREQ, (String)"FromDate", (String)from);
        JDomUtils.addChild((Element)OtherBankHistREQ, (String)"ToDate", (String)to);
        JDomUtils.addChild((Element)root, (Element)Tx);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        MappingAcctService service = MappingAcctService.getInstance();
        log.info("==\u67e5\u8be2\u4f59\u989d\u54cd\u5e94\u62a5\u6587\u7684\u89e3\u6790\u2014\u2014\u5f00\u59cb==");
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankRsp = BOCHK_DC_Parser.parseHead((Element)root);
        if (!"S".equals(bankRsp.getResponseCode())) {
            String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
            String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u4e3a(%1$s,%2$s);\u9519\u8bef\u7801\uff1a%3$s,\u9519\u8bef\u8bf4\u660e\uff1a%4$s", (String)"RegionHisBalanceImpl_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), bankRsp.getResponseCode(), bankRsp.getResponseMessage(), ErrorCode, ErrorDesc));
        }
        String iso = CurrencyUtils.convert2Iso((String)bankBalanceRequest.getCurrency(), (String)bankBalanceRequest.getHeader().getBankVersionID(), (String)bankBalanceRequest.getHeader().getCustomerID());
        Element OtherBankHistRLY = root.getChild("Tx").getChild("OtherBankHistRLY");
        String acctNo = OtherBankHistRLY.getChildTextTrim("AcctNo");
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        List records = OtherBankHistRLY.getChild("Result").getChildren("Record");
        BalanceInfo balanceInfo = null;
        ArrayList response = Lists.newArrayList();
        for (int i = 0; records != null && i < records.size(); ++i) {
            Element record = (Element)records.get(i);
            String avalBal = record.getChildTextTrim("AvailBalance");
            String ledBal = record.getChildTextTrim("Balance");
            String UpdateDate = record.getChildTextTrim("UpdateDate");
            String UpdateTime = record.getChildTextTrim("UpdateTime");
            String RecordCur = record.getChildTextTrim("RecordCur");
            LocalDateTime balanceTime = this.parseBalanceTime(UpdateDate, UpdateTime);
            balanceInfo = new BalanceInfo();
            this.setBankAcnt(balanceInfo, acnt);
            this.setAvailableBalance(balanceInfo, avalBal);
            this.setCurrentBalance(balanceInfo, ledBal);
            String testServerDate = RequestContextUtils.getBankParameterValue((String)"testServerDate");
            if (StringUtils.isEmpty((String)testServerDate)) {
                this.setBalanceDateTime(balanceInfo, balanceTime);
            } else {
                this.setBalanceDateTime(balanceInfo, bankBalanceRequest.getEndDate().atTime(0, 0));
            }
            balanceInfo.setBankCurrency(RecordCur);
            String mappingAcc = service.mapping(acctNo, iso);
            balanceInfo.setExtraBankAcnt(mappingAcc);
            response.add(balanceInfo);
        }
        if (balanceInfo == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u94f6\u884c\u672a\u8fd4\u56de\u8bf7\u6c42\u8d26\u53f7[%1$s]\u6240\u67e5\u8be2\u5e01\u79cd[%2$s]\u7684\u4f59\u989d\u4fe1\u606f\u3002", (String)"RegionHisBalanceImpl_3", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), bankBalanceRequest.getAcnt().getAccNo(), bankBalanceRequest.getBankCurrency()));
        }
        return new EBBankBalanceResponse((List)response);
    }

    private LocalDateTime parseBalanceTime(String UpdateDate, String UpdateTime) {
        LocalDateTime balanceTime;
        String back_up = UpdateDate + "000000";
        try {
            balanceTime = LocalDateTime.parse(UpdateDate + UpdateTime, DateTimeFormatter.ofPattern("yyyy/MM/ddHH:mm:ss"));
        }
        catch (Exception e) {
            return LocalDateTime.parse(back_up, DateTimeFormatter.ofPattern("yyyy/MM/ddHHmmss"));
        }
        return balanceTime;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "0x";
    }

    public String getBizCode() {
        return "OtherBankHistREQ";
    }

    public String getBizDesc() {
        return "Other bank's History Bal";
    }
}

