/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bochk.dc.services.balance.BalanceImpl;
import kd.ebg.aqap.banks.bochk.dc.services.balance.RegionBalanceImpl;
import kd.ebg.aqap.banks.bochk.dc.services.balance.RegionHisBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.log.EBGLogger;

public class RouteBalance
extends AbstractBalanceImpl
implements IBalance,
IHisBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(RouteBalance.class);

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        logger.info("====\u4f59\u989d\u67e5\u8be2\u8def\u7531====");
        boolean isProxy = BankBusinessConfig.getBOC_HK_OTHER_OR_SELF_QRY();
        if (isProxy) {
            if (LocalDate.now().isEqual(request.getEndDate())) {
                return new RegionBalanceImpl().balance(request);
            }
            return new RegionHisBalanceImpl().hisBalance(request);
        }
        if (LocalDate.now().isAfter(request.getEndDate())) {
            logger.info("\u672c\u884c\u8d26\u6237\u4e0d\u652f\u6301\u5386\u53f2\u4f59\u989d\u67e5\u8be2");
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfo.setBankAcnt(request.getAcnt());
            balanceInfo.setBankCurrency(request.getBankCurrency());
            balanceInfo.setError(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u3002", (String)"RouteBalance_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        }
        if (BankBusinessConfig.isRegionBalanceQuery()) {
            return new RegionBalanceImpl().balance(request);
        }
        return new BalanceImpl().balance(request);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public LocalDate limitDate() {
        return LocalDate.now().minusDays(364L);
    }

    public String getDeveloper() {
        return "0xC";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8def\u7531\u5230\u4f59\u989d\u67e5\u8be2\u7684\u63a5\u53e3\u3002", (String)"RouteBalance_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]);
    }

    public boolean async() {
        return false;
    }
}

