/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_BankBatchSeqIdCreator;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.services.MappingAcctService;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest request) {
        MappingAcctService service = MappingAcctService.getInstance();
        BankAcnt acnt = request.getAcnt();
        String requestMessage = "";
        String swiftCode = BankBusinessConfig.getBicCode(acnt.getAccNo());
        Element BOCHKE2B = BOCHK_DC_Packer.createRootWithHead((String)BOCHK_DC_BankBatchSeqIdCreator.getPackageId());
        Element Tx = new Element("Tx");
        Element AcctActivityREQ = new Element("AcctActivityREQ");
        String accNo = service.mapping(acnt.getAccNo(), acnt.getCurrency());
        JDomUtils.addChild((Element)AcctActivityREQ, (String)"AcctNo", (String)accNo);
        if (BankBusinessConfig.getBOC_HK_OTHER_OR_SELF_QRY()) {
            JDomUtils.addChild((Element)AcctActivityREQ, (String)"BicCode", (String)swiftCode);
        } else {
            String country = acnt.getCountry();
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(country);
            if (null == code && (code = ISOCountryUtils.getInstance().getCountryInfo(country)) == null) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56fd\u5bb6\u7801\uff1a%s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"DBS_DC_Packer_0", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]), country));
            }
            JDomUtils.addChild((Element)AcctActivityREQ, (String)"Region", (String)code.geteChart2());
        }
        JDomUtils.addChild((Element)AcctActivityREQ, (String)"StartDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd")));
        JDomUtils.addChild((Element)AcctActivityREQ, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd")));
        JDomUtils.addChild((Element)AcctActivityREQ, (String)"TransCur", (String)request.getBankCurrency().toUpperCase());
        JDomUtils.addChild((Element)Tx, (Element)AcctActivityREQ);
        JDomUtils.addChild((Element)BOCHKE2B, (Element)Tx);
        RequestContextUtils.setRunningParam((String)acnt.getAccNo(), (String)(acnt.getAccNo() + "_" + accNo));
        String encoding = RequestContextUtils.getCharset();
        requestMessage = JDomUtils.root2String((Element)BOCHKE2B, (String)encoding);
        return requestMessage;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String s) {
        MappingAcctService service = MappingAcctService.getInstance();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>();
        BankAcnt acnt = request.getAcnt();
        String currency = request.getBankCurrency();
        String qryAcc = RequestContextUtils.getRunningParam((String)acnt.getAccNo());
        log.info("qryAcc >{}", (Object)qryAcc);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankRsp = BOCHK_DC_Parser.parseHead((Element)root);
        if (!"S".equals(bankRsp.getResponseCode())) {
            String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
            String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
            if (ErrorCode.equals("SP0400") || ErrorCode.equals("E11071") || ErrorDesc != null && ErrorDesc.startsWith("NO ACTIVITY FOUND")) {
                return new EBBankDetailResponse(detailList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u4e3a(%1$s,%2$s);\u9519\u8bef\u7801\uff1a%3$s,\u9519\u8bef\u8bf4\u660e\uff1a%4$s", (String)"DetailImpl_10", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), bankRsp.getResponseCode(), bankRsp.getResponseMessage(), ErrorCode, ErrorDesc));
        }
        try {
            Element AcctActivityRLY = root.getChild("Tx").getChild("AcctActivityRLY");
            String AcctNo = AcctActivityRLY.getChildTextTrim("AcctNo");
            String TransCur = AcctActivityRLY.getChildTextTrim("TransCur");
            if (!qryAcc.contains(AcctNo.trim())) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u8d26\u53f7(%1$s)\u548c\u8bf7\u6c42\u7684\u8d26\u53f7(%2$s)\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u83b7\u53d6\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"DetailImpl_11", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), AcctNo, acnt.getAccNo()));
            }
            if (!currency.equals(TransCur)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5e01\u79cd(%1$s)\u548c\u8bf7\u6c42\u7684\u5e01\u79cd(%2$s)\u4e0d\u4e00\u81f4,\u65e0\u6cd5\u83b7\u53d6\u660e\u7ec6\u8bb0\u5f55", (String)"DetailImpl_12", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), TransCur, currency));
            }
            Element TransRecord = AcctActivityRLY.getChild("TransRecord");
            if (TransRecord == null) {
                return new EBBankDetailResponse(detailList);
            }
            Element result = TransRecord.getChild("Result");
            if (result == null) {
                return new EBBankDetailResponse(detailList);
            }
            List recordList = result.getChildren("Record");
            String mappingAcc = service.mapping(acnt.getAccNo(), acnt.getCurrency());
            log.info("\u4e3b\u8d26\u6237" + acnt.getAccNo() + ",\u5e01\u79cd" + acnt.getCurrency() + ",\u94f6\u884c\u5e01\u79cd" + request.getBankCurrency() + ",\u67e5\u8be2\u51fa\u7684\u4ee3\u7406\u8d26\u53f7\u4e3a" + mappingAcc);
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
            for (int i = 0; i < recordList.size(); ++i) {
                Element record = (Element)recordList.get(i);
                String amt = record.getChildTextTrim("Amt");
                String cur = record.getChildTextTrim("Cur");
                String transDate = record.getChildTextTrim("TransDate").substring(0, 16);
                String particular = record.getChildTextTrim("Particular");
                String payerOrPayeeNam = record.getChildTextTrim("PayerOrPayeeName");
                String payerOrPayeeAcctNo = record.getChildTextTrim("PayerOrPayeeAcctNo");
                String transFlag = record.getChildTextTrim("TransFlag");
                String ref = record.getChildTextTrim("TransRef");
                boolean exist = true;
                if (StringUtils.isEmpty((String)ref)) {
                    ref = record.getChildTextTrim("TransId");
                    exist = false;
                }
                DetailInfo detailInfo = new DetailInfo();
                detailInfo.setAccNo(acnt.getAccNo());
                detailInfo.setExtraAccNo(mappingAcc);
                detailInfo.setAccName(acnt.getAccName());
                detailInfo.setBankName(acnt.getBankName());
                detailInfo.setOppAccName(payerOrPayeeNam);
                detailInfo.setOppAccNo(payerOrPayeeAcctNo);
                detailInfo.setCurrency(cur);
                detailInfo.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm")));
                detailInfo.setTransTime(LocalDateTime.parse(transDate, DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm")));
                if ("DR".equalsIgnoreCase(transFlag)) {
                    detailInfo.setDebitAmount(new BigDecimal(amt));
                    detailInfo.setCreditAmount(new BigDecimal("0.00"));
                } else {
                    detailInfo.setDebitAmount(new BigDecimal("0.00"));
                    detailInfo.setCreditAmount(new BigDecimal(amt));
                }
                detailInfo.setExplanation(particular);
                detailInfo.setTransType(transFlag);
                JSONObject uniqueKey = new JSONObject();
                uniqueKey.put("TransDate", (Object)record.getChildTextTrim("TransDate"));
                uniqueKey.put("TransRef", (Object)ref);
                uniqueKey.put("TransFlag", (Object)transFlag);
                uniqueKey.put("Amt", (Object)amt);
                if (exist) {
                    String receiptNo = MatchRule.getInstance().getReceiptNo(detailInfo.getAccNo(), detailInfo.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), uniqueKey.toJSONString());
                    if (countMap.containsKey(receiptNo)) {
                        int count = (Integer)countMap.get(receiptNo) + 1;
                        countMap.put(receiptNo, count);
                        receiptNo = receiptNo + "-" + String.format("%04d", count);
                    } else {
                        countMap.put(receiptNo, 0);
                    }
                    detailInfo.setReceiptNo(receiptNo);
                }
                detailInfo.setJsonMap(uniqueKey.toJSONString());
                detailList.add(detailInfo);
            }
            return new EBBankDetailResponse(detailList);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u51fa\u9519", (String)"DetailImpl_13", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "AcctActivityREQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_9", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }
}

