/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.BOCRemitPlus;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BOCHK_DC_Constants;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.banks.bochk.dc.services.payment.BOCRemitPlus.OverSeaQueryPayImpl;
import kd.ebg.aqap.banks.bochk.dc.utils.MultiLinesUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OverSeaPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(OverSeaPayImpl.class);

    public int getBatchSize() {
        return 50;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return OverSeaQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "(TransferREQ - BOCRemitPlus)";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"6.2.11 \u3010\u6d77\u5916 \u4e2d\u9280\u5feb\u532f\u3011(TransferREQ - BOCRemitPlus)", (String)"OverSeaPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]);
    }

    public Set<String> getSupportCurrency() {
        return Sets.newHashSet((Object[])new String[]{"CNY", "HKD", "USD"});
    }

    public boolean match(PaymentInfo paymentInfo) {
        return (BizName.QueryPay.PAY_FOR_SALARY.name().equalsIgnoreCase(paymentInfo.getSubBizType()) || BizName.OVERSEAPAY.name().equalsIgnoreCase(paymentInfo.getSubBizType())) && BOCHK_DC_Constants.getBOC_REMIT_PLUS().equals(paymentInfo.getUseCN());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element root = BOCHK_DC_Packer.createRootWithHead((String)paymentInfos[0].getPackageId());
        Element tx = new Element("Tx");
        Element transferReq = JDomUtils.addChild((Element)tx, (String)"TransferREQ");
        Element requests = new Element("Requests");
        int num = paymentInfos.length;
        requests.setAttribute("noOfRecord", Integer.toString(num));
        for (PaymentInfo paymentInfo : paymentInfos) {
            Element record = new Element("Record");
            Element remitPlus = new Element("BOCRemitPlus");
            JDomUtils.addChild((Element)record, (Element)remitPlus);
            JDomUtils.addChild((Element)requests, (Element)record);
            JDomUtils.addChild((Element)remitPlus, (String)"DDebitAcctNo", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)remitPlus, (String)"DDebitCur", (String)paymentInfo.getCurrency());
            JDomUtils.addChild((Element)remitPlus, (String)"RemitCur", (String)paymentInfo.getPayCurrency());
            if (!BOCHK_DC_Packer.isBelowZero((BigDecimal)paymentInfo.getActualAmount())) {
                JDomUtils.addChild((Element)remitPlus, (String)"RemitAmt", (String)paymentInfo.getActualAmount().toString());
            } else {
                JDomUtils.addChild((Element)remitPlus, (String)"RemitAmt", (String)"");
            }
            JDomUtils.addChild((Element)remitPlus, (String)"EquvAmt", (String)"");
            Element chargeFrom = JDomUtils.addChild((Element)remitPlus, (String)"ChargeFrom");
            Element chargeFromAcct = JDomUtils.addChild((Element)chargeFrom, (String)"ChargeFromAcct");
            JDomUtils.addChild((Element)chargeFromAcct, (String)"ChargeAcctNo", (String)paymentInfo.getPayerFeeAccNo());
            JDomUtils.addChild((Element)chargeFromAcct, (String)"ChargeCur", (String)paymentInfo.getPayerFeeCurrency());
            if ("01".equals(paymentInfo.getPayerFeeType())) {
                JDomUtils.addChild((Element)chargeFromAcct, (String)"ChargeBorneBy", (String)"A");
            } else {
                JDomUtils.addChild((Element)chargeFromAcct, (String)"ChargeBorneBy", (String)"B");
            }
            String bankCode = paymentInfo.getPayeeBankCode();
            if (StringUtils.isNotEmpty((String)paymentInfo.getIncomeBankLocalClearingCode())) {
                bankCode = paymentInfo.getIncomeBankLocalClearingCode();
            }
            JDomUtils.addChild((Element)remitPlus, (String)"BeneBankerCode", (String)bankCode);
            JDomUtils.addChild((Element)remitPlus, (String)"RemitBeneAcctNo", (String)paymentInfo.getIncomeAccNo());
            Element remitbenename = JDomUtils.addChild((Element)remitPlus, (String)"RemitBeneName");
            List<String> incomeAccNames = MultiLinesUtils.build(paymentInfo.getIncomeAccName(), 4);
            for (String line : incomeAccNames) {
                JDomUtils.addChild((Element)remitbenename, (String)"Line", (String)line);
            }
            Element paymentdetail = JDomUtils.addChild((Element)remitPlus, (String)"PaymentDetail");
            List<String> explanations = MultiLinesUtils.build(paymentInfo.getExplanation(), 2);
            for (String line : explanations) {
                JDomUtils.addChild((Element)paymentdetail, (String)"Line", (String)line);
            }
            JDomUtils.addChild((Element)remitPlus, (String)"CustRef", (String)paymentInfo.getBankDetailSeqId());
            JDomUtils.addChild((Element)remitPlus, (String)"ExContract", (String)paymentInfo.getExContract());
            JDomUtils.addChild((Element)remitPlus, (String)"ValueDate", (String)BOCHK_DC_Packer.valueDate((LocalDateTime)paymentInfo.getBookingTime()));
            PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfo);
        }
        JDomUtils.addChild((Element)transferReq, (Element)requests);
        JDomUtils.addChild((Element)root, (Element)tx);
        String requestMessage = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        log.info("\u3010\u4e2d\u94f6\u5feb\u6c47\u3011\u8bf7\u6c42\u62a5\u6587\uff1a" + requestMessage);
        return requestMessage;
    }

    public EBBankPayResponse parse(BankPayRequest request, String s) {
        List paymentInfos = request.getPaymentInfos();
        BOCHK_DC_Parser.overseaParsePay((List)paymentInfos, (String)s, (String)"BOCRemitPlus");
        return new EBBankPayResponse(paymentInfos);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }
}

