/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.LocalBankTrans;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BOCHK_DC_Constants;
import kd.ebg.aqap.banks.bochk.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.banks.bochk.dc.services.payment.LocalBankTrans.LocalBankTransQueryPayImpl;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccess;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccessManager;
import kd.ebg.aqap.banks.bochk.dc.utils.MultiLinesUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class LocalBankTransPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(LocalBankTransPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return LocalBankTransQueryPayImpl.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        try {
            la.getToken();
            Element BOCHKE2B = BOCHK_DC_Packer.createRootWithHead((String)paymentInfos[0].getPackageId());
            Element Tx = new Element("Tx");
            Element TransferREQ = new Element("TransferREQ");
            Element Requests = new Element("Requests");
            int num = paymentInfos.length;
            Requests.setAttribute("noOfRecord", Integer.toString(num));
            for (int j = 0; j < num; ++j) {
                Element Record = new Element("Record");
                Element LocalBankTrans = new Element("LocalBankTrans");
                JDomUtils.addChild((Element)LocalBankTrans, (String)"DDebitAcctNo", (String)paymentInfos[j].getAccNo());
                JDomUtils.addChild((Element)LocalBankTrans, (String)"DDebitCur", (String)paymentInfos[j].getCurrency());
                if (!BOCHK_DC_Packer.isBelowZero((BigDecimal)paymentInfos[j].getAmount())) {
                    JDomUtils.addChild((Element)LocalBankTrans, (String)"DebitAmt", (String)paymentInfos[j].getAmount().setScale(2).toString());
                } else {
                    JDomUtils.addChild((Element)LocalBankTrans, (String)"DebitAmt", (String)"");
                }
                if ("overseaPay".equals(paymentInfos[j].getSubBizType()) || "foreignPay".equals(paymentInfos[j].getSubBizType())) {
                    String bankCode = paymentInfos[j].getPayeeBankCode();
                    if (StringUtils.isNotEmpty((String)paymentInfos[j].getIncomeBankLocalClearingCode())) {
                        bankCode = paymentInfos[j].getIncomeBankLocalClearingCode();
                    }
                    JDomUtils.addChild((Element)LocalBankTrans, (String)"BeneBankCode", (String)bankCode);
                } else {
                    JDomUtils.addChild((Element)LocalBankTrans, (String)"BeneBankCode", (String)paymentInfos[j].getIncomeCnaps());
                }
                JDomUtils.addChild((Element)LocalBankTrans, (String)"BeneBranchCode", (String)paymentInfos[j].getIncomeBankLocalClearingBranchCode());
                JDomUtils.addChild((Element)LocalBankTrans, (String)"BeneAcctNo", (String)paymentInfos[j].getIncomeAccNo());
                Element BeneNameAddr = new Element("BeneNameAddr");
                List<String> incomeAccNames = MultiLinesUtils.build(paymentInfos[j].getIncomeAccName(), 4);
                for (String line : incomeAccNames) {
                    JDomUtils.addChild((Element)BeneNameAddr, (String)"Line", (String)line);
                }
                JDomUtils.addChild((Element)LocalBankTrans, (Element)BeneNameAddr);
                JDomUtils.addChild((Element)LocalBankTrans, (String)"PaymentCur", (String)paymentInfos[j].getPayCurrency());
                if (BankBusinessConfig.getBOC_HK_IS_NEED_ACTUAL() && !BOCHK_DC_Packer.isBelowZero((BigDecimal)paymentInfos[j].getActualAmount())) {
                    JDomUtils.addChild((Element)LocalBankTrans, (String)"EquvAmt", (String)paymentInfos[j].getActualAmount().setScale(2).toString());
                } else {
                    JDomUtils.addChild((Element)LocalBankTrans, (String)"EquvAmt", (String)"");
                }
                Element ChargeFrom = JDomUtils.addChild((Element)LocalBankTrans, (String)"ChargeFrom");
                Element ChargeFromAcct = JDomUtils.addChild((Element)ChargeFrom, (String)"ChargeFromAcct");
                JDomUtils.addChild((Element)ChargeFromAcct, (String)"ChargeAcctNo", (String)paymentInfos[j].getAccNo());
                JDomUtils.addChild((Element)ChargeFromAcct, (String)"ChargeCur", (String)paymentInfos[j].getCurrency());
                if (StringUtils.isEmpty((String)paymentInfos[j].getPayerFeeType()) || "01".equals(paymentInfos[j].getPayerFeeType())) {
                    JDomUtils.addChild((Element)ChargeFromAcct, (String)"ChargeBorneBy", (String)"A");
                } else {
                    JDomUtils.addChild((Element)ChargeFromAcct, (String)"ChargeBorneBy", (String)"B");
                }
                Element PaymentDetail = new Element("PaymentDetail");
                List<String> explanations = MultiLinesUtils.build(paymentInfos[j].getExplanation(), 4);
                for (String line : explanations) {
                    JDomUtils.addChild((Element)PaymentDetail, (String)"Line", (String)line);
                }
                JDomUtils.addChild((Element)LocalBankTrans, (Element)PaymentDetail);
                JDomUtils.addChild((Element)LocalBankTrans, (String)"CustRef", (String)paymentInfos[j].getBankDetailSeqId());
                JDomUtils.addChild((Element)LocalBankTrans, (String)"ExContract", (String)paymentInfos[j].getExContract());
                JDomUtils.addChild((Element)LocalBankTrans, (String)"ValueDate", (String)BOCHK_DC_Packer.valueDate((LocalDateTime)paymentInfos[j].getBookingTime()));
                PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfos[j]);
                JDomUtils.addChild((Element)Record, (Element)LocalBankTrans);
                JDomUtils.addChild((Element)Requests, (Element)Record);
            }
            JDomUtils.addChild((Element)TransferREQ, (Element)Requests);
            JDomUtils.addChild((Element)Tx, (Element)TransferREQ);
            JDomUtils.addChild((Element)BOCHKE2B, (Element)Tx);
            String requestMessage = JDomUtils.root2String((Element)BOCHKE2B, (String)RequestContextUtils.getCharset());
            log.info("\u3010\u672c\u5730\u9280\u884c\u8f49\u8cec\u3011\u8bf7\u6c42\u62a5\u6587\uff1a" + requestMessage);
            String string = requestMessage;
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (EBServiceException e) {
                log.info("\u3010\u672c\u5730\u9280\u884c\u8f49\u8cec\u3011\u51fa\u9519\uff1a%s", (Object)e.getLocalizedMessage());
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        try {
            Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
            BankResponse bankRsp = BOCHK_DC_Parser.parseHead((Element)root);
            if ("F".equals(bankRsp.getResponseCode()) || "R".equals(bankRsp.getResponseCode())) {
                LocalBankTransPayImpl.trySetErrMsg(root, paymentInfos);
                return new EBBankPayResponse(Arrays.asList(paymentInfos));
            }
            if (!"S".equals(bankRsp.getResponseCode())) {
                String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
                String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"LocalBankTransPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)ErrorCode, (String)ErrorDesc);
                return new EBBankPayResponse(Arrays.asList(paymentInfos));
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"LocalBankTransPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u8be5\u7b14\u4ea4\u6613\u72b6\u6001\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u4ed8\u6b3e\u72b6\u6001\u540c\u6b65\u64cd\u4f5c\u3002", (String)"LocalBankTransPayImpl_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            Element transferRLY = root.getChild("Tx").getChild("TransferRLY");
            Element Requests = transferRLY.getChild("Requests");
            Element DebitAcctNo = transferRLY.getChild("DebitAcctNo");
            List requestList = Requests.getChildren();
            block2: for (int i = 0; i < requestList.size(); ++i) {
                Element record = (Element)requestList.get(i);
                Element localBankTrans = record.getChild("LocalBankTrans");
                if (null == localBankTrans) continue;
                String CustRef = localBankTrans.getChildTextTrim("CustRef");
                for (int j = 0; j < paymentInfos.length; ++j) {
                    String RecordErrorDesc;
                    String RecordErrorCode;
                    String RecordStatus;
                    String actualAmountStr;
                    if (!CustRef.equals(paymentInfos[j].getBankDetailSeqId())) continue;
                    String amountStr = JDomUtils.getChildText((Element)localBankTrans, (String)"DebitAmt");
                    if (!StringUtils.isEmpty((String)amountStr)) {
                        paymentInfos[j].setAmount(new BigDecimal(amountStr));
                    }
                    if (!StringUtils.isEmpty((String)(actualAmountStr = JDomUtils.getChildText((Element)localBankTrans, (String)"EquvAmt")))) {
                        paymentInfos[j].setActualAmount(new BigDecimal(actualAmountStr));
                    }
                    if ("S".equals(RecordStatus = localBankTrans.getChildTextTrim("RecordStatus"))) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"LocalBankTransPayImpl_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)"", (String)"");
                        continue block2;
                    }
                    if ("F".equals(RecordStatus)) {
                        RecordErrorCode = localBankTrans.getChildTextTrim("RecordErrorCode");
                        RecordErrorDesc = localBankTrans.getChildTextTrim("RecordErrorDesc");
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"LocalBankTransPayImpl_3", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)RecordErrorCode, (String)RecordErrorDesc);
                        continue block2;
                    }
                    RecordErrorCode = localBankTrans.getChildTextTrim("RecordErrorCode");
                    RecordErrorDesc = localBankTrans.getChildTextTrim("RecordErrorDesc");
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"LocalBankTransPayImpl_4", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)RecordErrorCode, (String)RecordErrorDesc);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"LocalBankTransPayImpl_4", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u89e3\u6790\u4ed8\u6b3e\u62a5\u6587\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"LocalBankTransPayImpl_5", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)e.getMessage());
        }
        return new EBBankPayResponse(Arrays.asList(paymentInfos));
    }

    public static void trySetErrMsg(Element root, PaymentInfo[] paymentInfos) {
        String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
        String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"LocalBankTransPayImpl_3", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)ErrorCode, (String)ErrorDesc);
        Element Requests = root.getChild("Tx").getChild("TransferRLY").getChild("Requests");
        List requestList = Requests.getChildren();
        int min = requestList.size() <= paymentInfos.length ? requestList.size() : paymentInfos.length;
        for (int i = 0; i < min; ++i) {
            Element record = (Element)requestList.get(i);
            Element LocalBankTrans = record.getChild("LocalBankTrans");
            if (null == LocalBankTrans) continue;
            String RecordStatus = LocalBankTrans.getChildTextTrim("RecordStatus");
            String RecordErrorDesc = LocalBankTrans.getChildTextTrim("RecordErrorDesc");
            RecordErrorDesc = StringUtils.isEmpty((String)RecordErrorDesc) ? ErrorDesc : RecordErrorDesc;
            paymentInfos[i].setBankStatus(RecordStatus);
            paymentInfos[i].setBankMsg(RecordStatus + "-" + RecordErrorDesc);
        }
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "TransferREQ - LocalBankTrans";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u672c\u5730\u884c\u8f6c\u8d26", (String)"LocalBankTransPayImpl_6", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BizName.QueryPay.PAY_FOR_SALARY.name().equalsIgnoreCase(paymentInfo.getSubBizType()) || BizName.OVERSEAPAY.name().equalsIgnoreCase(paymentInfo.getSubBizType()) ? BOCHK_DC_Constants.getLOCAL_BANK_TRANS().equals(paymentInfo.getUseCN()) : !paymentInfo.is2SameBank();
    }
}

