/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.ins;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BOCHK_DC_Constants;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ins.InsTransferEnquiry;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ins.InsUtils;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccess;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccessManager;
import kd.ebg.aqap.banks.bochk.dc.utils.MultiLinesUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InsFPS
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InsTransferEnquiry.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest bankPayRequest) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        paymentInfo.setBankRefID(this.getBizCode());
        try {
            la.getToken();
            Element root = BOCHK_DC_Packer.createRootWithHead((String)paymentInfo.getPackageId());
            Element tx = new Element("Tx");
            Element InsFPSREQ = JDomUtils.addChild((Element)tx, (String)"InsFPSREQ");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"DebitAcctNo", (String)paymentInfo.getAccNo());
            if (paymentInfo.isDiffCurrency()) {
                JDomUtils.addChild((Element)InsFPSREQ, (String)"DebitCur", (String)bankPayRequest.getAcnt().getCurrency());
                JDomUtils.addChild((Element)InsFPSREQ, (String)"DebitAmt", (String)"");
            } else {
                JDomUtils.addChild((Element)InsFPSREQ, (String)"DebitCur", (String)paymentInfo.getCurrency());
                JDomUtils.addChild((Element)InsFPSREQ, (String)"DebitAmt", (String)paymentInfo.getAmount().toPlainString());
            }
            JDomUtils.addChild((Element)InsFPSREQ, (String)"BeneType", (String)"B");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"BeneAcctNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)InsFPSREQ, (String)"BeneCountryCode", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"BeneTel", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"BeneEmail", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"BeneFPSId", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"BeneHKId", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"BeneName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)InsFPSREQ, (String)"BeneBankCode", (String)paymentInfo.getIncomeBankLocalClearingCode());
            if (paymentInfo.isDiffCurrency()) {
                JDomUtils.addChild((Element)InsFPSREQ, (String)"PaymentCur", (String)paymentInfo.getCurrency());
                JDomUtils.addChild((Element)InsFPSREQ, (String)"EquvAmt", (String)paymentInfo.getAmount().toPlainString());
            } else {
                JDomUtils.addChild((Element)InsFPSREQ, (String)"PaymentCur", (String)"");
                JDomUtils.addChild((Element)InsFPSREQ, (String)"EquvAmt", (String)"");
            }
            JDomUtils.addChild((Element)InsFPSREQ, (String)"ChargesOption", (String)"SHA");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"ChargeAcctNo", (String)paymentInfo.getPayerFeeAccNo());
            JDomUtils.addChild((Element)InsFPSREQ, (String)"ChargeCur", (String)paymentInfo.getPayerFeeCurrency());
            JDomUtils.addChild((Element)InsFPSREQ, (String)"BillNo", (String)"");
            Element PaymentDetail = JDomUtils.addChild((Element)InsFPSREQ, (String)"PaymentDetail");
            List<String> explanations = MultiLinesUtils.buildFPS(paymentInfo.getExplanation(), 5);
            for (String line : explanations) {
                JDomUtils.addChild((Element)PaymentDetail, (String)"Line", (String)line);
            }
            Element PaymentMemo = JDomUtils.addChild((Element)InsFPSREQ, (String)"PaymentMemo");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"CustRef", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"ExContract", (String)paymentInfo.getContractNo());
            JDomUtils.addChild((Element)InsFPSREQ, (String)"ValueDate", (String)BOCHK_DC_Packer.valueDate((LocalDateTime)paymentInfo.getBookingTime()));
            JDomUtils.addChild((Element)InsFPSREQ, (String)"SendEmail", (String)"N");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"Email1", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"Email2", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"Email3", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"Email4", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"Email5", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"CarbonToMyEmail", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"SiControlBit", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"InstrName", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"SiCycle", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"SiCycleStartDate", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"SiEndType", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"SiCycleEndDate", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"CycleCnt", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"HoldFromDate", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"HoldToDate", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"RateType", (String)"");
            JDomUtils.addChild((Element)InsFPSREQ, (String)"RateSet", (String)"");
            JDomUtils.addChild((Element)root, (Element)tx);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91ca\u653e\u8bbf\u95ee\u7968", (String)"TeleTransferPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        InsUtils.parsePay(paymentInfos, s, "InsFPSRLY");
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "InsFPS";
    }

    public String getBizDesc() {
        return BOCHK_DC_Constants.InsFPS();
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BOCHK_DC_Constants.InsFPS().equalsIgnoreCase(paymentInfo.getUseCN()) || paymentInfo.getUseCN().startsWith(this.getBizCode());
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }
}

