/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.ins;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BOCHK_DC_Constants;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ins.InsTransferEnquiry;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ins.InsUtils;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccess;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccessManager;
import kd.ebg.aqap.banks.bochk.dc.utils.MultiLinesUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InsRTGS
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InsTransferEnquiry.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest bankPayRequest) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        paymentInfo.setBankRefID(this.getBizCode());
        try {
            la.getToken();
            Element root = BOCHK_DC_Packer.createRootWithHead((String)paymentInfo.getPackageId());
            Element tx = new Element("Tx");
            Element InsRTGSREQ = JDomUtils.addChild((Element)tx, (String)"InsRTGSREQ");
            CountryISOCode payerCountry = InsUtils.getOrThrow(paymentInfo.getAccCountry(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u65b9\u8d26\u6237\u56fd\u5bb6\u5730\u533a\u5fc5\u586b\u3002", (String)"InsTeleTransfer_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"DebitRegion", (String)payerCountry.geteChart2());
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"DebitAcctNo", (String)paymentInfo.getAccNo());
            if (paymentInfo.isDiffCurrency()) {
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"DebitCur", (String)bankPayRequest.getAcnt().getCurrency());
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"DebitAmt", (String)"");
            } else {
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"DebitCur", (String)paymentInfo.getCurrency());
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"DebitAmt", (String)paymentInfo.getAmount().toPlainString());
            }
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneType", (String)"B");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneBankCode", (String)paymentInfo.getIncomeBankLocalClearingCode());
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneAcctNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneAcctName", (String)paymentInfo.getIncomeAccName());
            Element BeneAddr = JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneAddr");
            if (!"ID".equalsIgnoreCase(payerCountry.geteChart2())) {
                JDomUtils.addChild((Element)BeneAddr, (String)"Line", (String)"");
                JDomUtils.addChild((Element)BeneAddr, (String)"Line", (String)"");
                JDomUtils.addChild((Element)BeneAddr, (String)"Line", (String)"");
            } else {
                int payeeNameLen = MultiLinesUtils.computeLength(paymentInfo.getIncomeAccName());
                int limit = 133 - payeeNameLen;
                String payeeAddress = paymentInfo.getIncomeAddress();
                List<Object> addrLines = payeeNameLen > 35 && payeeNameLen < 71 ? InsUtils.splitBy(payeeAddress, Lists.newArrayList((Object[])new Integer[]{31, 32}), limit) : (payeeNameLen > 70 && payeeNameLen < 106 ? InsUtils.splitBy(payeeAddress, Lists.newArrayList((Object[])new Integer[]{28}), limit) : (payeeNameLen > 105 ? new ArrayList(0) : InsUtils.splitBy(payeeAddress, Lists.newArrayList((Object[])new Integer[]{31, 35, 32}), limit)));
                for (String string : addrLines) {
                    JDomUtils.addChild((Element)BeneAddr, (String)"Line", (String)string);
                }
            }
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneCity", (String)"");
            if ("ID".equalsIgnoreCase(payerCountry.geteChart2())) {
                InsRTGSREQ.getChild("BeneCity").setText(paymentInfo.getIncomeCity());
            }
            CountryISOCode payeeCountry = InsUtils.getOrThrow(paymentInfo.getIncomeCountry(), ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\u5730\u533a(incomeCountry)\u5fc5\u586b\u3002", (String)"InsTeleTransfer_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneRegion", (String)payeeCountry.geteChart2());
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneBankName", (String)paymentInfo.getIncomeBankName());
            if (paymentInfo.isDiffCurrency()) {
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"PaymentCur", (String)paymentInfo.getCurrency());
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"EquvAmt", (String)paymentInfo.getAmount().toPlainString());
            } else {
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"PaymentCur", (String)"");
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"EquvAmt", (String)"");
            }
            if ("01".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargesOption", (String)"OUR");
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargeAcctRegion", (String)payerCountry.geteChart2());
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargeAcctNo", (String)paymentInfo.getPayerFeeAccNo());
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargeCur", (String)paymentInfo.getPayerFeeCurrency());
            } else if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargesOption", (String)"BEN");
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargeAcctRegion", (String)"");
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargeAcctNo", (String)"");
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargeCur", (String)"");
            } else {
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargesOption", (String)"SHA");
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargeAcctRegion", (String)payerCountry.geteChart2());
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargeAcctNo", (String)paymentInfo.getPayerFeeAccNo());
                JDomUtils.addChild((Element)InsRTGSREQ, (String)"ChargeCur", (String)paymentInfo.getPayerFeeCurrency());
            }
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"PayPurpose", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"PayPurposeOths1", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"PayPurposeOths2", (String)"");
            Element PaymentDetail = JDomUtils.addChild((Element)InsRTGSREQ, (String)"PaymentDetail");
            List<String> explanations = MultiLinesUtils.build(paymentInfo.getExplanation(), 4);
            for (String line : explanations) {
                JDomUtils.addChild((Element)PaymentDetail, (String)"Line", (String)line);
            }
            Element PaymentMemo = JDomUtils.addChild((Element)InsRTGSREQ, (String)"PaymentMemo");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"CustRef", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"ExContract", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"ValueDate", (String)BOCHK_DC_Packer.valueDate((LocalDateTime)paymentInfo.getBookingTime()));
            Element Requests = JDomUtils.addChild((Element)InsRTGSREQ, (String)"Requests");
            Requests.setAttribute("noOfRecord", "1");
            Element element = JDomUtils.addChild((Element)Requests, (String)"Record");
            JDomUtils.addChild((Element)element, (String)"SupplePackageId", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmailBit", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmail1", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmail2", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmail3", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmail4", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmail5", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmail6", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmail7", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmail8", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmail9", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"BeneEmail10", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"CarbonToMyEmail", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"InstrName", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"SiCycle", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"SiCycleStartDate", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"SiEndType", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"SiCycleEndDate", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"CycleCnt", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"HoldFromDate", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"HoldToDate", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"RateType", (String)"");
            JDomUtils.addChild((Element)InsRTGSREQ, (String)"RateSet", (String)"");
            JDomUtils.addChild((Element)root, (Element)tx);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91ca\u653e\u8bbf\u95ee\u7968", (String)"TeleTransferPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        InsUtils.parsePay(paymentInfos, s, "InsRTGSRLY");
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "InsRTGS";
    }

    public String getBizDesc() {
        return BOCHK_DC_Constants.InsRTGS();
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BOCHK_DC_Constants.InsRTGS().equalsIgnoreCase(paymentInfo.getUseCN()) || paymentInfo.getUseCN().startsWith(this.getBizCode());
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }
}

