/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.ins;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BOCHK_DC_Constants;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ins.InsUtils;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccess;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccessManager;
import kd.ebg.aqap.business.bankstatus.IBankStatus;
import kd.ebg.aqap.business.bankstatus.Status;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InsTransferEnquiry
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest bankPayRequest) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        try {
            la.getToken();
            Element root = BOCHK_DC_Packer.createRootWithHead((String)paymentInfo.getPackageId());
            Element tx = new Element("Tx");
            Element insTransEnquiryREQ = JDomUtils.addChild((Element)tx, (String)"InsTransEnquiryREQ");
            JDomUtils.addChild((Element)insTransEnquiryREQ, (String)"TransType", (String)paymentInfo.getBankRefID());
            JDomUtils.addChild((Element)insTransEnquiryREQ, (String)"IGTBRef", (String)"");
            JDomUtils.addChild((Element)insTransEnquiryREQ, (String)"EnqPackageId", (String)paymentInfo.getPackageId());
            JDomUtils.addChild((Element)insTransEnquiryREQ, (String)"FileRefNo", (String)"");
            JDomUtils.addChild((Element)root, (Element)tx);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91ca\u653e\u8bbf\u95ee\u7968", (String)"TeleTransferPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankRsp = BOCHK_DC_Parser.parseHead((Element)root);
        if (!"S".equals(bankRsp.getResponseCode())) {
            String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
            String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ErrorCode, (String)ErrorDesc);
        } else {
            String transType = paymentInfo.getBankRefID();
            Element TxStatus2 = InsUtils.getTarget(root, Lists.newArrayList((Object[])new String[]{"Tx", "InsTransEnquiryRLY", transType, "TxStatus"}));
            Element RejectReason = InsUtils.getTarget(root, Lists.newArrayList((Object[])new String[]{"Tx", "InsTransEnquiryRLY", transType, "RejectReason"}));
            TxStatus intoEBGTxStatus = new TxStatus();
            Status status = intoEBGTxStatus.get(TxStatus2.getTextTrim());
            if (status == null) {
                status = Status.newStatus((String)TxStatus2.getTextTrim(), (String)TxStatus2.getTextTrim(), (PaymentState)PaymentState.UNKNOWN);
            }
            if (status.getEbgState() == PaymentState.FAIL || status.getEbgState() == PaymentState.UNKNOWN) {
                String error = RejectReason.getTextTrim();
                if (StringUtils.isEmpty((String)error)) {
                    error = status.getStatusDesc();
                }
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)status.getEbgState(), (String)"", (String)status.getStatusCode(), (String)error);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)status.getEbgState(), (String)"", (String)status.getStatusCode(), (String)status.getStatusDesc());
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "InsTransferEnquiry";
    }

    public String getBizDesc() {
        return BOCHK_DC_Constants.InsInquiry();
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }

    public static class TxStatus
    implements IBankStatus {
        public List<Status> getStatusList() {
            return Lists.newArrayList((Object[])new Status[]{Status.newStatus((String)"Completed", (String)"", (PaymentState)PaymentState.SUCCESS), Status.newStatus((String)"Rejected", (String)"Rejected", (PaymentState)PaymentState.FAIL), Status.newStatus((String)"Pending 1st Authorisation", (String)"", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Pending 2nd Authorisation", (String)"", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Pending 3rd Authorisation", (String)"", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Pending 1st Check", (String)"", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Pending 2nd Check", (String)"", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Returned to Maker", (String)"Returned to Maker", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Awaiting for Customer's Instruction", (String)"Awaiting for Customer's Instruction", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Application is sent", (String)"Awaiting for Customer's Instruction", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Forward-dated", (String)"Awaiting for Customer's Instruction", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Rejected-Pending AutoRetry", (String)"Rejected-Pending AutoRetry", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Rejected-Pending for Manual-Retry", (String)"Rejected-Pending for Manual-Retry", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Received by Bank", (String)"Received by Bank", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Processing", (String)"Awaiting for Customer's Instruction", (PaymentState)PaymentState.SUBMITED), Status.newStatus((String)"Deleted", (String)"Deleted", (PaymentState)PaymentState.UNKNOWN), Status.newStatus((String)"Draft", (String)"Draft", (PaymentState)PaymentState.UNKNOWN), Status.newStatus((String)"Pending Check", (String)"Pending Check", (PaymentState)PaymentState.UNKNOWN), Status.newStatus((String)"Pending Authorisation", (String)"Pending Authorisation", (PaymentState)PaymentState.UNKNOWN), Status.newStatus((String)"", (String)"Unknown TxStatus", (PaymentState)PaymentState.UNKNOWN)});
        }
    }
}

