/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.ins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.banks.bochk.dc.utils.MultiLinesUtils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InsUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(InsUtils.class);

    public static CountryISOCode getOrThrow(String country, String message) {
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(country);
        if (null == code) {
            code = ISOCountryUtils.getInstance().getCountryInfo(country);
        }
        if (code == null) {
            throw EBExceiptionUtil.serviceException((String)message);
        }
        return code;
    }

    public static void parsePay(List<PaymentInfo> paymentInfos, String s, String node) {
        try {
            Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
            BankResponse bankRsp = BOCHK_DC_Parser.parseHead((Element)root);
            if ("F".equals(bankRsp.getResponseCode()) || "R".equals(bankRsp.getResponseCode())) {
                String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
                String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)ErrorCode, (String)ErrorDesc);
                return;
            }
            if (!"S".equals(bankRsp.getResponseCode())) {
                Element code = InsUtils.getTarget(root, Lists.newArrayList((Object[])new String[]{"Tx", node, "ErrorCode"}));
                Element desc = InsUtils.getTarget(root, Lists.newArrayList((Object[])new String[]{"Tx", node, "ErrorDesc"}));
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code.getTextTrim(), (String)desc.getTextTrim());
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u8fd4\u56de\u62a5\u6587\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u8fd4\u56de\u62a5\u6587\u53d1\u751f\u5f02\u5e38\u3002", (String)"BOCHK_DC_Parser_5", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
        }
    }

    public static Element getTarget(Element root, List<String> paths) {
        if (root == null) {
            return new Element("NaN");
        }
        if (paths.isEmpty()) {
            return root;
        }
        String path = paths.remove(0);
        return InsUtils.getTarget(root.getChild(path), paths);
    }

    public static List<String> splitBy(String inputString, List<Integer> substringLengths, int maxLength) {
        if (MultiLinesUtils.computeLength(inputString) > maxLength) {
            inputString = MultiLinesUtils.truncateString(inputString, maxLength);
        }
        ArrayList<String> substrings = new ArrayList<String>(substringLengths.size());
        for (int length : substringLengths) {
            String sub = MultiLinesUtils.truncateString(inputString, length);
            substrings.add(sub);
            inputString = inputString.substring(inputString.indexOf(sub) + sub.length());
        }
        return substrings;
    }
}

