/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ebg.aqap.banks.bochk.dc.utils.MultiLinesUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class MultiLinesUtils {
    private static final int CHAR_LINK_LENGTH = 1;
    private static final int MAX_LINE_LENGTH = 35;
    private static final int MAX_LINE_LENGTH_FPS = 28;

    public static int computeLength(String oriStr) {
        char[] chars;
        int length = 0;
        for (char ch : chars = oriStr.toCharArray()) {
            CharType curCharType = MultiLinesUtils.isDbcCase(ch) ? CharType.CHINESE : CharType.ENGLISH;
            length += curCharType.getLength();
        }
        return length;
    }

    public static String truncateString(String input, int maxLength) {
        int currentLength = 0;
        StringBuilder truncatedString = new StringBuilder();
        for (char ch : input.toCharArray()) {
            int charLength;
            int n = charLength = MultiLinesUtils.isDbcCase(ch) ? CharType.CHINESE.getLength() : CharType.ENGLISH.getLength();
            if (currentLength + charLength > maxLength) break;
            truncatedString.append(ch);
            currentLength += charLength;
        }
        return truncatedString.toString();
    }

    public static List<String> build(String oriStr, int lineNum) {
        char[] chars;
        if (lineNum <= 0 || StringUtils.isEmpty((String)oriStr)) {
            return Collections.singletonList("");
        }
        ArrayList<StringBuffer> sbs = new ArrayList<StringBuffer>();
        int curLine = 0;
        int curLineLength = 0;
        CharType lastCharType = CharType.EMPTY;
        sbs.add(new StringBuffer());
        for (char ch : chars = oriStr.toCharArray()) {
            CharType curCharType = MultiLinesUtils.isDbcCase(ch) ? CharType.CHINESE : CharType.ENGLISH;
            int linkLength = curCharType != lastCharType && lastCharType != CharType.EMPTY ? 1 : 0;
            int tempLineLength = curLineLength + curCharType.getLength() + linkLength;
            if (tempLineLength <= 35) {
                ((StringBuffer)sbs.get(curLine)).append(ch);
                curLineLength += curCharType.getLength();
                lastCharType = curCharType;
                continue;
            }
            if (++curLine >= lineNum) break;
            sbs.add(new StringBuffer());
            ((StringBuffer)sbs.get(curLine)).append(ch);
            curLineLength = curCharType.getLength();
            lastCharType = CharType.EMPTY;
        }
        ArrayList<String> lines = new ArrayList<String>(1);
        for (StringBuffer sb : sbs) {
            lines.add(sb.toString());
        }
        return lines;
    }

    public static List<String> buildFPS(String oriStr, int lineNum) {
        char[] chars;
        if (lineNum <= 0 || StringUtils.isEmpty((String)oriStr)) {
            return Collections.singletonList("");
        }
        ArrayList<StringBuffer> sbs = new ArrayList<StringBuffer>();
        int curLine = 0;
        int curLineLength = 0;
        CharType lastCharType = CharType.EMPTY;
        sbs.add(new StringBuffer());
        for (char ch : chars = oriStr.toCharArray()) {
            CharType curCharType = MultiLinesUtils.isDbcCase(ch) ? CharType.CHINESE : CharType.ENGLISH;
            int linkLength = curCharType != lastCharType && lastCharType != CharType.EMPTY ? 1 : 0;
            int tempLineLength = curLineLength + curCharType.getLength() + linkLength;
            if (tempLineLength <= 28) {
                ((StringBuffer)sbs.get(curLine)).append(ch);
                curLineLength += curCharType.getLength();
                lastCharType = curCharType;
                continue;
            }
            if (++curLine >= lineNum) break;
            sbs.add(new StringBuffer());
            ((StringBuffer)sbs.get(curLine)).append(ch);
            curLineLength = curCharType.getLength();
            lastCharType = CharType.EMPTY;
        }
        ArrayList<String> lines = new ArrayList<String>(1);
        for (StringBuffer sb : sbs) {
            lines.add(sb.toString());
        }
        return lines;
    }

    private static final boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    private static boolean isDbcCase(char c) {
        if (c >= ' ' && c <= '\u007f') {
            return false;
        }
        return c < '\uff61' || c > '\uff9f';
    }
}

