/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.BatchPayerInfos;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.CEB_DCFileUtils;
import kd.ebg.aqap.banks.ceb.dc.services.proxy.FileUpload;
import kd.ebg.aqap.banks.ceb.dc.utils.DateHelper;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PayPacker {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(PayPacker.class);

    public static String packPay(List<PaymentInfo> paymentInfos, String bizSeqId) throws EBServiceException {
        return PayPacker.packAcceptXML(paymentInfos, bizSeqId);
    }

    private static String packAcceptXML(List<PaymentInfo> paymentInfos, String bizSeqId) throws EBServiceException {
        String fileName = paymentInfos.get(0).getBankBatchSeqId() + ".txt";
        String fileContent = PayPacker.packUploadFileContentStr(paymentInfos);
        log.info("\u6253\u5305\u4e0a\u4f20\u6587\u4ef6\u6210\u529f\u5185\u5bb9\u4e3a: " + fileContent);
        try {
            FileUpload fileUpload = new FileUpload();
            fileUpload.setFileContent(fileContent);
            fileUpload.doBiz(fileName);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5411\u91d1\u8776\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (String)"PayPacker_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        log.info("\u6587\u4ef6\u4e0a\u4f20\u7ed3\u675f===\u5f00\u59cb\u53d1\u9001\u4e0a\u4f20\u6587\u4ef6\u8bf7\u6c42");
        String uploadHead = PayPacker.getUploadFilePackHead("uploadFile", fileName, paymentInfos.get(0).getBankBatchSeqId());
        String bankReturnFileName = null;
        try {
            String resp = CEB_DCFileUtils.sendAndRecvMsg(bizSeqId, uploadHead, PayPacker.getUploadFilePackString(paymentInfos.get(0)));
            bankReturnFileName = PayPacker.parserBatchPayUploadFile(paymentInfos, resp);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5411\u94f6\u884c\u524d\u7f6e\u673a\u53d1\u8d77\u4e0a\u4f20\u6587\u4ef6\u8bf7\u6c42\u5f02\u5e38\u3002", (String)"PayPacker_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)bankReturnFileName)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25===\u94f6\u884c\u8fd4\u56de\u7684\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"PayPacker_5", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
        }
        log.info("\u6587\u4ef6\u4e0a\u4f20\u8bf7\u6c42\u7ed3\u675f,\u5f00\u59cb\u53d1\u9001\u4ee3\u53d1\u786e\u8ba4==\u6587\u4ef6\u540d\uff1a" + bankReturnFileName);
        String msg = PayPacker.packBatchPayAccept(paymentInfos, bankReturnFileName);
        return msg;
    }

    public static String packUploadFileContentStr(List<PaymentInfo> paymentInfos) {
        StringBuilder spitBuffer = new StringBuilder();
        spitBuffer.append("JIAMBZ").append(':').append('0');
        spitBuffer.append("\n");
        spitBuffer.append("DANWBH").append(':').append("00000000");
        spitBuffer.append("\n");
        if (UseConvertor.isSalary((PaymentInfo)paymentInfos.get(0))) {
            spitBuffer.append("YWZLBH").append(':').append("0008");
        } else {
            spitBuffer.append("YWZLBH").append(':').append("0092");
        }
        spitBuffer.append("\n");
        spitBuffer.append("KHZHLX").append(':').append("0");
        spitBuffer.append("\n");
        String accountNo = RequestContextUtils.getRunningParam((String)"XZAccountNo");
        if (StringUtils.isEmpty((String)accountNo)) {
            spitBuffer.append("KEHUZH").append(':').append(paymentInfos.get(0).getAccNo());
        } else {
            spitBuffer.append("KEHUZH").append(':').append(accountNo);
        }
        spitBuffer.append("\n");
        spitBuffer.append("HUOBDH").append(':').append("01");
        spitBuffer.append("\n");
        spitBuffer.append("CHUIBZ").append(':').append('0');
        spitBuffer.append("\n");
        spitBuffer.append("ZHHUXZ").append(':').append("0001");
        spitBuffer.append("\n");
        spitBuffer.append("SHOFBZ").append(':').append('1');
        spitBuffer.append("\n");
        spitBuffer.append("ZONGJE").append(':').append(PayPacker.getTotalAmount(paymentInfos));
        spitBuffer.append("\n");
        spitBuffer.append("BISHUU").append(':').append(paymentInfos.size());
        spitBuffer.append("\n");
        spitBuffer.append("RUZHRQ").append(':').append(DateHelper.currentDate());
        spitBuffer.append("\n");
        spitBuffer.append("---------------------------------");
        spitBuffer.append("\n");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            spitBuffer.append(paymentInfos.get(i).getIncomeAccNo()).append("|");
            spitBuffer.append(paymentInfos.get(i).getAmount()).append("|");
            spitBuffer.append(paymentInfos.get(i).getIncomeAccName()).append("|");
            spitBuffer.append(paymentInfos.get(i).getExplanation()).append("|");
            spitBuffer.append(paymentInfos.get(i).getInsertBatchSeq()).append("|");
            spitBuffer.append("\n");
        }
        return spitBuffer.toString();
    }

    private static String getUploadFilePackHead(String bizUrl, String fileName, String clientPathID) throws EBServiceException {
        StringBuilder sb = new StringBuilder();
        sb.append("/ent/");
        sb.append(bizUrl);
        sb.append(".do");
        sb.append("?");
        sb.append("userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"UserPassword"));
        sb.append("&transcode=");
        sb.append("b2e005005");
        sb.append("&fileName=");
        sb.append(fileName);
        sb.append("&ClientPatchID=");
        sb.append(clientPathID);
        return sb.toString();
    }

    private static String getUploadFilePackString(PaymentInfo paymentinfo) throws EBServiceException {
        Element rootElement = BatchPayerInfos.createSysHeader((PaymentInfo)paymentinfo, (String)"b2e005005", (boolean)false);
        Element transContentElement = JDomUtils.addChild((Element)rootElement, (String)"TransContent");
        Element reqDataElement = JDomUtils.addChild((Element)transContentElement, (String)"ReqData");
        JDomUtils.addChild((Element)reqDataElement, (String)"ClientPatchID", (String)paymentinfo.getBankBatchSeqId());
        return JDomUtils.element2StringPlain((Element)rootElement, (String)RequestContextUtils.getCharset());
    }

    public static String parserBatchPayUploadFile(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        Namespace namespace;
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element SystemHead = root.getChild("SystemHead", namespace = root.getNamespace());
        if (null == SystemHead) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
            if ("B2E000010".equalsIgnoreCase(ReturnCode) || "B2E000011".equalsIgnoreCase(ReturnCode) || "B2E000012".equalsIgnoreCase(ReturnCode)) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u901a\u8baf\u6545\u969c", (String)"PayPacker_2", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)ReturnCode, (String)ReturnMsg);
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u672a\u77e5", (String)"PayPacker_3", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)ReturnCode, (String)ReturnMsg);
            }
            return "";
        }
        Element TransContent = root.getChild("TransContent", namespace);
        Element RespData = TransContent.getChild("RespData", namespace);
        String fileName = RespData.getChildTextTrim("EbankFName", namespace);
        if (null == fileName || "".equalsIgnoreCase(fileName)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u610f\u5916\u7684\u6587\u4ef6\u540d\u3002", (String)"PayPacker_4", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
        }
        return fileName;
    }

    private static String packBatchPayAccept(List<PaymentInfo> paymentInfos, String fileName) throws EBServiceException {
        Element rootElement = BatchPayerInfos.createSysHeader((PaymentInfo)paymentInfos.get(0), (String)"b2e005005", (boolean)false);
        Element transContentElement = JDomUtils.addChild((Element)rootElement, (String)"TransContent");
        Element reqDataElement = JDomUtils.addChild((Element)transContentElement, (String)"ReqData");
        JDomUtils.addChild((Element)reqDataElement, (String)"ClientPatchID", (String)paymentInfos.get(0).getBankBatchSeqId());
        JDomUtils.addChild((Element)reqDataElement, (String)"AcNo", (String)paymentInfos.get(0).getAccNo());
        JDomUtils.addChild((Element)reqDataElement, (String)"Amount", (String)PayPacker.getTotalAmount(paymentInfos));
        JDomUtils.addChild((Element)reqDataElement, (String)"TotalPathes", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)reqDataElement, (String)"DealMode", (String)"1");
        JDomUtils.addChild((Element)reqDataElement, (String)"FileName", (String)fileName);
        JDomUtils.addChild((Element)reqDataElement, (String)"DealDate", (String)DateHelper.currentDate());
        JDomUtils.addChild((Element)reqDataElement, (String)"IsCheckUser", (String)"0");
        JDomUtils.addChild((Element)reqDataElement, (String)"ProtocolNum", (String)BankBusinessConfig.getProtocolNum(paymentInfos.get(0).getAccNo()));
        if (UseConvertor.isSalary((PaymentInfo)paymentInfos.get(0))) {
            JDomUtils.addChild((Element)reqDataElement, (String)"Flag", (String)"0");
        } else {
            JDomUtils.addChild((Element)reqDataElement, (String)"Flag", (String)"1");
        }
        JDomUtils.addChild((Element)reqDataElement, (String)"Note", (String)paymentInfos.get(0).getExplanation());
        String xmlMsg = JDomUtils.root2String((Element)rootElement, (String)RequestContextUtils.getCharset());
        return xmlMsg;
    }

    public static String getTotalAmount(List<PaymentInfo> paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.toString();
    }
}

