/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.newbatchPay;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.BatchIndividualQueryPayImpl;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.BatchPayerInfos;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.CEB_DCFileUtils;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.PayPacker;
import kd.ebg.aqap.banks.ceb.dc.services.payment.newbatchPay.QueryInnerAccountNo;
import kd.ebg.aqap.banks.ceb.dc.services.proxy.FileUpload;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.banks.ceb.dc.utils.DateHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class NewBatchIndividualPayImpl
extends AbstractPayImpl
implements IPay {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(NewBatchIndividualPayImpl.class);

    public int getBatchSize() {
        return 2000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return BatchIndividualQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "b2e005026";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e13\u5c5e\u4ee3\u53d1", (String)"NewBatchIndividualPayImpl_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        try {
            List paymentInfos = request.getPaymentInfos();
            QueryInnerAccountNo queryInnerAccountNo = new QueryInnerAccountNo();
            queryInnerAccountNo.doBiz(request);
            log.info("\u67e5\u8be2\u5f85\u9500\u8d26\u8d26\u53f7\u7ed3\u675f===\u5f00\u59cb\u6253\u5305\u4e0a\u4f20\u6587\u4ef6");
            String fileName = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId() + ".txt";
            String fileContent = PayPacker.packUploadFileContentStr(paymentInfos);
            log.info("\u6253\u5305\u4e0a\u4f20\u6587\u4ef6\u6210\u529f\u5185\u5bb9\u4e3a: " + fileContent);
            FileUpload fileUpload = new FileUpload();
            fileUpload.setFileContent(fileContent);
            fileUpload.doBiz(fileName);
            log.info("\u8c03\u7528\u4ee3\u7406\u7a0b\u5e8f\u4e0a\u4f20\u6587\u4ef6\u7ed3\u675f===\u5f00\u59cb\u53d1\u9001\u6587\u4ef6\u786e\u8ba4\u8bf7\u6c42");
            String uploadHead = NewBatchIndividualPayImpl.getUploadFilePackHead("uploadFile", fileName, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
            String bankFileName = "";
            try {
                String resp = CEB_DCFileUtils.sendAndRecvMsg("", uploadHead, "");
                bankFileName = PayPacker.parserBatchPayUploadFile(paymentInfos, resp);
            }
            catch (Exception e) {
                throw new EBServiceException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u8bf7\u6c42\u5f02\u5e38\u3002", (String)"NewBatchIndividualPayImpl_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)bankFileName)) {
                throw new EBServiceException(ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u94f6\u884c\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a,\u4ed8\u6b3e\u4e2d\u65ad", (String)"NewBatchIndividualPayImpl_2", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
            }
            log.info("\u6587\u4ef6\u786e\u8ba4\u7ed3\u675f===\u5f00\u59cb\u4e13\u5c5e\u4ee3\u53d1\u786e\u8ba4");
            String string = NewBatchIndividualPayImpl.packBatchPay(paymentInfos, bankFileName);
            return string;
        }
        finally {
            BankUtils.sleepQuietly();
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        NewBatchIndividualPayImpl.parserBatchPayAcceptInfo(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        StringBuilder builder = new StringBuilder();
        builder.append("/ent/b2e005026.do").append("?userPassword=").append(RequestContextUtils.getBankParameterValue((String)"UserPassword")).append("&Sigdata=").append("1");
        factory.setUri(builder.toString());
        return factory;
    }

    private static String packBatchPay(List<PaymentInfo> paymentInfos, String fileName) throws EBServiceException {
        Element rootElement = BatchPayerInfos.createSysHeader((PaymentInfo)paymentInfos.get(0), (String)"b2e005026", (boolean)false);
        Element transContentElement = JDomUtils.addChild((Element)rootElement, (String)"TransContent");
        Element reqDataElement = JDomUtils.addChild((Element)transContentElement, (String)"ReqData");
        JDomUtils.addChild((Element)reqDataElement, (String)"ClientPatchID", (String)paymentInfos.get(0).getBankBatchSeqId());
        JDomUtils.addChild((Element)reqDataElement, (String)"IssuAcNo", (String)paymentInfos.get(0).getAccNo());
        JDomUtils.addChild((Element)reqDataElement, (String)"Amount", (String)NewBatchIndividualPayImpl.getTotalAmount(paymentInfos));
        JDomUtils.addChild((Element)reqDataElement, (String)"TotalPathes", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)reqDataElement, (String)"DealMode", (String)"1");
        JDomUtils.addChild((Element)reqDataElement, (String)"FileName", (String)fileName);
        JDomUtils.addChild((Element)reqDataElement, (String)"DealDate", (String)DateHelper.currentDate());
        JDomUtils.addChild((Element)reqDataElement, (String)"IsCheckUser", (String)"0");
        JDomUtils.addChild((Element)reqDataElement, (String)"ProtocolNum", (String)BankBusinessConfig.getProtocolNum(paymentInfos.get(0).getAccNo()));
        JDomUtils.addChild((Element)reqDataElement, (String)"Flag", (String)"3");
        String xzAccountNo = RequestContextUtils.getRunningParam((String)"XZAccountNo");
        for (PaymentInfo paymentInfo : paymentInfos) {
            paymentInfo.setBiz("xzAccountNo", xzAccountNo);
        }
        JDomUtils.addChild((Element)reqDataElement, (String)"AccountOffNo", (String)xzAccountNo);
        String xmlMsg = JDomUtils.root2String((Element)rootElement, (String)RequestContextUtils.getCharset());
        return xmlMsg;
    }

    public static String getTotalAmount(List<PaymentInfo> paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.0");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.toString();
    }

    private static void parserBatchPayAcceptInfo(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        Namespace namespace;
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        String error = root.getChildTextTrim("error", namespace = root.getNamespace());
        if (!StringUtils.isEmpty((String)error)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)error);
            return;
        }
        Element TransContent = root.getChild("TransContent", namespace);
        String ReturnCode = TransContent.getChildTextTrim("ReturnCode", namespace);
        String ReturnMsg = TransContent.getChildTextTrim("ReturnMsg", namespace);
        if ("0000".equalsIgnoreCase(ReturnCode)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ReturnCode, (String)ReturnMsg);
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ReturnCode, (String)ReturnMsg);
        }
    }

    private static String getUploadFilePackHead(String bizUrl, String fileName, String clientPathID) throws EBServiceException {
        StringBuilder sb = new StringBuilder();
        sb.append("/ent/");
        sb.append(bizUrl);
        sb.append(".do");
        sb.append('?');
        sb.append("userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"UserPassword"));
        sb.append("&transcode=");
        sb.append("b2e005026");
        sb.append("&fileName=");
        sb.append(fileName);
        sb.append("&ClientPatchID=");
        sb.append(clientPathID);
        return sb.toString();
    }
}

