/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.utils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ceb.dc.utils.DateHelper;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public class BankUtils {
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static Map<String, String> USECN_MAP = new HashMap<String, String>(16);

    public static String createBatchID() throws EBServiceException {
        String userID = RequestContextUtils.getBankParameterValue((String)"UserID");
        return userID + DateHelper.currentDate() + Sequence.genSequence();
    }

    public static boolean isCashPoolAcnt(String accNo) throws EBServiceException {
        return "cashpool".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)accNo));
    }

    public static void createSystemHead(Element root, String reqAccNo) throws EBServiceException {
        String cifNo = BankUtils.getExclusiveCifNo(reqAccNo);
        String operatorID = RequestContextUtils.getBankParameterValue((String)"OperatorID");
        Element systemHead = new Element("SystemHead");
        JDomUtils.addChild((Element)systemHead, (String)"Language", (String)"zh_CN");
        JDomUtils.addChild((Element)systemHead, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Version", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"CifNo", (String)cifNo);
        JDomUtils.addChild((Element)systemHead, (String)"UserID", (String)operatorID);
        JDomUtils.addChild((Element)systemHead, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Note", (String)"");
        JDomUtils.addChild((Element)root, (Element)systemHead);
    }

    public static Element createTransHead(String transCode, String batchID) throws EBServiceException {
        Element TransHead = new Element("TransHead");
        JDomUtils.addChild((Element)TransHead, (String)"TransCode", (String)transCode);
        JDomUtils.addChild((Element)TransHead, (String)"BatchID", (String)batchID);
        JDomUtils.addChild((Element)TransHead, (String)"JnlDate", (String)DateHelper.currentDate());
        JDomUtils.addChild((Element)TransHead, (String)"JnlTime", (String)DateHelper.currentTime());
        return TransHead;
    }

    public static String createClientPatchID(String batchID, int index) {
        String str = "" + index;
        for (int i = 4 - str.length(); i > 0; --i) {
            str = "0" + str;
        }
        return batchID + str;
    }

    public static String createClientTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
    }

    public static String convert(PaymentInfo info) {
        String use = ResManager.loadKDString((String)"\u5dee\u65c5\u8d39", (String)"BankUtils_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]);
        if (!StringUtils.isEmpty((CharSequence)USECN_MAP.get(info.getUseCN()))) {
            use = USECN_MAP.get(info.getUseCN());
        }
        String customId = EBContext.getContext().getCustomID();
        String interfaceName = "b2e004001";
        String bankVersion = "CEB_DC";
        String useCode = UseKeyWordService.getUseByKey((String)customId, (String)info.getUseCN(), (String)interfaceName, (String)use, (String)bankVersion);
        return useCode;
    }

    public static String getExclusiveCifNo(String accNo) {
        String exclusiveCifNo = BankBusinessConfig.getExclusiveCifNo(accNo);
        return StringUtils.isEmpty((CharSequence)exclusiveCifNo) ? RequestContextUtils.getBankParameterValue((String)"CifNo") : exclusiveCifNo;
    }

    public static String createBatchIDBy8ID(String acctNo) throws EBServiceException {
        String userID = BankUtils.getExclusiveCifNo(acctNo);
        return userID + DateHelper.currentDate() + Sequence.gen8Sequence();
    }

    public static void sleepQuietly() {
        if (BankBusinessConfig.has5sInterval()) {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        USECN_MAP.put(ResManager.loadKDString((String)"\u7f51\u4e0a\u62a5\u9500", (String)"BankUtils_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5dee\u65c5\u8d39", (String)"BankUtils_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
        USECN_MAP.put(ResManager.loadKDString((String)"\u62a5\u9500", (String)"BankUtils_2", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5dee\u65c5\u8d39", (String)"BankUtils_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
    }
}

