/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.hk.services;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.hk.services.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.hk.services.balance.TodayBalanceImpl;
import kd.ebg.aqap.banks.cmb.hk.services.detail.HisDetailImpl;
import kd.ebg.aqap.banks.cmb.hk.services.detail.TodayDetailImpl;
import kd.ebg.aqap.banks.cmb.hk.services.payment.PretreatmentImpl;
import kd.ebg.aqap.banks.cmb.hk.services.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.cmb.hk.services.payment.hkremitto.PaymentImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.template.OPAMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class CmbHKMetaDataImpl
extends OPAMetaDataTemplate {
    public static final String LGNNAM = "lgnnam";
    public static final String SIGN_TYPE = "sign_type";
    public static final String SIGN_TYPE_SM = "SM";
    public static final String symSmKey = "aes_key";
    public static final String signSmKey = "rsa_key";

    public void baseConfigInit() {
        this.setExchangeProtocol("HTTP");
        this.setTimeOut(3);
        this.setCharSet("UTF-8");
    }

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c\uff08\u4e2d\u56fd\u9999\u6e2f\uff09", (String)"CmbHKMetaDataImpl_0", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        this.setBankVersionID("CMB_HK");
        this.setBankShortName("CMB");
        this.setBankVersionName(ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c\uff08\u4e2d\u56fd\u9999\u6e2f\uff09\u5f00\u653e\u5e73\u53f0\u7248", (String)"CmbHKMetaDataImpl_1", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c\uff08\u4e2d\u56fd\u9999\u6e2f\uff09\u5f00\u653e\u5e73\u53f0\u7248", (String)"CmbHKMetaDataImpl_1", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList());
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)LGNNAM, (MultiLangEnumBridge)new MultiLangEnumBridge(ResManager.loadKDString((String)"\u7528\u6237\u540d", (String)"CmbHKMetaDataImpl_2", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]), "CmbHKMetaDataImpl_16", "ebg-aqap-banks-cmb-hk"), (MultiLangEnumBridge)new MultiLangEnumBridge(ResManager.loadKDString((String)"UID,\u4e00\u822c\u4e3aN\u5f00\u5934", (String)"CmbHKMetaDataImpl_3", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]), "CmbHKMetaDataImpl_17", "ebg-aqap-banks-cmb-hk"), (String)"", (boolean)false, (boolean)false)});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public List<BankLoginConfig> getBankLoginConfig() {
        List<BankLoginConfig> loginConfigs = super.getBankLoginConfig();
        loginConfigs = loginConfigs.stream().filter(l -> !MetaDataConfigType.PGP_CONFIG.getName().equals(l.getType())).collect(Collectors.toList());
        List configs = this.getBankPGPConfig().stream().map(b -> {
            b.setType(MetaDataConfigType.PGP_CONFIG.getName());
            return b;
        }).collect(Collectors.toList());
        loginConfigs.addAll(configs);
        return loginConfigs;
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        List bankFrontConfig = super.getBankFrontConfig();
        Iterator iterator = bankFrontConfig.iterator();
        while (iterator.hasNext()) {
            BankLoginConfig bankLoginConfig = (BankLoginConfig)iterator.next();
            if (!"exchangeProtocol".equals(bankLoginConfig.getKey().getBankConfigId())) continue;
            iterator.remove();
        }
        BankLoginConfig mlBankLoginConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangeProtocol", (MultiLangEnumBridge)new MultiLangEnumBridge("\u901a\u8baf\u534f\u8bae", "CmbHKMetaDataImpl_23", "ebg-aqap-banks-cmb-hk"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u751f\u4ea7\u73af\u5883\u9009\u62e9HTTPS\uff0c\u6d4b\u8bd5\u73af\u5883\u9009\u62e9HTTP\u3002", "CmbHKMetaDataImpl_24", "ebg-aqap-banks-cmb-hk"), Arrays.asList(new MultiLangEnumBridge("HTTPS", "", ""), new MultiLangEnumBridge("HTTP", "", "")), (String)"", (boolean)false, (boolean)false, (boolean)false);
        bankFrontConfig.add(mlBankLoginConfig);
        return bankFrontConfig;
    }

    public List<BankLoginConfig> getBankPGPConfig() {
        BankLoginConfig signTypeConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)SIGN_TYPE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u52a0\u89e3\u5bc6\u7b97\u6cd5", "CmbHKMetaDataImpl_4", "ebg-aqap-banks-cmb-hk"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5982\u4e0d\u6e05\u695a\u5f53\u524d\u5c5e\u4e8e\u54ea\u79cd\u7b97\u6cd5\uff0c\u53ef\u54a8\u8be2\u94f6\u884c\u65b9\u3002", "CmbHKMetaDataImpl_5", "ebg-aqap-banks-cmb-hk"), Collections.singletonList(new MultiLangEnumBridge("\u56fd\u5bc6(SM)", "CmbHKMetaDataImpl_6", "ebg-aqap-banks-cmb-hk")), Collections.singletonList(SIGN_TYPE_SM), (String)SIGN_TYPE_SM, (boolean)true, (boolean)false, (boolean)false);
        BankLoginConfig aes = BankLoginConfigUtil.getMlBankLoginConfig((String)symSmKey, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7528\u6237\u5bf9\u79f0\u5bc6\u94a5", "CmbHKMetaDataImpl_7", "ebg-aqap-banks-cmb-hk"), (String)"", (boolean)false, (boolean)false, (String)"upload");
        aes.setMlDesc(new MultiLangEnumBridge("SM4\u5bc6\u94a5\u8bc1\u4e66\uff0c\u5ba2\u6237\u81ea\u5df1\u4fdd\u5b58\uff0c\u7528\u6237\u62a5\u6587\u52a0\u5bc6\u3001\u89e3\u5bc6\u4f7f\u7528\uff0c\u8bf7\u59a5\u5584\u4fdd\u7ba1\uff0c\u9632\u6b62\u6cc4\u9732\u3002\u4e00\u822c\u683c\u5f0f\u4e3atxt\u3002", "CmbHKMetaDataImpl_8", "ebg-aqap-banks-cmb-hk"));
        BankLoginConfig rsa = BankLoginConfigUtil.getMlBankLoginConfig((String)signSmKey, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7528\u6237\u79c1\u94a5", "CmbHKMetaDataImpl_9", "ebg-aqap-banks-cmb-hk"), (String)"", (boolean)false, (boolean)false, (String)"upload");
        rsa.setMlDesc(new MultiLangEnumBridge("SM4\u5bc6\u94a5\u8bc1\u4e66\uff0c\u5ba2\u6237\u81ea\u5df1\u4fdd\u5b58\uff0c\u7528\u6237\u62a5\u6587\u7b7e\u540d\u65f6\u4f7f\u7528\uff0c\u8bf7\u59a5\u5584\u4fdd\u7ba1\uff0c\u9632\u6b62\u6cc4\u9732\u3002\u4e00\u822c\u683c\u5f0f\u4e3atxt\u3002", "CmbHKMetaDataImpl_10", "ebg-aqap-banks-cmb-hk"));
        return Lists.newArrayList((Object[])new BankLoginConfig[]{signTypeConfig, aes, rsa});
    }

    public List<BankLoginConfig> getDeviceInfo() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"ipVal", (MultiLangEnumBridge)new MultiLangEnumBridge("IP\u5730\u5740", "CmbHKMetaDataImpl_17", "ebg-aqap-banks-cmb-hk"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237ip\u5730\u5740\u3002", "CmbHKMetaDataImpl_11", "ebg-aqap-banks-cmb-hk"), (String)"", (boolean)false, (boolean)true).set2MaxLength(40), BankLoginConfigUtil.getMlBankLoginConfig((String)"macVal", (MultiLangEnumBridge)new MultiLangEnumBridge("MAC\u5730\u5740", "CmbHKMetaDataImpl_18", "ebg-aqap-banks-cmb-hk"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237\u6240\u7528\u7535\u8111\u7684MAC\u5730\u5740\uff1b\u683c\u5f0f\u5982\uff1a309C23779B4B\uff0c\u4e0d\u8981\u5e26\u6709\u201c\uff1a\u201d\u201c-\u201d\u5206\u9694\u7b26\u3002", "CmbHKMetaDataImpl_12", "ebg-aqap-banks-cmb-hk"), (String)"", (boolean)false, (boolean)true).set2MaxLength(20), BankLoginConfigUtil.getMlBankLoginConfig((String)"cpuInfo", (MultiLangEnumBridge)new MultiLangEnumBridge("CPU ID", "CmbHKMetaDataImpl_19", "ebg-aqap-banks-cmb-hk"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237\u6240\u7528\u7535\u8111\u7684CPU\u7f16\u53f7\uff1b\u5982\u65e0\u6cd5\u83b7\u53d6\uff0c\u8bf7\u5411\u94f6\u884c\u7279\u6b8a\u8bf4\u660e\uff0c\u5e76\u586b\u5199CDCK003\u3002", "CmbHKMetaDataImpl_13", "ebg-aqap-banks-cmb-hk"), (String)"", (boolean)false, (boolean)true).set2MaxLength(16), BankLoginConfigUtil.getMlBankLoginConfig((String)"cmpName", (MultiLangEnumBridge)new MultiLangEnumBridge("\u673a\u5668\u540d", "CmbHKMetaDataImpl_20", "ebg-aqap-banks-cmb-hk"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237\u6240\u7528\u7535\u8111\u7684\u673a\u5668\u540d\uff1b\u5982\u65e0\u6cd5\u83b7\u53d6\uff0c\u8bf7\u5411\u94f6\u884c\u7279\u6b8a\u8bf4\u660e\uff0c\u5e76\u586b\u5199CDCK003\u3002", "CmbHKMetaDataImpl_14", "ebg-aqap-banks-cmb-hk"), (String)"", (boolean)false, (boolean)true).set2MaxLength(32), BankLoginConfigUtil.getMlBankLoginConfig((String)"mbId", (MultiLangEnumBridge)new MultiLangEnumBridge("\u4e3b\u677fID", "CmbHKMetaDataImpl_21", "ebg-aqap-banks-cmb-hk"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237\u6240\u7528\u7535\u8111\u7684\u4e3b\u677f\u7f16\u53f7\uff1b\u5982\u65e0\u6cd5\u83b7\u53d6\uff0c\u8bf7\u5411\u94f6\u884c\u7279\u6b8a\u8bf4\u660e\uff0c\u5e76\u586b\u5199CDCK003\u3002", "CmbHKMetaDataImpl_15", "ebg-aqap-banks-cmb-hk"), (String)"", (boolean)false, (boolean)true).set2MaxLength(32), BankLoginConfigUtil.getMlBankLoginConfig((String)"mbMf", (MultiLangEnumBridge)new MultiLangEnumBridge("\u4e3b\u677f\u5382\u5546", "CmbHKMetaDataImpl_22", "ebg-aqap-banks-cmb-hk"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u7528\u6237\u6240\u7528\u7535\u8111\u7684\u4e3b\u677f\u5382\u5546\u4fe1\u606f\uff1b\u5982\u65e0\u6cd5\u83b7\u53d6\uff0c\u8bf7\u5411\u94f6\u884c\u7279\u6b8a\u8bf4\u660e\uff0c\u5e76\u586b\u5199CDCK003\u3002", "CmbHKMetaDataImpl_16", "ebg-aqap-banks-cmb-hk"), (String)"", (boolean)false, (boolean)true).set2MaxLength(24)});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{TodayBalanceImpl.class, HisDetailImpl.class, TodayDetailImpl.class, QueryPaymentImpl.class, PretreatmentImpl.class, kd.ebg.aqap.banks.cmb.hk.services.payment.hkremittc.PaymentImpl.class, kd.ebg.aqap.banks.cmb.hk.services.payment.hkintrabank.PaymentImpl.class, PaymentImpl.class});
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("trxDte", DetailUniqueTypeEnum.STRING.getType());
        result.put("trxAmt", DetailUniqueTypeEnum.STRING.getType());
        result.put("ourRef", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }

    public boolean isDetailSupportMultiCurrency() {
        return true;
    }
}

