/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.hk.services.balance;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.hk.services.utils.JsonUtil;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgPacker;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgParser;
import kd.ebg.aqap.banks.cmb.hk.services.utils.PostUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        JSONObject ntqabinfy = new JSONObject();
        ntqabinfy.put("accNum", (Object)accNo);
        JSONObject body = new JSONObject();
        body.put("hkaccinfx", (Object)ntqabinfy);
        JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.genSequence());
        JSONObject requestJson = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(requestJson, this.getBizCode());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String rspStr) {
        String res = MsgParser.getReceMsg(rspStr);
        MsgParser.checkResponse(res);
        JSONObject response = JSONObject.parseObject((String)res);
        JSONObject resp = response.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONObject result = body.getJSONObject("result");
        ArrayList<BalanceInfo> list = new ArrayList<BalanceInfo>(1);
        String currency = result.getString("currency");
        String accBalance = result.getString("accBalance");
        String availableBalance = result.getString("availableBalance");
        String accountNumber = result.getString("accountNumber");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setCurrentBalance(balanceInfo, accBalance);
        this.setAvailableBalance(balanceInfo, availableBalance);
        this.setBankAcnt(balanceInfo, request.getBankAcntList(), accountNumber);
        this.setBankCurrency(balanceInfo, currency);
        list.add(balanceInfo);
        return new EBBankBalanceResponse(list);
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "hkaccinf";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]);
    }
}

