/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.hk.services.payment;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MatchUtil;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PayPreCheck {
    public static void PayCheckForIntraBank(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        PayPreCheck.checkCurrency(paymentInfo);
        if (!MatchUtil.characterMatch(paymentInfo.getIncomeAccNo(), "^\\d+$")) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u53ea\u80fd\u4f7f\u7528\u4ee5\u4e0b\u5b57\u7b26\uff1a\u6570\u5b57\u3002", (String)"PayPreCheck_0", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
        if (paymentInfo.getIncomeAccNo().length() != 8 && paymentInfo.getIncomeAccNo().length() != 16) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u957f\u5ea6\u5fc5\u987b\u4e3a8\u4f4d\u621616\u4f4d\u3002", (String)"PayPreCheck_1", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
        if (!MatchUtil.characterMatch(paymentInfo.getIncomeAccName(), "^[a-zA-Z0-9()\\-\\+\\,\\.]+$")) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u540d\u79f0\u53ca\u5730\u5740\u53ea\u652f\u6301\u5b57\u6bcd\uff0c\u6570\u5b57\u4ee5\u53ca()+-,.", (String)"PayPreCheck_2", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
    }

    public static void payCheckForRemitTC(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        PayPreCheck.checkCurrency(paymentInfo);
        if (!MatchUtil.characterMatch(paymentInfo.getIncomeAccNo(), "^[a-zA-Z0-9]+$")) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u53ea\u80fd\u4f7f\u7528\u4ee5\u4e0b\u5b57\u7b26\uff1a\u6570\u5b57\u3001\u82f1\u6587\u5b57\u7b26\u3002", (String)"PayPreCheck_3", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
        String incomeAccName = paymentInfo.getIncomeAccName();
        if (!MatchUtil.characterMatch(incomeAccName, "^[^#@\\/!$%^&*=:;\u2019\u201d?<>]+$")) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8f93\u5165#@\\/!$%^&*_=:;\u2019\u201d?<>", (String)"PayPreCheck_4", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
        if (MatchUtil.characterMatch(incomeAccName, ".*[\\u4e00-\\u9fa5]+.*") && MatchUtil.characterMatch(incomeAccName, "[a-zA-Z]")) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u540d\u79f0\u4e0d\u80fd\u540c\u65f6\u5305\u542b\u4e2d\u82f1\u6587\u3002", (String)"PayPreCheck_5", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
        if (!MatchUtil.characterMatch(paymentInfo.getIncomeBankName(), "^[a-zA-Z0-9()\\-\\+\\,\\.]+$")) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u540d\u79f0\u53ca\u5730\u5740\u53ea\u652f\u6301\u5b57\u6bcd\uff0c\u6570\u5b57\u4ee5\u53ca()+-,.", (String)"PayPreCheck_2", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
    }

    public static void checkPayForRemiTo(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        PayPreCheck.checkCurrency(paymentInfo);
        if (!MatchUtil.characterMatch(paymentInfo.getIncomeAccNo(), "^[a-zA-Z0-9()\\-\\+\\,\\.]+$")) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u53ea\u80fd\u4f7f\u7528\u4ee5\u4e0b\u5b57\u7b26\uff1a\u6570\u5b57\u3001\u82f1\u6587\u5b57\u7b26\u30016\u4e2a\u82f1\u6587\u6807\u70b9\u7b26\u53f7()-+,.", (String)"PayPreCheck_6", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
        String incomeAccName = paymentInfo.getIncomeAccName();
        if (!MatchUtil.characterMatch(incomeAccName, "^[a-zA-Z0-9()\\-\\+\\,\\.]+$")) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u540d\u79f0\u53ca\u5730\u5740\u53ea\u652f\u6301\u5b57\u6bcd\uff0c\u6570\u5b57\u4ee5\u53ca()+-,.", (String)"PayPreCheck_2", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
        if (!MatchUtil.characterMatch(paymentInfo.getIncomeBankName(), "^[a-zA-Z0-9()\\-\\+\\,\\.]+$")) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u540d\u79f0\u53ca\u5730\u5740\u53ea\u652f\u6301\u5b57\u6bcd\uff0c\u6570\u5b57\u4ee5\u53ca()+-,.", (String)"PayPreCheck_2", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
    }

    private static void checkCurrency(PaymentInfo paymentInfo) {
        BigDecimal amount;
        if ("JPY".equalsIgnoreCase(paymentInfo.getCurrency()) && (amount = paymentInfo.getAmount()).scale() > 0 && amount.stripTrailingZeros().scale() > 0) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u5f53\u5e01\u522b\u4e3a\u65e5\u5143\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u5e26\u5c0f\u6570", (String)"PayPreCheck_7", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
    }

    public static void main(String[] args) {
        System.out.println("11= " + MatchUtil.characterMatch("=<>", "^[^#@\\/!$%^&*=:;\u2019\u201d?<>]+$"));
    }
}

