/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.arcu.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Packer;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = ARCU_DC_Packer.getCommonHeader("B2EACInfoQry", RequestContextUtils.getRequestContext().getBankRequestSeq(), LocalDateTime.now());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ARCU_DC_Parser.parserCommonHeader((Element)root);
        if (null == bankResponse.getResponseCode() || !"000000".equals(bankResponse.getResponseCode())) {
            String errorMsg = ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        BalanceInfo bankInfo = new BalanceInfo();
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        Element map = JDomUtils.getChildElement((Element)body, (String)"Map");
        String bankAccNo = JDomUtils.getChildText((Element)map, (String)"AcNo");
        this.setBankAcnt(bankInfo, bankBalanceRequest.getBankAcntList(), bankAccNo);
        String bankCurrency = JDomUtils.getChildText((Element)map, (String)"Currency");
        this.setBankCurrency(bankInfo, bankBalanceRequest.getBankCurrency(), bankCurrency);
        String balance = JDomUtils.getChildText((Element)map, (String)"Balance");
        this.setCurrentBalance(bankInfo, balance);
        String avabBalance = JDomUtils.getChildText((Element)map, (String)"AvabBalance");
        this.setAvailableBalance(bankInfo, avabBalance);
        bankInfo.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{bankInfo}));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EACInfoQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b89\u5fbd\u519c\u4fe1\u793e\u67e5\u8be2\u5f53\u65e5\u4f59\u989d\u3002(B2EACInfoQry)", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri(ARCU_DC_Packer.getURI());
        this.configFactory(factory);
        return factory;
    }
}

