/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.arcu.dc.services.payment.salary;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Packer;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QrySalPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String busNo = paymentInfo.getBiz("BusiNo");
        if (StringUtils.isEmpty((String)busNo) && StringUtils.isEmpty((String)(busNo = RequestContextUtils.getBankParameterValue((String)"BusiNo")))) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u534f\u8bae\u53f7\u5fc5\u586b\uff0c\u8bf7\u5728\"\u67e5\u8be2\u4e0e\u652f\u4ed8\"-\"\u94f6\u4f01\u8fde\u63a5\u914d\u7f6e\"-\"\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\"-\"\u7f51\u94f6\u767b\u5f55\u914d\u7f6e\"\u5185\u914d\u7f6e\u4ee3\u53d1\u534f\u8bae\u53f7\uff0c\u518d\u63d0\u4ea4\u67e5\u8be2\u3002", (String)"SalPaymentImpl_0", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]));
        }
        Element root = ARCU_DC_Packer.getCommonHeader("B2EAgentSalaryDetailQry", Sequence.genSequence(), LocalDateTime.now());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"BusiNo", (String)busNo);
        JDomUtils.addChild((Element)body, (String)"OrgSerialNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"OrgReqTime", (String)paymentInfo.getRequestTime().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    private List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(paymentInfo.getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ARCU_DC_Parser.parserCommonHeader((Element)root);
        if (null == bankResponse.getResponseCode() || !"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u7ed3\u679c\u51fa\u9519\u3002\u94f6\u884c\u8fd4\u56de:%s\u3002", (String)"QrySalPaymentImpl_7", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]), bankResponse.getResponseCode()));
        }
        List<PaymentInfo> paymentInfos = this.preBatchSameItemCheck(bankPayRequest);
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        Element list = JDomUtils.getChildElement((Element)body, (String)"List");
        List mapsList = list.getChildren("Map");
        Map<String, PaymentInfo> uniqueMap = this.getPaymentInfoUniques(paymentInfos);
        for (int i = 0; i < mapsList.size(); ++i) {
            String key = this.getBankDataKey((Element)mapsList.get(i));
            if (!uniqueMap.containsKey(key)) continue;
            String explain = JDomUtils.getChildText((Element)((Element)mapsList.get(i)), (String)"Explain");
            this.handlePayStatus(uniqueMap.get(key), explain);
        }
        this.processingBankItemDataHandler(mapsList);
        PayStatusMatchUtil.backBatchSameItemHandler(paymentInfos, (boolean)false, (boolean)false);
        return new EBBankPayResponse(paymentInfos);
    }

    public void processingBankItemDataHandler(List<Element> elementList) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element element : elementList) {
                    String bankDataKey = this.getBankDataKey(element);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String explain = JDomUtils.getChildText((Element)element, (String)"Explain");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, explain);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EAgentSalaryDetailQry";
    }

    public String getBizDesc() {
        return null;
    }

    private void handlePayStatus(PaymentInfo tempInfo, String explain) {
        if (-1 != explain.indexOf(PropertiesConstants.getValue((String)"SUCCESS"))) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6210\u529f", (String)"QrySalPaymentImpl_2", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]), (String)explain);
        } else if (-1 != explain.indexOf(PropertiesConstants.getValue((String)"FAIL"))) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5931\u8d25", (String)"QrySalPaymentImpl_4", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]), (String)explain);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u660e\u7ec6\u65e0\u6cd5\u5339\u914d", (String)"QrySalPaymentImpl_6", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]), (String)explain);
        }
    }

    private String getBankDataKey(Element node) {
        String payeeAcNo = JDomUtils.getChildText((Element)node, (String)"PayeeAcNo");
        String amountStr = JDomUtils.getChildText((Element)node, (String)"Amount");
        String payeeAcName = JDomUtils.getChildText((Element)node, (String)"PayeeAcName");
        String key = this.getKey(payeeAcNo, payeeAcName, new BigDecimal(amountStr));
        return key;
    }

    private String getKey(String incomeAccNo, String incomeAccName, BigDecimal amount) {
        StringBuilder sb = new StringBuilder();
        sb.append(incomeAccNo).append(incomeAccName).append(amount.setScale(2).toPlainString());
        return sb.toString();
    }

    public Map<String, PaymentInfo> getPaymentInfoUniques(List<PaymentInfo> paymentInfos) {
        ConcurrentHashMap<String, PaymentInfo> uniqueMap = new ConcurrentHashMap<String, PaymentInfo>();
        for (PaymentInfo paymentInfo : paymentInfos) {
            String incomeAccNo = paymentInfo.getIncomeAccNo();
            String incomeAccName = paymentInfo.getIncomeAccName();
            String key = this.getKey(incomeAccNo, incomeAccName, paymentInfo.getAmount());
            uniqueMap.put(key, paymentInfo);
        }
        return uniqueMap;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri(ARCU_DC_Packer.getURI());
        this.configFactory(factory);
        return factory;
    }
}

