/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kd.ebg.aqap.common.cache.CUSMetaDataCache;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.LinkPayConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.sdk.ebg.cus.api.ISDKBankBusiness;
import kd.sdk.ebg.cus.bean.SDKBankConfigBean;
import kd.sdk.ebg.cus.bean.SDKMultiLangBean;
import kd.sdk.ebg.cus.enumeration.SDKLinkPayConfig;

public class BankBusinessConfig
extends BankPropertyConfig {
    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        ISDKBankBusiness bankBusiness;
        List list = this.getBankAddtionalPropertyConfigItems();
        PropertyConfigItem linkPayConfigItem = null;
        PropertyConfigItem bankAccTypeItem = null;
        ListIterator infoIterator = list.listIterator();
        while (infoIterator.hasNext()) {
            PropertyConfigItem item = (PropertyConfigItem)infoIterator.next();
            if ("LINK_PAY_CONFIG".equals(item.getKey())) {
                linkPayConfigItem = this.copy(item);
                List<LinkPayConfig> linkPayConfigList = this.getLinkPayConfigs();
                linkPayConfigItem.setMlDesc(this.getLinkPayConfigMlDesc(linkPayConfigList));
                linkPayConfigItem.setMlSourceNames(this.getLinkPayConfigMlNames(linkPayConfigList));
                linkPayConfigItem.setSourceValues(this.getLinkPayConfigValues(linkPayConfigList));
                linkPayConfigItem.setDefaultValues(this.getLinkPayConfigDefaultValue(linkPayConfigList));
                linkPayConfigItem.setInputType(ConfigInputType.SELECT.getInputType());
                infoIterator.remove();
                continue;
            }
            if (!"bank_accType".equals(item.getKey())) continue;
            bankAccTypeItem = this.copy(item);
            this.setAllBankAccType(bankAccTypeItem);
            infoIterator.remove();
        }
        if (linkPayConfigItem != null) {
            list.add(linkPayConfigItem);
        }
        if (bankAccTypeItem != null) {
            list.add(bankAccTypeItem);
        }
        if ((bankBusiness = this.getBankSDKBusinessConfig()) != null) {
            list.addAll(this.parse(bankBusiness));
        }
        return list;
    }

    private PropertyConfigItem copy(PropertyConfigItem item) {
        PropertyConfigItem copyItem = new PropertyConfigItem();
        copyItem.setInputType(item.getInputType());
        copyItem.setDefaultValues(item.getDefaultValues());
        copyItem.setSourceValues(item.getSourceValues());
        copyItem.setMlSourceNames(item.getMlSourceNames());
        copyItem.setSourceNames(item.getSourceNames());
        copyItem.setMlDesc(item.getMlDesc());
        copyItem.setType(item.getType());
        copyItem.setAccNo(item.isAccNo());
        copyItem.setMlName(item.getMlName());
        copyItem.set_propertyConfig(item.get_propertyConfig());
        copyItem.setHide(item.isHide());
        copyItem.setCheckers(item.getCheckers());
        copyItem.setDesc(item.getDesc());
        copyItem.setHideForForeignBank(item.isHideForForeignBank());
        copyItem.setKey(item.getKey());
        copyItem.setMaxValueNum(item.getMaxValueNum());
        copyItem.setMinValueNum(item.getMinValueNum());
        copyItem.setMustInput(item.isMustInput());
        copyItem.setName(item.getName());
        copyItem.setOriginalOwner(item.getOriginalOwner());
        copyItem.setReadonly(item.isReadonly());
        copyItem.setShowByFieldAndVal(item.getShowByFieldAndVal());
        return copyItem;
    }

    private List<String> getLinkPayConfigDefaultValue(List<LinkPayConfig> linkPayConfigList) {
        ArrayList<String> result = new ArrayList<String>(1);
        if (linkPayConfigList != null) {
            result.add(linkPayConfigList.get(0).getKey());
        }
        return result;
    }

    private List<MultiLangEnumBridge> getLinkPayConfigMlNames(List<LinkPayConfig> linkPayConfigList) {
        ArrayList<MultiLangEnumBridge> result = new ArrayList<MultiLangEnumBridge>(16);
        if (linkPayConfigList != null) {
            for (LinkPayConfig linkPayConfig : linkPayConfigList) {
                result.add(linkPayConfig.getMlName());
            }
        }
        return result;
    }

    private List<MultiLangEnumBridge> getLinkPayConfigMlDesc(List<LinkPayConfig> linkPayConfigList) {
        ArrayList<MultiLangEnumBridge> result = new ArrayList<MultiLangEnumBridge>(16);
        if (linkPayConfigList != null) {
            result.add(new MultiLangEnumBridge("\u8054\u52a8\u652f\u4ed8\u65b9\u5f0f\u9009\u62e9:", "BankBusinessConfig_0", "ebg-aqap-banks-cus"));
            for (int i = 0; i < linkPayConfigList.size(); ++i) {
                result.add(linkPayConfigList.get(i).getMlDesc());
            }
        }
        return result;
    }

    private List<String> getLinkPayConfigValues(List<LinkPayConfig> linkPayConfigList) {
        ArrayList<String> result = new ArrayList<String>(1);
        if (linkPayConfigList != null) {
            for (LinkPayConfig linkPayConfig : linkPayConfigList) {
                result.add(linkPayConfig.getKey());
            }
        }
        return result;
    }

    private ISDKBankBusiness getBankSDKBusinessConfig() {
        EBContext ebContext = EBContext.getContext();
        if (ebContext != null) {
            String bankVersionID = ebContext.getBankVersionID();
            ISDKBankBusiness bankBusiness = CUSMetaDataCache.getInstance().getCUSBankBusiness(bankVersionID);
            return bankBusiness;
        }
        return null;
    }

    private List<PropertyConfigItem> parse(ISDKBankBusiness bankBusiness) {
        ArrayList<PropertyConfigItem> result = new ArrayList<PropertyConfigItem>(1);
        List businessConfigBeanList = bankBusiness.getBankBusinessConfigBean();
        if (businessConfigBeanList != null) {
            for (SDKBankConfigBean bean : businessConfigBeanList) {
                result.add(this.getPropertyConfigItem(bean));
            }
        }
        return result;
    }

    private PropertyConfigItem getPropertyConfigItem(SDKBankConfigBean bean) {
        PropertyConfigItem item = PropertyConfigItem.builder().key(bean.getKey()).build();
        item.setMlName(this.getMultiLangEnumBridge(bean.getName()));
        item.setMlDesc(this.getMultiLangEnumBridges(bean.getDesc()));
        item.setMlSourceNames(this.getMultiLangEnumBridges(bean.getSourceNames()));
        item.setSourceValues(bean.getSourceValues());
        ArrayList<String> defaultValues = new ArrayList<String>(1);
        defaultValues.add(bean.getDefaultValue());
        item.setDefaultValues(defaultValues);
        item.setAccNo(bean.isAccNo());
        item.setType(bean.getType());
        item.setInputType(bean.getInputType().getInputType());
        return item;
    }

    private List<MultiLangEnumBridge> getMultiLangEnumBridges(List<SDKMultiLangBean> multiLangBeanList) {
        if (multiLangBeanList == null) {
            return null;
        }
        ArrayList<MultiLangEnumBridge> list = new ArrayList<MultiLangEnumBridge>(1);
        for (SDKMultiLangBean multiLangBean : multiLangBeanList) {
            list.add(this.getMultiLangEnumBridge(multiLangBean));
        }
        return list;
    }

    private List<MultiLangEnumBridge> getMultiLangEnumBridges(SDKMultiLangBean multiLangBean) {
        if (multiLangBean == null) {
            return null;
        }
        ArrayList<MultiLangEnumBridge> list = new ArrayList<MultiLangEnumBridge>(1);
        list.add(this.getMultiLangEnumBridge(multiLangBean));
        return list;
    }

    private MultiLangEnumBridge getMultiLangEnumBridge(SDKMultiLangBean multiLangBean) {
        if (multiLangBean == null) {
            return null;
        }
        return new MultiLangEnumBridge(multiLangBean.getDescription(), multiLangBean.getResourceID(), multiLangBean.getSystemType());
    }

    public List<LinkPayConfig> getLinkPayConfigs() {
        ISDKBankBusiness bankBusiness = this.getBankSDKBusinessConfig();
        if (bankBusiness != null) {
            List sdkLinkPayConfigs = bankBusiness.getLinkPayConfig();
            if (sdkLinkPayConfigs != null && !sdkLinkPayConfigs.isEmpty()) {
                ArrayList<LinkPayConfig> linkPayConfigs = new ArrayList<LinkPayConfig>(1);
                for (SDKLinkPayConfig sdkLinkPayConfig : sdkLinkPayConfigs) {
                    LinkPayConfig linkPayConfig = this.getLinkPayConfig(sdkLinkPayConfig.getKey());
                    if (linkPayConfig == null) continue;
                    linkPayConfigs.add(linkPayConfig);
                }
                return linkPayConfigs;
            }
            return null;
        }
        return null;
    }

    private LinkPayConfig getLinkPayConfig(String key) {
        for (LinkPayConfig item : LinkPayConfig.values()) {
            if (!item.getKey().equals(key)) continue;
            return item;
        }
        return null;
    }
}

