/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.biz;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.ebg.aqap.banks.cus.biz.request.CustomBizRequest;
import kd.ebg.aqap.banks.cus.biz.response.CustomBizResponse;
import kd.ebg.aqap.banks.cus.biz.response.CustomBizResponseBody;
import kd.ebg.aqap.banks.cus.biz.util.CustomTransFormatUtil;
import kd.ebg.aqap.banks.cus.util.ShowTipUtil;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.cus.api.biz.ext.ISDKBizExt;
import kd.sdk.ebg.cus.bean.biz.ext.SDKBizRequest;
import kd.sdk.ebg.cus.bean.biz.ext.SDKBizResponse;
import kd.sdk.ebg.trd.exception.SDKException;
import org.slf4j.MDC;

public class CustomBizMethod
implements EBServiceMethod<CustomBizRequest, CustomBizResponse> {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CustomBizMethod.class);
    private static Map<String, ISDKBizExt> bizExtCacheMap = new HashMap<String, ISDKBizExt>(1);

    public ISDKBizExt getImplFromCache() {
        String bizType = EBContext.getContext().getBizName();
        if (StringUtils.isNotEmpty((String)bizType)) {
            return this.getImplFromCache(bizType);
        }
        return null;
    }

    private synchronized ISDKBizExt getImplFromCache(String bizType) {
        Set clzImplSet;
        if (!bizExtCacheMap.containsKey(bizType) && (clzImplSet = ReflectUtil.getSubTypesOf(ISDKBizExt.class)) != null) {
            for (Class c : clzImplSet) {
                try {
                    ISDKBizExt instance = (ISDKBizExt)c.newInstance();
                    bizExtCacheMap.put(bizType, instance);
                }
                catch (Throwable e) {
                    this.logger.error(ShowTipUtil.getNotFindClassTip(ISDKBizExt.class.getName()), e);
                }
            }
        }
        ISDKBizExt isdkBizExt = bizExtCacheMap.get(bizType);
        return isdkBizExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomBizResponse executeClientRequest(CustomBizRequest customBizRequest, EBContext ebContext) {
        FEPAccess access;
        CustomBizResponse response;
        block6: {
            response = new CustomBizResponse();
            response.setHeader(customBizRequest.getHeader());
            CustomBizResponseBody body = new CustomBizResponseBody();
            response.setBody(body);
            if (EBContext.getContext().isUnitTest()) {
                this.logger.info("unit test");
            } else {
                EBContext.initParameter();
            }
            EBContext context = EBContext.getContext();
            access = null;
            try {
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                this.logger.infoIndex("Start CustomBizMethod");
                ISDKBizExt impl = this.getImplFromCache();
                if (impl == null) break block6;
                SDKBizRequest sdkBizRequest = CustomTransFormatUtil.transFormat(customBizRequest);
                SDKBizResponse sdkBizResponse = impl.executeClientRequest(sdkBizRequest);
                body.setCustomParam(sdkBizResponse.getJsonString());
                if (sdkBizResponse.getException() == null) break block6;
                SDKException exception = sdkBizResponse.getException();
                EBException ebException = new EBException();
                ebException.setMessage(exception.getMessage());
                ebException.setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])exception.getStackTrace()));
                response.setException(ebException);
            }
            catch (Throwable e) {
                try {
                    EBException ebException = new EBException();
                    ebException.setMessage(e.getMessage());
                    ebException.setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])e.getStackTrace()));
                    response.setException(ebException);
                }
                catch (Throwable throwable) {
                    FEPAccessUtil.release(access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    throw throwable;
                }
                FEPAccessUtil.release((FEPAccess)access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        return response;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "CUS_BIZ";
    }

    public String register() {
        HashMap registerParams = new HashMap(1);
        HashMap<String, String> subItems = new HashMap<String, String>(1);
        subItems.put("methodClass", CustomBizMethod.class.getName());
        subItems.put("requestClass", CustomBizRequest.class.getName());
        subItems.put("responseClass", CustomBizResponse.class.getName());
        Set clzImplSet = ReflectUtil.getSubTypesOf(ISDKBizExt.class);
        for (Class c : clzImplSet) {
            try {
                ISDKBizExt instance = (ISDKBizExt)c.newInstance();
                registerParams.put(instance.bizName(), subItems);
                bizExtCacheMap.put(instance.bizName(), instance);
            }
            catch (Throwable e) {
                this.logger.error(ShowTipUtil.getNotFindClassTip(ISDKBizExt.class.getName()), e);
            }
        }
        return JSON.toJSONString(registerParams);
    }
}

