/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.service.balance;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.ebg.aqap.banks.cus.service.balance.CommonBalanceImpl;
import kd.ebg.aqap.banks.cus.util.ShowTipUtil;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.cus.api.biz.balance.ISDKBalance;
import kd.sdk.ebg.cus.bean.bank.balance.SDKBalanceRequest;
import kd.sdk.ebg.cus.bean.bank.balance.SDKBalanceResponse;

public class TodayBalanceImpl
extends CommonBalanceImpl
implements ITodayBatchBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);
    private static Map<String, ISDKBalance> balanceCacheMap = new HashMap<String, ISDKBalance>(1);

    private ISDKBalance getImplFromCache() {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        return this.getImplFromCache(bankVersionID);
    }

    private synchronized ISDKBalance getImplFromCache(String bankVersionID) {
        Set clzImplSet;
        if (!balanceCacheMap.containsKey(bankVersionID) && (clzImplSet = ReflectUtil.getSubTypesOf(ISDKBalance.class)) != null) {
            for (Class c : clzImplSet) {
                try {
                    ISDKBalance instance = (ISDKBalance)c.newInstance();
                    balanceCacheMap.put(instance.getBankVersionID(), instance);
                }
                catch (Throwable e) {
                    this.logger.error(ShowTipUtil.getNotFindClassTip(ISDKBalance.class.getName()), e);
                }
            }
        }
        ISDKBalance isdkBalance = balanceCacheMap.get(bankVersionID);
        return isdkBalance;
    }

    @Override
    public String pack(BankBalanceRequest bankBalanceRequest) {
        String result = "";
        String bankVersionID = bankBalanceRequest.getHeader().getBankVersionID();
        ISDKBalance impl = this.getImplFromCache(bankVersionID);
        if (impl == null) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getNotFindClassTip(ISDKBalance.class.getName()));
        }
        SDKBalanceRequest request = this.transFormat(bankBalanceRequest);
        result = impl.pack(request);
        return result;
    }

    @Override
    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String bankResponseStr) {
        String bankVersionID = bankBalanceRequest.getHeader().getBankVersionID();
        ISDKBalance impl = this.getImplFromCache(bankVersionID);
        if (impl != null) {
            SDKBalanceRequest request = this.transFormat(bankBalanceRequest);
            SDKBalanceResponse sdkBalanceResponse = impl.parse(request, bankResponseStr);
            EBBankBalanceResponse response = this.transFormat(sdkBalanceResponse, bankBalanceRequest.getHeader());
            return response;
        }
        throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getNotFindClassTip(ISDKBalance.class.getName()));
    }

    public EBBankBalanceResponse process(BankBalanceRequest bankBalanceRequest) {
        ISDKBalance impl = this.getImplFromCache();
        if (!impl.isBankSDK()) {
            return super.process(bankBalanceRequest);
        }
        String bankRequestStr = this.pack(bankBalanceRequest);
        ShowTipUtil.recordRequest(bankRequestStr);
        try {
            String bankResponseStr = impl.sendAndReceive(bankRequestStr);
            ShowTipUtil.recordResponse(bankResponseStr);
            return this.parse(bankBalanceRequest, bankResponseStr);
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    public int limit() {
        ISDKBalance impl = this.getImplFromCache();
        return impl.limit();
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        ISDKBalance impl = this.getImplFromCache();
        return impl.isSupportPage();
    }

    public void configFactory(ConnectionFactory factory) {
        ISDKBalance impl = this.getImplFromCache();
        String uri = impl.getHttpUri();
        if (StringUtils.isNotEmpty((String)uri)) {
            factory.setUri(uri);
        }
        Map httpHeaderMap = impl.getHttpHeader();
        for (Map.Entry entry : httpHeaderMap.entrySet()) {
            factory.setHttpHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

