/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.service.detail;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.ebg.aqap.banks.cus.service.detail.CommonDetailImpl;
import kd.ebg.aqap.banks.cus.util.ShowTipUtil;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.cus.api.biz.detail.ISDKHisDetail;
import kd.sdk.ebg.cus.bean.bank.detail.SDKDetailRequest;
import kd.sdk.ebg.cus.bean.bank.detail.SDKDetailResponse;

public class HisDetailImpl
extends CommonDetailImpl
implements IHisDetail {
    private static Map<String, ISDKHisDetail> detailCacheMap = new HashMap<String, ISDKHisDetail>(1);

    private ISDKHisDetail getImplFromCache() {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        return this.getImplFromCache(bankVersionID);
    }

    private synchronized ISDKHisDetail getImplFromCache(String bankVersionID) {
        Set clzImplSet;
        if (!detailCacheMap.containsKey(bankVersionID) && (clzImplSet = ReflectUtil.getSubTypesOf(ISDKHisDetail.class)) != null) {
            for (Class c : clzImplSet) {
                try {
                    ISDKHisDetail instance = (ISDKHisDetail)c.newInstance();
                    detailCacheMap.put(instance.getBankVersionID(), instance);
                }
                catch (Throwable e) {
                    EBGLogger logger = EBGLogger.getInstance().getLogger(HisDetailImpl.class);
                    logger.error(ShowTipUtil.getNotFindClassTip(ISDKHisDetail.class.getName()), e);
                }
            }
        }
        ISDKHisDetail isdkDetail = detailCacheMap.get(bankVersionID);
        return isdkDetail;
    }

    @Override
    public String pack(BankDetailRequest bankDetailRequest) {
        String result = "";
        String bankVersionID = bankDetailRequest.getHeader().getBankVersionID();
        ISDKHisDetail impl = this.getImplFromCache(bankVersionID);
        if (impl == null) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getNotFindClassTip(ISDKHisDetail.class.getName()));
        }
        SDKDetailRequest request = this.transFormat(bankDetailRequest);
        result = impl.pack(request);
        return result;
    }

    @Override
    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String bankResponseStr) {
        String bankVersionID = bankDetailRequest.getHeader().getBankVersionID();
        ISDKHisDetail impl = this.getImplFromCache(bankVersionID);
        if (impl != null) {
            SDKDetailRequest request = this.transFormat(bankDetailRequest);
            SDKDetailResponse sdkBalanceResponse = impl.parse(request, bankResponseStr);
            EBBankDetailResponse response = this.transFormat(sdkBalanceResponse, bankDetailRequest.getHeader());
            return response;
        }
        throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getNotFindClassTip(ISDKHisDetail.class.getName()));
    }

    public EBBankDetailResponse process(BankDetailRequest bankDetailRequest) {
        ISDKHisDetail impl = this.getImplFromCache();
        if (!impl.isBankSDK()) {
            return super.process(bankDetailRequest);
        }
        String bankRequestStr = this.pack(bankDetailRequest);
        ShowTipUtil.recordRequest(bankRequestStr);
        try {
            String bankResponseStr = impl.sendAndReceive(bankRequestStr);
            ShowTipUtil.recordResponse(bankResponseStr);
            return this.parse(bankDetailRequest, bankResponseStr);
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    public boolean isSupportPage() {
        ISDKHisDetail impl = this.getImplFromCache();
        return impl.isSupportPage();
    }

    public boolean isHistoryDetailReverse() {
        ISDKHisDetail impl = this.getImplFromCache();
        return impl.isDetailReverse();
    }

    public void configFactory(ConnectionFactory factory) {
        ISDKHisDetail impl = this.getImplFromCache();
        String uri = impl.getHttpUri();
        if (StringUtils.isNotEmpty((String)uri)) {
            factory.setUri(uri);
        }
        Map httpHeaderMap = impl.getHttpHeader();
        for (Map.Entry entry : httpHeaderMap.entrySet()) {
            factory.setHttpHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

