/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.service.login;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.ebg.aqap.banks.cus.util.ShowTipUtil;
import kd.ebg.aqap.business.login.AbstractLoginImpl;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.cus.api.biz.other.ISDKLogin;
import kd.sdk.ebg.cus.api.biz.util.ISDKLoginToken;

public class LoginImpl
extends AbstractLoginImpl
implements ISDKLoginToken {
    EBGLogger logger = EBGLogger.getInstance().getLogger(LoginImpl.class);
    private static Map<String, ISDKLogin> loginCacheMap = new HashMap<String, ISDKLogin>(1);

    private ISDKLogin getImplFromCache() {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        return this.getImplFromCache(bankVersionID);
    }

    private synchronized ISDKLogin getImplFromCache(String bankVersionID) {
        Set clzImplSet;
        if (!loginCacheMap.containsKey(bankVersionID) && (clzImplSet = ReflectUtil.getSubTypesOf(ISDKLogin.class)) != null) {
            for (Class c : clzImplSet) {
                try {
                    ISDKLogin instance = (ISDKLogin)c.newInstance();
                    loginCacheMap.put(instance.getBankVersionID(), instance);
                }
                catch (Throwable e) {
                    this.logger.error(ShowTipUtil.getNotFindClassTip(ISDKLogin.class.getName()), e);
                }
            }
        }
        ISDKLogin isdkLogin = loginCacheMap.get(bankVersionID);
        return isdkLogin;
    }

    public String pack() {
        ISDKLogin impl = this.getImplFromCache();
        return impl.pack();
    }

    public String parse(String bankResponseStr) {
        ISDKLogin impl = this.getImplFromCache();
        return impl.parse(bankResponseStr);
    }

    public String login() {
        ISDKLogin impl = this.getImplFromCache();
        if (!impl.isBankSDK()) {
            return super.login();
        }
        String bankRequestStr = this.pack();
        ShowTipUtil.recordRequest(bankRequestStr);
        try {
            String bankResponseStr = impl.sendAndReceive(bankRequestStr);
            ShowTipUtil.recordResponse(bankResponseStr);
            return this.parse(bankResponseStr);
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    public String getConnectionURI() {
        ISDKLogin impl = this.getImplFromCache();
        return impl.getHttpUri();
    }

    public int getTimeout() {
        ISDKLogin impl = this.getImplFromCache();
        return impl.getTokenTimeOut();
    }

    public String getToken() {
        return this.doBiz();
    }

    public void configFactory(ConnectionFactory factory) {
        ISDKLogin impl = this.getImplFromCache();
        String uri = impl.getHttpUri();
        if (StringUtils.isNotEmpty((String)uri)) {
            factory.setUri(uri);
        }
        Map httpHeaderMap = impl.getHttpHeader();
        for (Map.Entry entry : httpHeaderMap.entrySet()) {
            factory.setHttpHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

