/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.service.payment;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cus.service.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.cus.util.PayImplCacheUtil;
import kd.ebg.aqap.banks.cus.util.PaymentTransferUtil;
import kd.ebg.aqap.banks.cus.util.ShowTipUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.cus.api.biz.payment.ISDKPay;
import kd.sdk.ebg.cus.bean.bank.payment.SDKPayRequest;
import kd.sdk.ebg.cus.bean.bank.payment.SDKPayResponse;
import kd.sdk.ebg.trd.exception.SDKAfterConnectException;
import kd.sdk.ebg.trd.exception.SDKBeforeConnectException;

public class PaymentImpl
extends AbstractPayImpl {
    public ISDKPay getImplFromCache() {
        ISDKPay impl = PayImplCacheUtil.getImplFromCache();
        if (impl == null) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getNotFindClassTip(ISDKPay.class.getName()));
        }
        return impl;
    }

    public int getBatchSize() {
        ISDKPay impl = this.getImplFromCache();
        return impl.getBatchSize();
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        ISDKPay impl = this.getImplFromCache();
        SDKPayRequest request = PaymentTransferUtil.transFormat(bankPayRequest);
        return impl.pack(request);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String bankResponseStr) {
        ISDKPay impl = this.getImplFromCache();
        SDKPayRequest request = PaymentTransferUtil.transFormat(bankPayRequest);
        SDKPayResponse sdkPayResponse = impl.parse(request, bankResponseStr);
        EBBankPayResponse response = PaymentTransferUtil.transFormat(sdkPayResponse, bankPayRequest.getHeader());
        return response;
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        String bankRequestStr;
        ISDKPay impl = this.getImplFromCache();
        if (!impl.isBankSDK()) {
            return super.doBiz(bankPayRequest);
        }
        try {
            bankRequestStr = this.pack(bankPayRequest);
            ShowTipUtil.recordRequest(bankRequestStr);
        }
        catch (Throwable t) {
            String errorMsg = ResManager.loadKDString((String)"\u6253\u5305\u94f6\u884c\u4ed8\u6b3e\u8bf7\u6c42\u62a5\u6587\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-cus", (Object[])new Object[0]);
            throw EBExceiptionUtil.payFailException((String)errorMsg, (Throwable)t);
        }
        try {
            String bankResponseStr = impl.sendAndReceive(bankRequestStr);
            ShowTipUtil.recordResponse(bankResponseStr);
            return this.parse(bankPayRequest, bankResponseStr);
        }
        catch (Throwable t) {
            if (t instanceof SDKBeforeConnectException) {
                String errorMsg = ResManager.loadKDString((String)"\u5efa\u7acb\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\u3002", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-cus", (Object[])new Object[0]);
                throw EBExceiptionUtil.payFailException((String)errorMsg, (Throwable)t);
            }
            if (t instanceof SDKAfterConnectException) {
                EBContext.getContext().setThrowableAfterSend(t);
                return null;
            }
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        ISDKPay impl = PayImplCacheUtil.getImplFromCache();
        if (impl != null) {
            return impl.getBankInterfaceCode();
        }
        return "";
    }

    public String getBizDesc() {
        ISDKPay impl = PayImplCacheUtil.getImplFromCache();
        if (impl != null) {
            return impl.getClass().getName();
        }
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        ISDKPay impl = PayImplCacheUtil.getImplFromCache();
        if (impl != null) {
            String uri = impl.getHttpUri();
            if (StringUtils.isNotEmpty((String)uri)) {
                factory.setUri(uri);
            }
            Map httpHeaderMap = impl.getHttpHeader();
            for (Map.Entry entry : httpHeaderMap.entrySet()) {
                factory.setHttpHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

