/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.service.payment;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cus.util.PayImplCacheUtil;
import kd.ebg.aqap.banks.cus.util.PaymentTransferUtil;
import kd.ebg.aqap.banks.cus.util.ShowTipUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.cus.api.biz.payment.ISDKPay;
import kd.sdk.ebg.cus.api.biz.payment.ISDKQueryPay;
import kd.sdk.ebg.cus.bean.bank.payment.SDKPayRequest;
import kd.sdk.ebg.cus.bean.bank.payment.SDKPayResponse;
import kd.sdk.ebg.trd.exception.SDKPayUNKnownException;

public class QueryPaymentImpl
extends AbstractQueryPayImpl {
    public ISDKQueryPay getImplFromCache() {
        ISDKQueryPay impl = this.getQueryPayImplFromCache();
        if (impl == null) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getNotFindClassTip(ISDKQueryPay.class.getName()));
        }
        return impl;
    }

    public ISDKQueryPay getQueryPayImplFromCache() {
        ISDKPay impl = PayImplCacheUtil.getImplFromCache();
        if (impl != null) {
            return impl.queryPayImpl();
        }
        return null;
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        ISDKQueryPay impl = this.getImplFromCache();
        SDKPayRequest request = PaymentTransferUtil.transFormat(bankPayRequest);
        return impl.pack(request);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String bankResponseStr) {
        ISDKQueryPay impl = this.getImplFromCache();
        SDKPayRequest request = PaymentTransferUtil.transFormat(bankPayRequest);
        SDKPayResponse sdkPayResponse = impl.parse(request, bankResponseStr);
        EBBankPayResponse response = PaymentTransferUtil.transFormat(sdkPayResponse, bankPayRequest.getHeader());
        return response;
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        ISDKQueryPay impl = this.getImplFromCache();
        if (!impl.isBankSDK()) {
            return super.doBiz(bankPayRequest);
        }
        try {
            String bankRequestStr = this.pack(bankPayRequest);
            ShowTipUtil.recordRequest(bankRequestStr);
            String bankResponseStr = impl.sendAndReceive(bankRequestStr);
            ShowTipUtil.recordResponse(bankResponseStr);
            return this.parse(bankPayRequest, bankResponseStr);
        }
        catch (Throwable t) {
            String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u51fa\u73b0\u5f02\u5e38\u3002", (String)"QueryPaymentImpl_2", (String)"ebg-aqap-banks-cus", (Object[])new Object[0]);
            if (t instanceof SDKPayUNKnownException) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c%s\u3002", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-cus", (Object[])new Object[0]), t.getMessage());
                throw EBExceiptionUtil.payUnknownException((String)errorMsg, (Throwable)t);
            }
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)t);
        }
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        ISDKQueryPay impl = this.getQueryPayImplFromCache();
        if (impl != null) {
            return impl.getBankInterfaceCode();
        }
        return "";
    }

    public String getBizDesc() {
        ISDKQueryPay impl = this.getQueryPayImplFromCache();
        if (impl != null) {
            return impl.getClass().getName();
        }
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        ISDKQueryPay impl = this.getQueryPayImplFromCache();
        if (impl != null) {
            String uri = impl.getHttpUri();
            if (StringUtils.isNotEmpty((String)uri)) {
                factory.setUri(uri);
            }
            Map httpHeaderMap = impl.getHttpHeader();
            for (Map.Entry entry : httpHeaderMap.entrySet()) {
                factory.setHttpHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

