/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.util;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.cus.bean.bank.SDKBankAcnt;
import kd.sdk.ebg.cus.bean.bank.SDKBankAcntProxy;
import kd.sdk.ebg.cus.bean.bank.SDKBankHeader;
import kd.sdk.ebg.cus.bean.biz.balance.SDKBalanceInfo;
import kd.sdk.ebg.cus.bean.biz.detail.SDKDetailInfo;
import kd.sdk.ebg.cus.bean.biz.payment.SDKPaymentInfo;

public class CusBeanUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CusBeanUtils.class);

    public static void copyProperties(Object sourceObj, Object targetObj) {
        if (sourceObj != null && targetObj != null) {
            FieldUtils.fieldsCopy((Object)sourceObj, (Object)targetObj);
        }
    }

    public static SDKBankHeader transFormatHeader(BankHeader bankHeader) {
        SDKBankHeader header = new SDKBankHeader();
        if (bankHeader != null) {
            CusBeanUtils.copyProperties(bankHeader, header);
            SDKBankAcnt sdkBankAcnt = CusBeanUtils.transFormatBankAcnt(bankHeader.getAcnt());
            header.setAcnt(sdkBankAcnt);
        }
        return header;
    }

    public static SDKBankAcnt transFormatBankAcnt(BankAcnt bankAcnt) {
        SDKBankAcnt sdkBankAcnt = new SDKBankAcnt();
        if (bankAcnt != null) {
            CusBeanUtils.copyProperties(bankAcnt, sdkBankAcnt);
            List proxyList = bankAcnt.getProxy();
            ArrayList<SDKBankAcntProxy> sdkBankAcntProxyList = new ArrayList<SDKBankAcntProxy>(1);
            if (proxyList != null) {
                for (BankAcnt.Proxy proxy : proxyList) {
                    SDKBankAcntProxy sdkBankAcntProxy = new SDKBankAcntProxy();
                    sdkBankAcntProxy.setCurrency(proxy.getCurrency());
                    sdkBankAcntProxy.setInquiryAccount(proxy.getInquiryaccount());
                    sdkBankAcntProxy.setPayAccount(proxy.getPayaccount());
                    sdkBankAcntProxy.setSwiftCode(proxy.getSwiftCode());
                    sdkBankAcntProxyList.add(sdkBankAcntProxy);
                }
            }
            sdkBankAcnt.setProxy(sdkBankAcntProxyList);
        }
        return sdkBankAcnt;
    }

    public static BankAcnt transFormatSDKBankAcnt(SDKBankAcnt sdkBankAcnt) {
        BankAcnt bankAcnt = new BankAcnt();
        if (sdkBankAcnt != null) {
            CusBeanUtils.copyProperties(sdkBankAcnt, bankAcnt);
            List sdkBankAcntProxyList = sdkBankAcnt.getProxy();
            ArrayList<BankAcnt.Proxy> proxyList = new ArrayList<BankAcnt.Proxy>(1);
            if (sdkBankAcntProxyList != null) {
                for (SDKBankAcntProxy sdkBankAcntProxy : sdkBankAcntProxyList) {
                    BankAcnt.Proxy proxy = new BankAcnt.Proxy();
                    proxy.setCurrency(sdkBankAcntProxy.getCurrency());
                    proxy.setInquiryaccount(sdkBankAcntProxy.getInquiryAccount());
                    proxy.setPayaccount(sdkBankAcntProxy.getPayAccount());
                    proxy.setSwiftCode(sdkBankAcntProxy.getSwiftCode());
                    proxyList.add(proxy);
                }
            }
            bankAcnt.setProxy(proxyList);
        }
        return bankAcnt;
    }

    public static List<SDKBankAcnt> transFormatBankAcnt(List<BankAcnt> bankAcntList) {
        ArrayList<SDKBankAcnt> sdkBankAcntList = new ArrayList<SDKBankAcnt>(1);
        if (bankAcntList != null) {
            for (BankAcnt bankAcnt : bankAcntList) {
                sdkBankAcntList.add(CusBeanUtils.transFormatBankAcnt(bankAcnt));
            }
        }
        return sdkBankAcntList;
    }

    public static List<BankAcnt> transFormatSDKBankAcnt(List<SDKBankAcnt> sdkBankAcntList) {
        ArrayList<BankAcnt> bankAcntList = new ArrayList<BankAcnt>(1);
        if (sdkBankAcntList != null) {
            for (SDKBankAcnt sdkBankAcnt : sdkBankAcntList) {
                bankAcntList.add(CusBeanUtils.transFormatSDKBankAcnt(sdkBankAcnt));
            }
        }
        return bankAcntList;
    }

    public static List<BalanceInfo> transFormatBalanceInfo(List<SDKBalanceInfo> sdkBalanceInfoList) {
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(1);
        if (sdkBalanceInfoList != null) {
            for (SDKBalanceInfo sdkBalanceInfo : sdkBalanceInfoList) {
                BalanceInfo balanceInfo = new BalanceInfo();
                CusBeanUtils.copyProperties(sdkBalanceInfo, balanceInfo);
                balanceInfo.setBankAcnt(CusBeanUtils.transFormatSDKBankAcnt(sdkBalanceInfo.getBankAcnt()));
                balanceInfoList.add(balanceInfo);
            }
        }
        return balanceInfoList;
    }

    public static List<DetailInfo> transFormatDetailInfo(List<SDKDetailInfo> sdkDetailInfoList) {
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(1);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        if (sdkDetailInfoList != null) {
            for (SDKDetailInfo sdkDetailInfo : sdkDetailInfoList) {
                DetailInfo detailInfo = new DetailInfo();
                CusBeanUtils.copyProperties(sdkDetailInfo, detailInfo);
                String jsonStr = detailInfo.getJsonMap();
                if (StringUtils.isNotEmpty((String)jsonStr)) {
                    String transDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
                    String receiptNo = MatchRule.getInstance().getReceiptNo(detailInfo.getAccNo(), transDate, jsonStr);
                    if (countMap.containsKey(receiptNo)) {
                        int count = (Integer)countMap.get(receiptNo) + 1;
                        countMap.put(receiptNo, count);
                        receiptNo = receiptNo + "-" + String.format("%04d", count);
                    } else {
                        countMap.put(receiptNo, 0);
                    }
                    detailInfo.setReceiptNo(receiptNo);
                }
                detailInfoList.add(detailInfo);
            }
        }
        return detailInfoList;
    }

    public static List<PaymentInfo> transFormatPaymentInfo(List<SDKPaymentInfo> sdkPaymentInfoList) {
        ArrayList<PaymentInfo> paymentInfoList = new ArrayList<PaymentInfo>(1);
        if (sdkPaymentInfoList != null) {
            for (SDKPaymentInfo sdkPaymentInfo : sdkPaymentInfoList) {
                PaymentInfo paymentInfo = new PaymentInfo();
                CusBeanUtils.copyProperties(sdkPaymentInfo, paymentInfo);
                paymentInfo.setReversed1(sdkPaymentInfo.getReversed1());
                paymentInfo.setReversed2(sdkPaymentInfo.getReversed2());
                paymentInfo.setReversed3(sdkPaymentInfo.getReversed3());
                paymentInfo.setReversed4(sdkPaymentInfo.getReversed4());
                paymentInfo.setReversedBizField(sdkPaymentInfo.getReversedBizField());
                paymentInfo.setReversedSysField(sdkPaymentInfo.getReversedSysField());
                paymentInfoList.add(paymentInfo);
            }
        }
        return paymentInfoList;
    }

    public static List<SDKPaymentInfo> transFormatSDKPaymentInfo(List<PaymentInfo> paymentInfoList) {
        ArrayList<SDKPaymentInfo> sdkPaymentInfoList = new ArrayList<SDKPaymentInfo>(1);
        if (paymentInfoList != null) {
            for (PaymentInfo paymentInfo : paymentInfoList) {
                SDKPaymentInfo sdkPaymentInfo = new SDKPaymentInfo();
                CusBeanUtils.copyProperties(paymentInfo, sdkPaymentInfo);
                sdkPaymentInfo.setReversed1(paymentInfo.getReversed1());
                sdkPaymentInfo.setReversed2(paymentInfo.getReversed2());
                sdkPaymentInfo.setReversed3(paymentInfo.getReversed3());
                sdkPaymentInfo.setReversed4(paymentInfo.getReversed4());
                sdkPaymentInfo.setReversedBizField(paymentInfo.getReversedBizField());
                sdkPaymentInfo.setReversedSysField(paymentInfo.getReversedSysField());
                sdkPaymentInfoList.add(sdkPaymentInfo);
            }
        }
        return sdkPaymentInfoList;
    }
}

