/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.accno;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.common.EbcAddBankListPlugin;
import kd.ebg.aqap.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.egf.common.constant.CertType;

public class BankAcntListPlugin
extends EbcAddBankListPlugin {
    private static final String ENTITY_KEY_OBJECT_PROPERTIES = "aqap_object_properties";
    private static final String ENTITY_KEY_CER = "aqap_bd_cert";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    private EbcBankAcntRepository ebcBankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (this.getPageCache().get("isFirstInit") == null && !CollectionUtils.isEmpty((Map)paramMap) && paramMap.get("bank_version_id") != null) {
            this.getPageCache().put("isFirstInit", "false");
            long groudId = Long.parseLong(String.valueOf(paramMap.get("bank_version_id")));
            ((BillList)args.getSource()).getQueryFilterParameter().getQFilters().add(new QFilter("group", "=", (Object)groudId));
        }
        super.beforeCreateListDataProvider(args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List treeNodes;
        TreeView tree;
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap) && this.getPageCache().get("isFirstInit") == null && (tree = (TreeView)this.getView().getControl("treeview")) != null && !CollectionUtils.isEmpty((Collection)(treeNodes = ((TreeListView)((ListView)tree.getView()).getTreeListView()).getRoot().getChildren())) && paramMap.get("bank_version_id") != null) {
            for (TreeNode treeNode : treeNodes) {
                if (!paramMap.get("bank_version_id").equals(treeNode.getId())) continue;
                tree.focusNode(treeNode);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        e.getQFilters().add(new QFilter("group.enable", "=", (Object)"1"));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        int selectedRows = formOperate.getListSelectedData().size();
        if (StringUtils.equals((CharSequence)"view", (CharSequence)formOperate.getOperateKey())) {
            if (selectedRows > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u770b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BankAcntListPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)"new", (CharSequence)formOperate.getOperateKey())) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            Map focusNode = treeView.getTreeState().getFocusNode();
            String text = (String)focusNode.get("text");
            if (ResManager.loadKDString((String)"\u5168\u90e8", (String)"BankAcntListPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]).equals(text)) {
                this.getView().showTipNotification(MultiLang.getSelectBankTip());
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)"delete", (CharSequence)formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                listSelectedRowCollection.forEach(selectedRow -> {
                    String acnt = selectedRow.getNumber();
                    QFilter[] filters = new QFilter[]{new QFilter("object_id", "=", (Object)acnt), new QFilter("object_name", "=", (Object)this.infoService.getBusinessName())};
                    DeleteServiceHelper.delete((String)ENTITY_KEY_OBJECT_PROPERTIES, (QFilter[])filters);
                    QFilter[] cerFilters = new QFilter[]{new QFilter("acnt_no", "=", (Object)acnt), new QFilter("type", "=", (Object)CertType.ACNT_CER.getType())};
                    DeleteServiceHelper.delete((String)ENTITY_KEY_CER, (QFilter[])cerFilters);
                });
            }
        } else if (StringUtils.equals((CharSequence)"logic_delete", (CharSequence)formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                if (!this.checkExitsBusiness(listSelectedRowCollection)) {
                    args.setCancel(true);
                    return;
                }
                listSelectedRowCollection.forEach(selectedRow -> {
                    String acnt = selectedRow.getNumber();
                    DynamicObject dynamicObject = this.ebcBankAcntRepository.getAcntByAccno(acnt);
                    if (dynamicObject != null) {
                        dynamicObject.set("enable", (Object)0);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    }
                });
                this.getView().invokeOperation("refresh");
            }
        } else if (StringUtils.equals((CharSequence)"modify", (CharSequence)formOperate.getOperateKey()) && selectedRows > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BankAcntListPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public boolean checkExitsBusiness(ListSelectedRowCollection listSelectedRowCollection) {
        for (ListSelectedRow selectedRow : listSelectedRowCollection) {
            String acc_no = selectedRow.getNumber();
            boolean flag = QueryServiceHelper.exists((String)"aqap_bd_paymentinfo", (QFilter[])QFilter.of((String)"acc_no=? and status_id!=12 and status_id!=13", (Object[])new Object[]{acc_no}).toArray());
            if (flag) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8d26\u53f7%s\u5b58\u5728\u5728\u9014\u4ed8\u6b3e\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BankAcntListPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), acc_no));
                return false;
            }
            flag = QueryServiceHelper.exists((String)"aqap_bd_financing", (QFilter[])QFilter.of((String)"acc_no=? and status!='12' and status!='13'", (Object[])new Object[]{acc_no}).toArray());
            if (flag) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8d26\u53f7%s\u5b58\u5728\u5728\u9014\u7406\u8d22\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BankAcntListPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), acc_no));
                return false;
            }
            flag = QueryServiceHelper.exists((String)"bank_cafinfo", (QFilter[])QFilter.of((String)"cur_acc=? and status!='12' and status!='13'", (Object[])new Object[]{acc_no}).toArray());
            if (flag) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8d26\u53f7%s\u5b58\u5728\u5728\u9014\u5b9a\u6d3b\u4e92\u8f6c\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BankAcntListPlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), acc_no));
                return false;
            }
            flag = QueryServiceHelper.exists((String)"aqap_balance_rec_detail", (QFilter[])QFilter.of((String)"acc_no=? and status_id!=12 and status_id!=14", (Object[])new Object[]{acc_no}).toArray());
            if (!flag) continue;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8d26\u53f7%s\u5b58\u5728\u5728\u9014\u4f59\u989d\u5bf9\u8d26\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BankAcntListPlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), acc_no));
            return false;
        }
        return true;
    }
}

