/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.balance;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.entity.biz.balance.Balance;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceResponse;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.esclient.LogInfo;
import kd.ebg.aqap.formplugin.plugin.util.InitComboItemUtil;
import kd.ebg.aqap.formplugin.service.biz.BizService;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import net.sf.json.JSONObject;

public class BankAcntBalanceListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    static final String EB = "eb_BankAcntBalanceListPlugin_";
    private BizService bizService = (BizService)SpringContextUtil.getBean(BizService.class);
    private BankAcntRepository bankAcntRepository = (BankAcntRepository)SpringContextUtil.getBean(BankAcntRepository.class);
    private static final String BUSINESS_BALANCE = "balance";
    private String SELECT_ALL_PROPERTIES_LIST = "id,biz_name,account,bank_version,bank_login,logger_batch_no,logger_detail_no,dt_query,logger_bank_no,logger_type,biz_seq";
    private String ENTITY_NAME_LIST = "aqap_new_log";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.equalsIgnoreCase("group.name")) continue;
            List<ComboItem> bankItems = new InitComboItemUtil().initBankVersionList();
            List currencyItems = commonFilterColumn.getComboItems();
            currencyItems.clear();
            commonFilterColumn.setComboItems(bankItems);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final IPageCache pageCache = this.getPageCache();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynObjs = super.getData(start, limit);
                String userID = RequestContext.get().getUid();
                for (DynamicObject dynamicObject : dynObjs) {
                    String key = "balance_" + userID + "_" + dynamicObject.get("number");
                    String value = pageCache.get(key);
                    if (!StringUtil.isNotNil(value)) continue;
                    com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)value);
                    String currentBalance = jsonObject.getString("current_balance");
                    String availableBalance = jsonObject.getString("available_balance");
                    String selTime = jsonObject.getString("sel_bal_time");
                    String depositBalance = jsonObject.getString("deposit_balance");
                    DecimalFormat df = new DecimalFormat("###,###.##");
                    if (StringUtil.isNotNil(currentBalance)) {
                        dynamicObject.set("current_balance", (Object)df.format(new BigDecimal(currentBalance)));
                    } else {
                        dynamicObject.set("current_balance", (Object)currentBalance);
                    }
                    if (StringUtil.isNotNil(availableBalance)) {
                        dynamicObject.set("available_balance", (Object)df.format(new BigDecimal(availableBalance)));
                    } else {
                        dynamicObject.set("available_balance", (Object)availableBalance);
                    }
                    if (StringUtil.isNotNil(depositBalance)) {
                        dynamicObject.set("deposit_balance", (Object)depositBalance);
                    }
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        if (StringUtil.isNotNil(selTime) && selTime.contains(":") && selTime.length() == 16) {
                            selTime = selTime + ":00";
                        }
                        Date date = sdf.parse(selTime);
                        dynamicObject.set("sel_bal_time", (Object)date);
                    }
                    catch (ParseException parseException) {}
                }
                return dynObjs;
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(QFilter.of((String)"enable = '1'", (Object[])new Object[0]));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"donothing", (CharSequence)formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedRowCollection2 = args.getListSelectedData();
            if (listSelectedRowCollection2 != null && listSelectedRowCollection2.size() > 0) {
                IPageCache pageCache = this.getPageCache();
                String customerID = RequestContext.get().getTenantId();
                String userID = RequestContext.get().getUid();
                listSelectedRowCollection2.forEach(selectedRow -> {
                    String acnt = selectedRow.getNumber();
                    boolean isValid = this.bankAcntRepository.isExsist(acnt, customerID);
                    if (!isValid) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u5230\u8d26\u53f7\uff1a%s\uff0c\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"BankAcntBalanceListPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), acnt));
                        this.getView().invokeOperation("refresh");
                    } else {
                        Balance balance = this.getBalanceResult(customerID, acnt);
                        if (balance != null) {
                            String key = "balance_" + userID + "_" + acnt;
                            HashMap<String, String> map = new HashMap<String, String>(16);
                            map.put("current_balance", balance.getCurrentBalance());
                            map.put("available_balance", balance.getAvailableBalance());
                            map.put("sel_bal_time", balance.getBalanceDateTime());
                            map.put("deposit_balance", balance.getDepositBalance());
                            pageCache.put(key, new com.alibaba.fastjson.JSONObject(map).toJSONString());
                            pageCache.expireAfter(300);
                            this.getView().invokeOperation("refresh");
                        }
                    }
                });
            }
        } else if (StringUtils.equals((CharSequence)"log_view", (CharSequence)formOperate.getOperateKey()) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            for (ListSelectedRow row : listSelectedRowCollection) {
                String acnt = row.getNumber();
                String loggerBatchNo = this.getPageCache().get(EB + acnt + "loggerBatchNo");
                if (StringUtils.isNotEmpty((CharSequence)loggerBatchNo)) {
                    String loggerDetailNo = this.getPageCache().get(EB + acnt + "loggerDetailNo");
                    String loggerBankNo = this.getPageCache().get(EB + acnt + "loggerBankNo");
                    HashMap<String, String> params = new HashMap<String, String>(16);
                    LogInfo logInfos = this.getBizLog(loggerBatchNo, loggerDetailNo, loggerBankNo, "bussiness_index", "batchBalance");
                    if (logInfos == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u751f\u6210\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BankAcntBalanceListPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                        this.getView().invokeOperation("refresh");
                        continue;
                    }
                    args.setCancel(true);
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("aqap_log_detail");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    params.put("log_id", logInfos.getEsId());
                    showParameter.setCustomParams(params);
                    this.getView().showForm(showParameter);
                    continue;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u65e5\u5fd7\uff0c\u8bf7\u5148\u67e5\u8be2\u4f59\u989d\u3002", (String)"BankAcntBalanceListPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public Balance getBalanceResult(String customerID, String accNo) {
        try {
            this.getPageCache().remove(EB + accNo + "loggerBatchNo");
            this.getPageCache().remove(EB + accNo + "loggerDetailNo");
            this.getPageCache().remove(EB + accNo + "loggerBankNo");
            this.bizService = (BizService)SpringContextUtil.getBean(BizService.class);
            BatchBalanceResponse response = this.bizService.todayBalance(customerID, accNo);
            String extDate = response.getHeader().getExtData();
            String loggerBatchNo = "";
            String loggerDetailNo = "";
            String loggerBankNo = "";
            if (extDate != null) {
                JSONObject object = JSONObject.fromObject((Object)extDate);
                loggerBatchNo = (String)object.get("loggerBatchNo");
                loggerDetailNo = (String)object.get("loggerDetailNo");
                loggerBankNo = (String)object.get("loggerBankNo");
            }
            this.getPageCache().put(EB + accNo + "loggerBatchNo", loggerBatchNo);
            this.getPageCache().put(EB + accNo + "loggerDetailNo", loggerDetailNo);
            this.getPageCache().put(EB + accNo + "loggerBankNo", loggerBankNo);
            List balances = response.getBody().getBalances();
            Balance balance = (Balance)balances.get(0);
            if (balances.size() > 1) {
                for (Balance myBalance : balances) {
                    if (!StringUtil.isNil(myBalance.getError())) continue;
                    balance = myBalance;
                    break;
                }
            }
            if (StringUtil.isNotNil(balance.getError())) {
                this.getView().showErrorNotification(balance.getError());
                return null;
            }
            return balance;
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
            return null;
        }
    }

    public LogInfo getBizLog(String logger_batch_no, String logger_detail_no, String logger_bank_no, String bussiness_type, String bizName) {
        DynamicObject results;
        QFilter filter1;
        QFilter filter = QFilter.of((String)"logger_batch_no = ?", (Object[])new Object[]{logger_batch_no});
        if (kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(logger_detail_no)) {
            filter1 = QFilter.of((String)"logger_detail_no = ?", (Object[])new Object[]{logger_detail_no});
            filter.and(filter1);
        }
        if (kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(logger_bank_no)) {
            filter1 = QFilter.of((String)"logger_bank_no = ?", (Object[])new Object[]{logger_bank_no});
            filter.and(filter1);
        }
        if (kd.ebg.aqap.formplugin.util.StringUtils.isNotEmpty(bizName)) {
            filter1 = QFilter.of((String)"biz_name = ?", (Object[])new Object[]{bizName});
            filter.and(filter1);
        }
        if ((results = BusinessDataServiceHelper.loadSingle((String)this.ENTITY_NAME_LIST, (String)this.SELECT_ALL_PROPERTIES_LIST, (QFilter[])filter.toArray())) != null) {
            LogInfo info = new LogInfo();
            info.setEsId(results.getString("id"));
            return info;
        }
        return null;
    }
}

