/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.bank;

import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.log.api.OpLogAppInfo;
import kd.ebg.aqap.common.model.BankFile;
import kd.ebg.aqap.common.model.repository.BankFileRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.common.EbcAddBankListPlugin;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.utils.log.OperationLogUtil;

public class BankFileListPlugin
extends EbcAddBankListPlugin {
    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        ListSelectedRowCollection rowCollections = args.getListSelectedData();
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals("show_content", formOperate.getOperateKey())) {
            ListSelectedRow listSelectedRow = rowCollections.get(0);
            Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
            params.put("file_primary_key", String.valueOf(primaryKeyValue));
            args.setCancel(true);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("aqap_show_bank_file");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals("download_file", formOperate.getOperateKey())) {
            if (rowCollections.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4e0b\u8f7d\u5355\u4e2a\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BankFileListPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow listSelectedRow = rowCollections.get(0);
            Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
            BankFileRepository bankFileRepository = (BankFileRepository)SpringContextUtil.getBean(BankFileRepository.class);
            if (primaryKeyValue != null) {
                BankFile bankFile = bankFileRepository.findById(primaryKeyValue.longValue());
                TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
                String url = tfc.saveAsUrl(bankFile.getFileName(), bankFile.getFileContent().getBytes(), 120);
                this.getView().download(url);
                this.getView().invokeOperation("refresh");
            }
        } else if (StringUtils.equals("delete_file", formOperate.getOperateKey())) {
            BankFileRepository bankFileRepository = (BankFileRepository)SpringContextUtil.getBean(BankFileRepository.class);
            for (ListSelectedRow listSelectedRow : rowCollections) {
                Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
                BankFile bankFile = bankFileRepository.findById(primaryKeyValue.longValue());
                bankFileRepository.deleteById(primaryKeyValue);
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "BankFileListPlugin_0", "ebg-aqap-formplugin");
                MultiLangEnumBridge descBridge = new MultiLangEnumBridge("\u7528\u6237:%1$s\u5220\u9664\u4e86\u94f6\u884c\u6587\u4ef6:%2$s\u3002", "BankFileListPlugin_2", "ebg-aqap-formplugin");
                OpLogAppInfo opLogAppInfo = OperationLogUtil.getOpLogAppInfo((String)"aqap", (String)this.getView().getEntityId(), (String)"delete", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[]{RequestContext.get().getUserName(), bankFile.getFileName()});
                this.operateLog(opLogAppInfo);
            }
            args.setCancel(true);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BankFileListPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void operateLog(OpLogAppInfo opLogAppInfo) {
        OperationLogUtil.recordInvoke((OpLogAppInfo)opLogAppInfo);
    }
}

