/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.bank;

import java.util.EventObject;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.ebg.aqap.common.model.BankFile;
import kd.ebg.aqap.common.model.repository.BankFileRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;

public class ShowBankFilePlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String file_primary_key = "";
        if (params != null) {
            file_primary_key = (String)params.get("file_primary_key");
        }
        if (StringUtils.equals("download_file", (formOperate = (FormOperate)args.getSource()).getOperateKey()) && StringUtils.isNotEmpty(file_primary_key)) {
            BankFileRepository bankFileRepository = (BankFileRepository)SpringContextUtil.getBean(BankFileRepository.class);
            BankFile bankFile = bankFileRepository.findById(Long.parseLong(file_primary_key));
            if (bankFile == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u7ecf\u88ab\u5220\u9664\u65e0\u6cd5\u4e0b\u8f7d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ShowBankFilePlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String url = tfc.saveAsUrl(bankFile.getFileName(), bankFile.getFileContent().getBytes(), 120);
            this.getView().download(url);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        BankFile bankFile;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String file_primary_key = "";
        if (params != null && (file_primary_key = (String)params.get("file_primary_key")) != null) {
            this.getPageCache().put("eb_file_primary_key", file_primary_key);
        }
        if ((bankFile = this.getBankFile(file_primary_key)) != null) {
            this.getModel().setValue("file_content", (Object)bankFile.getFileContent());
        } else {
            this.getModel().setValue("file_content", (Object)"");
        }
    }

    private BankFile getBankFile(String primaryKey) {
        if (StringUtils.isEmpty(primaryKey)) {
            return null;
        }
        BankFileRepository bankFileRepository = (BankFileRepository)SpringContextUtil.getBean(BankFileRepository.class);
        BankFile bankFile = bankFileRepository.findById(Long.parseLong(primaryKey));
        return bankFile;
    }
}

