/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.bankversion;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.entity.bank.SameBankKeyWordEntity;
import kd.ebg.aqap.common.model.repository.SameBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.framework.service.keywords.BankKeyWordsService;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;

public class SameBankKeyWordPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final String FIELD_KEY_BANK_KEYWORD = "aqap_same_bank_keyword";

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.incomePageInit();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void incomePageInit() {
        String bankVersionIdString;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap) && !StringUtil.isNullOrEmpty(bankVersionIdString = (String)paramMap.get("bankVersionId"))) {
            Long bankVersionId = Long.parseLong(bankVersionIdString);
            BankVersionRepository bankVersionRepository = (BankVersionRepository)SpringContextUtil.getBean(BankVersionRepository.class);
            DynamicObject bankDynamicObject = bankVersionRepository.loadDynamicObjectByID(bankVersionId);
            String bankVersion = bankDynamicObject.getString("number");
            String name = bankDynamicObject.getString("name");
            this.getModel().setValue("bank_number", (Object)bankVersion);
            this.getModel().setValue("bank_name", (Object)name);
            this.getModel().getDataEntity().set("bank_number", (Object)bankVersion);
            this.getModel().getDataEntity().set("bank_name", (Object)name);
            SameBankKeyWordsRepository bankKeyWordsRepository = (SameBankKeyWordsRepository)SpringContextUtil.getBean(SameBankKeyWordsRepository.class);
            List sameBankKeyWordEntities = bankKeyWordsRepository.findListByBankVersion(bankVersion);
            if (sameBankKeyWordEntities.size() > 0) {
                IDataModel entryOperate = this.getModel();
                entryOperate.deleteEntryData("entryentity");
            }
            for (int i = 0; i < sameBankKeyWordEntities.size(); ++i) {
                SameBankKeyWordEntity sameBankKeyWordEntity = (SameBankKeyWordEntity)sameBankKeyWordEntities.get(i);
                String bankWord = sameBankKeyWordEntity.getBankKey();
                long id = sameBankKeyWordEntity.getId();
                this.addRow(bankWord, id);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"word_id"});
        }
    }

    private void addRow(String bankWord, long id) {
        IDataModel entryOperate = this.getModel();
        int row = entryOperate.createNewEntryRow("entryentity");
        this.getModel().setValue("bank_key", (Object)bankWord, row);
        this.getModel().setValue("word_id", (Object)id, row);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"update_bank_word", (CharSequence)formOperate.getOperateKey())) {
            String bankVersionId = (String)this.getModel().getDataEntity().get("bank_number");
            String alertMsg = this.checkTreeGrid();
            if (!StringUtil.isNullOrEmpty(alertMsg)) {
                this.getView().showTipNotification(alertMsg);
                args.setCancel(true);
                return;
            }
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            HashMap oldWordIdOfPage = Maps.newHashMapWithExpectedSize((int)16);
            HashMap bankWordMaps = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList<String> newWordIdOfPage = new ArrayList<String>(16);
            HashMap tabList = Maps.newHashMapWithExpectedSize((int)16);
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", i);
                String bankWord = dynamicObject.getString("bank_key");
                String wordIdStr = dynamicObject.getString("word_id");
                if (StringUtil.isNotNil(bankWord)) {
                    if (bankWordMaps.containsKey(bankWord)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5173\u952e\u5b57\uff1a%s\u4e0d\u662f\u552f\u4e00\uff0c\u4e0d\u80fd\u51fa\u73b0\u91cd\u590d\u7684\u5173\u952e\u5b57\u3002", (String)"SameBankKeyWordPlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankWord));
                        args.setCancel(true);
                        return;
                    }
                    bankWordMaps.put(bankWord, bankWord);
                }
                if (StringUtil.isNotNil(wordIdStr)) {
                    Long wordId = Long.parseLong(wordIdStr);
                    oldWordIdOfPage.put(wordId, bankWord);
                } else {
                    newWordIdOfPage.add(bankWord);
                }
                tabList.put(bankWord, i);
            }
            this.handleBankWordSaveOrUpdate(bankVersionId, oldWordIdOfPage, newWordIdOfPage, tabList);
        }
    }

    public static boolean isSpecialChar(String str) {
        String regEx = "[_`~!@#$%^&*+=|{}':;',\\[\\].<>/?~\u3002@#\uffe5%\u2026\u2026&*\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public void handleBankWordSaveOrUpdate(String bankVersionId, Map<Long, String> oldWordIdOfPage, List<String> newWordIdOfPage, Map<String, Integer> tabList) {
        SameBankKeyWordsRepository bankKeyWordsRepository = (SameBankKeyWordsRepository)SpringContextUtil.getBean(SameBankKeyWordsRepository.class);
        List sameBankKeyWordList = bankKeyWordsRepository.findListByBankVersion(bankVersionId);
        ArrayList deleteIds = new ArrayList(16);
        sameBankKeyWordList.forEach(sameBankKeyWordEntity -> {
            Long wordId = sameBankKeyWordEntity.getId();
            if (oldWordIdOfPage.containsKey(sameBankKeyWordEntity.getId())) {
                String bankWord = (String)oldWordIdOfPage.get(wordId);
                sameBankKeyWordEntity.setBankKey(bankWord);
                sameBankKeyWordEntity.setModifierid(RequestContext.get().getAccountId());
                bankKeyWordsRepository.update(sameBankKeyWordEntity);
            } else {
                deleteIds.add(wordId);
            }
        });
        newWordIdOfPage.forEach(bankWord -> {
            SameBankKeyWordEntity sameBankKeyWordEntity = new SameBankKeyWordEntity();
            sameBankKeyWordEntity.setBankKey(bankWord);
            sameBankKeyWordEntity.setBankVersionId(bankVersionId);
            sameBankKeyWordEntity.setCreatorid(RequestContext.get().getAccountId());
            sameBankKeyWordEntity.setEnable(1);
            long recordId = bankKeyWordsRepository.save(sameBankKeyWordEntity);
            int row = (Integer)tabList.get(bankWord);
            this.getModel().setValue("word_id", (Object)recordId, row);
        });
        deleteIds.forEach(o -> bankKeyWordsRepository.deleteById(o));
        List keyWords = BankKeyWordsService.getInstance().getKeyWords(bankVersionId);
        if (keyWords != null && !keyWords.isEmpty()) {
            BankBundleManager.getInstance().setKeyWords(bankVersionId, keyWords);
        }
    }

    public String checkTreeGrid() {
        String msg = "";
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : entryentity) {
            String bankWord = dynamicObject.getString("bank_key");
            if (StringUtils.isEmpty((CharSequence)bankWord)) {
                sb.append(ResManager.loadKDString((String)"\u5173\u952e\u5b57\u540d\u79f0\u5b57\u6bb5\u4e3a\u7a7a", (String)"SameBankKeyWordPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0])).append('\uff0c');
            }
            if (SameBankKeyWordPlugin.isSpecialChar(bankWord)) {
                sb.append(ResManager.loadKDString((String)"\u5173\u952e\u5b57\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u3002", (String)"SameBankKeyWordPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0])).append('\uff0c');
            }
            if (StringUtils.isEmpty((CharSequence)sb.toString())) continue;
            sb.append(String.format(ResManager.loadKDString((String)"\u5173\u952e\u5b57\uff1a%s\u3002", (String)"SameBankKeyWordPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankWord)).append("\u3002\r\n");
            msg = sb.toString();
            break;
        }
        return msg;
    }
}

