/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.cacert;

import java.io.FileWriter;
import java.io.IOException;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class FileHandler {
    public static String copyPublicFile(CertInfo certInfo) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(FileHandler.class);
        String defaultPublicKeyPath = "/mservice/lib/biz/PUBLICKEY.txt";
        String content = FileHandler.getSecretKey(certInfo);
        try (FileWriter writer = new FileWriter(defaultPublicKeyPath);){
            writer.write(content);
        }
        catch (IOException e) {
            logger.info("\u5199\u5165\u6587\u4ef6\u5f02\u5e38" + e.getMessage());
        }
        return defaultPublicKeyPath;
    }

    public static String getSecretKey(CertInfo certInfo) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(certInfo.getFileContent());
        int version = cipherInfo.getCipherVersion();
        byte[] certBytes = Base64.decodeBase64((String)cipherInfo.getCipherData());
        byte[] plainData = DesUtil.decryptProxyCert((byte[])certBytes, (String)certInfo.getCustomID(), (int)version, (String)"");
        return StringUtils.byteToString((byte[])plainData);
    }
}

