/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.cacert.bankCert;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.ebg.aqap.formplugin.plugin.cacert.bankCert.BankCertInfoGenerateImpl;

public class BankCASettingPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("custom_id", (Object)RequestContext.get().getTenantId());
        this.getModel().setValue("account_id", (Object)RequestContext.get().getAccountId());
        this.getModel().setValue("username", (Object)RequestContext.get().getUserName());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"downloadcert", (CharSequence)formOperate.getOperateKey())) {
            BankCertInfoGenerateImpl bankCertInfoGenerate = new BankCertInfoGenerateImpl();
            try (InputStream inputStream = bankCertInfoGenerate.generateCerInfo();){
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Object bankVersion = formShowParameter.getCustomParam("bankVersion");
                TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
                String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"));
                String url = tfc.saveAsUrl(time + "_" + bankVersion + ".zip", inputStream, 120);
                this.getView().download(url);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25:%s\u3002", (String)"BankCASettingPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }
}

