/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.cacert.bankCert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

class BankCertInfoGenerateImpl {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankCertInfoGenerateImpl.class);

    BankCertInfoGenerateImpl() {
    }

    private KeyPair generateInnerSm2KeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        try {
            ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", (Provider)new BouncyCastleProvider());
            SecureRandom random = new SecureRandom();
            kpg.initialize(sm2Spec, random);
            KeyPair keyPair = kpg.generateKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u79d8\u94a5\u5f02\u5e38:{}", new Object[]{e.getMessage()});
            throw e;
        }
    }

    public InputStream generateCerInfo() throws Exception {
        KeyPair sm2KeyPair = this.generateInnerSm2KeyPair();
        BCECPrivateKey privateKey = (BCECPrivateKey)sm2KeyPair.getPrivate();
        BCECPublicKey publicKey = (BCECPublicKey)sm2KeyPair.getPublic();
        byte[] result = publicKey.getQ().getEncoded(false);
        byte[] result2 = privateKey.getD().toByteArray();
        String hexPublicKey = Hex.encodeHexString((byte[])result);
        String hexPrivateKey = Hex.encodeHexString((byte[])result2);
        String pKey = Base64.encodeBase64String((byte[])hexPublicKey.getBytes());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zipOut = new ZipOutputStream(byteArrayOutputStream);){
            BankCertInfoGenerateImpl.addToZip(zipOut, ResManager.loadKDString((String)"\u7b7e\u540d\u53ca\u89e3\u5bc6\u79c1\u94a5.txt", (String)"BankCertInfoGenerateImpl_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), hexPrivateKey);
            BankCertInfoGenerateImpl.addToZip(zipOut, ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6362\u516c\u94a5.txt", (String)"BankCertInfoGenerateImpl_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), pKey);
        }
        byte[] zipBytes = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(zipBytes);
    }

    private static void addToZip(ZipOutputStream zipOut, String entryName, String content) throws IOException {
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = content.getBytes();
        zipOut.write(bytes, 0, bytes.length);
        zipOut.closeEntry();
    }
}

