/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.currency;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.baseplugin.EBGBasePlugin;
import kd.ebg.aqap.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;
import kd.ebg.egf.common.utils.log.OperationLogUtil;

public class bankCurrencyListPlugin
extends EBGBasePlugin {
    private EbcBankAcntRepository ebcBankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("bank_version.enable", "=", (Object)"1"));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        ((BillList)args.getSource()).getQueryFilterParameter().getQFilters().add(new QFilter("bank_version.enable", "=", (Object)"1"));
        super.beforeCreateListDataProvider(args);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        ListSelectedRowCollection collection = args.getListSelectedData();
        if (CollectionUtil.isNotEmpty((Collection)collection)) {
            ListSelectedRow selectedRow = collection.get(0);
            long id = (Long)selectedRow.getPrimaryKeyValue();
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DynamicObject dynamicObject = QueryCacheUtil.getSingleDynamicObject((String)"aqap_bank_currency", (String)"bank_version.number", (QFilter[])filter.toArray());
            String bankVersion = dynamicObject.getString("bank_version.number");
            String number = selectedRow.getNumber();
            if (StringUtils.equals((CharSequence)"delete", (CharSequence)formOperate.getOperateKey())) {
                if (this.ebcBankAcntRepository.existAcntByBankVersonAndCurrency(bankVersion, number)) {
                    this.getView().showTipNotification(MultiLang.getDeleteBankAcntTip(number));
                    args.setCancel(true);
                } else {
                    MultiLangEnumBridge descBridge = new MultiLangEnumBridge("\u94f6\u884c\u7248\u672c\uff1a%1$s\uff0c\u5220\u9664ISO\u5e01\u79cd[%2$s]\u3002", "bankCurrencyListPlugin_1", "ebg-aqap-formplugin");
                    OperationLogUtil.recordInvoke((String)"aqap", (FormOperate)formOperate, (MultiLangEnumBridge)descBridge, (String[])new String[]{bankVersion, number});
                }
            } else if (StringUtils.equals((CharSequence)"modify", (CharSequence)formOperate.getOperateKey())) {
                MultiLangEnumBridge descBridge = new MultiLangEnumBridge("\u94f6\u884c\u7248\u672c\uff1a%1$s\uff0c\u4fee\u6539ISO\u5e01\u79cd[%2$s]\u3002", "bankCurrencyListPlugin_2", "ebg-aqap-formplugin");
                OperationLogUtil.recordInvoke((String)"aqap", (FormOperate)formOperate, (MultiLangEnumBridge)descBridge, (String[])new String[]{bankVersion, number});
            }
        }
    }
}

