/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.detail;

import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.formplugin.util.StringUtil;

public class DetailEarlyWarningFormPlugin
extends AbstractFormPlugin {
    private static final String OBJECTID = "detail_early_warning_setting";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String selectFields = "attr_key, attr_value";
        QFilter filter = QFilter.of((String)"object_id=?  and object_name=?", (Object[])new Object[]{OBJECTID, OBJECTID});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_object_properties", (String)selectFields, (QFilter[])filter.toArray());
        HashMap<String, String> mm = new HashMap<String, String>(16);
        for (DynamicObject d : dynamicObjects) {
            mm.put(d.getString("attr_key"), d.getString("attr_value"));
        }
        this.getModel().setValue("alert_type", (Object)ResManager.loadKDString((String)"\u624b\u673a\u77ed\u4fe1", (String)"SJDX_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("phone_number", mm.get("phone_number"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"alert_save", (CharSequence)formOperate.getOperateKey())) {
            String phoneNumber = this.getModel().getValue("phone_number").toString();
            if (StringUtil.isNotNil(phoneNumber)) {
                String[] res = phoneNumber.split("\\;");
                for (int i = 0; i < res.length; ++i) {
                    if (DetailEarlyWarningFormPlugin.isChinaPhoneLegal(res[i])) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u624b\u673a\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u5f55\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u3002", (String)"DetailEarlyWarningFormPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), i + 1));
                    args.setCancel(true);
                    return;
                }
            }
            this.delete();
            this.save(phoneNumber);
        }
    }

    void delete() {
        QFilter[] qFilters = new QFilter[]{new QFilter("object_id", "=", (Object)OBJECTID), new QFilter("object_name", "=", (Object)OBJECTID)};
        DeleteServiceHelper.delete((String)"aqap_object_properties", (QFilter[])qFilters);
    }

    void save(String phoneNumber) {
        String customID = RequestContext.get().getTenantId();
        DynamicObject dataEntity1 = BusinessDataServiceHelper.newDynamicObject((String)"aqap_object_properties");
        dataEntity1.set("attr_key", (Object)"phone_number");
        dataEntity1.set("attr_value", (Object)phoneNumber);
        dataEntity1.set("object_id", (Object)OBJECTID);
        dataEntity1.set("object_name", (Object)OBJECTID);
        dataEntity1.set("custom_id", (Object)customID);
        DynamicObject[] dataEntities = new DynamicObject[]{dataEntity1};
        SaveServiceHelper.saveOperate((String)"aqap_object_properties", (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
    }

    public static boolean isChinaPhoneLegal(String str) throws PatternSyntaxException {
        String regExp = "^((13[0-9])|(14[5,7,9])|(15[0-3,5-9])|(166)|(17[3,5,6,7,8])|(18[0-9])|(19[8,9]))\\d{8}$";
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(str);
        return m.matches();
    }
}

