/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.detail;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ebg.aqap.formplugin.lang.MultiLang;

public class DetailExtraPlugin
extends AbstractTreeListPlugin {
    private static final String ENTITY_KEY_BANK = "aqap_bank";

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        TreeListModel model = (TreeListModel)this.getTreeListView().getTreeModel();
        model.getQueryParas().put("order", "sort_num asc, number asc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("tblnew".equals(operateKey)) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            Map focusNode = treeView.getTreeState().getFocusNode();
            String text = (String)focusNode.get("text");
            if (ResManager.loadKDString((String)"\u5168\u90e8", (String)"DetailExtraPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]).equals(text)) {
                this.getView().showTipNotification(MultiLang.getSelectBankTip());
                args.setCancel(true);
                return;
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            Long fid = Long.parseLong((String)focusNode.get("id"));
            QFilter qFilter = QFilter.of((String)"id=?", (Object[])new Object[]{fid});
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)ENTITY_KEY_BANK, (String)"id, number, name, bank_name, status, enable", (QFilter[])qFilter.toArray());
            String bankversionID = ((DynamicObject)dynamicObjectCollection.get(0)).getString("number");
            customParams.put("bankName", text);
            customParams.put("bankVersionID", bankversionID);
            customParams.put("modifier", RequestContext.get().getUserName());
            customParams.put("modifieddate", new Date().toString());
            customParams.put("addnew", "1");
            this.showFormPage("detail_extra_field_add", customParams, OperationStatus.ADDNEW, this.getView());
        } else if ("updatefield".equals(operateKey)) {
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            String bankversionidAndextraField = "";
            String id = "";
            if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                bankversionidAndextraField = listSelectedRowCollection.get(0).getNumber();
                id = String.valueOf(listSelectedRowCollection.get(0).getPrimaryKeyValue());
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            String[] res = bankversionidAndextraField.split("\\|");
            QFilter qFilter = QFilter.of((String)"status=? and enable=? and number =?", (Object[])new Object[]{"C", "1", res[0]});
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)ENTITY_KEY_BANK, (String)"id, number, name, bank_name, status, enable", (QFilter[])qFilter.toArray());
            String bankName = ((DynamicObject)dynamicObjectCollection.get(0)).getString("name");
            customParams.put("id", id);
            customParams.put("number", bankversionidAndextraField);
            customParams.put("bankVersionID", res[0]);
            customParams.put("extraField", res[1]);
            customParams.put("bankName", bankName);
            customParams.put("modifier", RequestContext.get().getUserName());
            customParams.put("modifieddate", new Date().toString());
            this.showFormPage("detail_extra_field_update", customParams, OperationStatus.EDIT, this.getView());
        } else if ("delete".equals(operateKey)) {
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            String bankversionidAndInterface = "";
            if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                bankversionidAndInterface = listSelectedRowCollection.get(0).getNumber();
            }
            this.deleteOne(bankversionidAndInterface);
            args.setCancel(true);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DetailExtraPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    void deleteOne(String bankversionidAndInterface) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)bankversionidAndInterface)};
        DeleteServiceHelper.delete((String)"detail_extra_field_r", (QFilter[])qFilters);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String result;
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null && "create_success".equals(result = (String)closedCallBackEvent.getReturnData())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void showFormPage(String entityKey, Map<String, Object> customParams, OperationStatus status, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(entityKey);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        if (!CollectionUtils.isEmpty(customParams)) {
            showParameter.setCustomParams(customParams);
        }
        showParameter.setStatus(status);
        view.showForm(showParameter);
    }
}

