/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.detail;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.repository.DetailExtraFieldRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class saveExtraFieldPlugin
extends AbstractFormPlugin
implements IBillPlugin {
    private DetailExtraFieldRepository detailExtraFieldRepository = (DetailExtraFieldRepository)SpringContextUtil.getBean(DetailExtraFieldRepository.class);
    private BankVersionRepository bankVersionRepository = (BankVersionRepository)SpringContextUtil.getBean(BankVersionRepository.class);

    public void afterLoadData(EventObject e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("btn_save".equals(formOperate.getOperateKey())) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            DynamicObject d = (DynamicObject)collection.get(0);
            String finalField = d.getString("extra_field");
            if (StringUtils.isNotEmpty((String)finalField)) {
                this.saveData(args);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6269\u5c55\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002", (String)"saveExtraFieldPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    void setDefaultData() {
        String[] codes;
        String p2;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        HashMap<String, Integer> bizCodes = new HashMap<String, Integer>();
        List IDtailClassList = BankBundleManager.getInstance().getImpl((String)paramMap.get("bankVersionID"), IDetail.class);
        List IHisDtailClassList = BankBundleManager.getInstance().getImpl((String)paramMap.get("bankVersionID"), IHisDetail.class);
        for (Class cls : IDtailClassList) {
            try {
                p2 = ((IBankService)cls.newInstance()).getBizCode();
                for (String pp : codes = p2.split("[; ,]")) {
                    if (bizCodes.containsKey(pp)) continue;
                    bizCodes.put(pp, 1);
                }
            }
            catch (Exception p2) {
            }
        }
        for (Class cls : IHisDtailClassList) {
            try {
                p2 = ((IBankService)cls.newInstance()).getBizCode();
                for (String pp : codes = p2.split("[; ,]")) {
                    if (bizCodes.containsKey(pp)) continue;
                    bizCodes.put(pp, 1);
                }
            }
            catch (Exception exception) {
            }
        }
        for (String b : bizCodes.keySet()) {
            if (this.detailExtraFieldRepository.hasInterface((String)paramMap.get("bankVersionID"), b)) continue;
            data.add(new ComboItem(new LocaleString(b), b));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
        comboEdit.setComboItems(data);
    }

    void saveData(BeforeDoOperationEventArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String bankVersionID = paramMap.get("bankVersionID").toString();
        String isNew = paramMap.get("addnew").toString();
        if (this.isRight(bankVersionID, args) && "1".equalsIgnoreCase(isNew)) {
            this.save(bankVersionID);
            this.getView().showTipNotification(MultiLang.getAddNewSuccessTip());
        }
    }

    void save(String bankVersionID) {
        String customID = RequestContext.get().getTenantId();
        String modifier = RequestContext.get().getUserName();
        String detailInterface = (String)this.getModel().getValue("combofield");
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"detail_extra_field_r");
        IDataModel entryOperate = this.getModel();
        DynamicObjectCollection collection = entryOperate.getEntryEntity("entryentity");
        DynamicObject d = (DynamicObject)collection.get(0);
        String finalField = d.getString("extra_field");
        String des = d.getString("description");
        dataEntity.set("number", (Object)(bankVersionID + "|" + finalField));
        dataEntity.set("group", (Object)this.bankVersionRepository.loadDynamicObjectByBankVersionID(bankVersionID));
        dataEntity.set("detail_interface", (Object)detailInterface);
        dataEntity.set("custom_id", (Object)customID);
        dataEntity.set("extra_field", (Object)finalField);
        dataEntity.set("description", (Object)des);
        dataEntity.set("spare", (Object)"");
        dataEntity.set("bank_version_id", (Object)bankVersionID);
        dataEntity.set("updatename", (Object)modifier);
        dataEntity.set("modifytime", (Object)new Date());
        DynamicObject[] dataEntities = new DynamicObject[]{dataEntity};
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private boolean isRight(String bankVersionID, BeforeDoOperationEventArgs args) {
        String combofield = (String)this.getModel().getDataEntity().get("combofield");
        if (StringUtil.isNil(combofield)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u63a5\u53e3\u5fc5\u9009\u3002", (String)"saveExtraFieldPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        if (this.isRepeat(bankVersionID).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6269\u5c55\u5b57\u6bb5\u91cd\u590d\u3002", (String)"saveExtraFieldPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private Boolean isRepeat(String bankVersionID) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", 0);
        String number = bankVersionID + "|" + dynamicObject.getString("extra_field");
        List result = this.detailExtraFieldRepository.findByNumber(number);
        return result.size() > 0;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        this.getModel().setValue("bankversion", paramMap.get("bankName"));
        this.getModel().setValue("bankversionid", paramMap.get("bankVersionID"));
        this.getModel().setValue("modifier", paramMap.get("modifier"));
        this.getModel().setValue("modifieddate", (Object)DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        if ("1".equalsIgnoreCase(paramMap.get("addnew").toString())) {
            this.setDefaultData();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        this.getView().returnDataToParent((Object)"create_success");
    }
}

