/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.license;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.egf.common.license.old.License;
import kd.ebg.egf.common.license.old.LicenseManager;
import kd.ebg.egf.common.license.old.ModuleLicenseInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.license.LicenseFile;
import kd.ebg.egf.common.repository.license.LicenseFileRepository;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;

public class OldLicenseParsePlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(OldLicenseParsePlugin.class);
    private static final String KEY_ATTACHMENTPANEL = "ebc_attachmentpanelap";
    private String EB_UPLOAD = "eb_oldLicenseParsePlugin_isUpload";
    private String EB_SAVE = "eb_oldLicenseParsePlugin_isSave";
    private String EB_LICENSE_INFO = "eb_oldLicenseParsePlugin_licenseInfo";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        ArrayList<String> fileUrls = new ArrayList<String>(1);
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        for (String fileUrl : fileUrls) {
            this.loadLicenseFileAndSave(fileUrl);
        }
    }

    private void loadLicenseFileAndSave(String fileUrl) {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inStream = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(16);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
            String fileName = content.getFilename();
            byte[] licenseFileBytes = OldLicenseParsePlugin.input2byte(inStream);
            License license = LicenseManager.getLicense((byte[])licenseFileBytes);
            if (license == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"license\u8bfb\u53d6\u5f02\u5e38,\u8bf7\u68c0\u67e5\u3002", (String)"OldLicenseParsePlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            List moduleDetails = license.getModuleDetails();
            ModuleLicenseInfo moduleLicenseInfo = null;
            for (ModuleLicenseInfo info : moduleDetails) {
                if (!"QUERY_PAY".equals(info.getModuleName())) continue;
                moduleLicenseInfo = info;
                break;
            }
            if (moduleLicenseInfo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"license\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u67e5\u8be2\u4e0e\u652f\u4ed8\u6a21\u5757\u3002", (String)"OldLicenseParsePlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            String customId = RequestContext.get().getTenantId();
            String src_softwareCode = license.getSrc_SoftwareCode();
            if (!src_softwareCode.equalsIgnoreCase(LicenseManager.getCustomerFeatureCode((String)customId))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7279\u5f81\u7801\uff1a%s\u4e0d\u5339\u914d\u5f53\u524d\u5ba2\u6237\u3002", (String)"OldLicenseParsePlugin_7", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), src_softwareCode));
                return;
            }
            LicenseFile file = new LicenseFile();
            file.setFileBytes(licenseFileBytes);
            file.setUploadTime(LocalDateTime.now());
            String pattern = "yyyyMMddHHmmss";
            file.setExpireTime(LocalDateTime.parse(DateTimeUtils.format((Date)license.getExpireDate(), (String)pattern), DateTimeFormatter.ofPattern(pattern)));
            file.setLicenseCount(Integer.valueOf(moduleLicenseInfo.getLicenseNum()));
            file.setCustomId(customId);
            this.getPageCache().put(this.EB_LICENSE_INFO, JSONObject.toJSONString((Object)file));
            this.getPageCache().put(this.EB_UPLOAD, "true");
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u8bb8\u53ef\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bb8\u53ef\u89e3\u6790\u5931\u8d25,\u8bf7\u786e\u8ba4\u8bb8\u53ef\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"OldLicenseParsePlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public static final byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String tenantId = RequestContext.get().getTenantId();
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey())) {
            LicenseFileRepository licenseFileRepository = (LicenseFileRepository)SpringContextUtil.getBean(LicenseFileRepository.class);
            LicenseFile licenseFile = licenseFileRepository.findByCustomId(tenantId);
            if (licenseFile != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u8bb8\u53ef\u540e\u518d\u8fdb\u884c\u5bfc\u5165\u3002", (String)"OldLicenseParsePlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!Boolean.parseBoolean(this.getPageCache().get(this.EB_UPLOAD))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6210\u4e0a\u4f20\u8bb8\u53ef\u540e\uff0c\u518d\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"OldLicenseParsePlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            LicenseFile license = (LicenseFile)JSONObject.parseObject((String)this.getPageCache().get(this.EB_LICENSE_INFO), LicenseFile.class);
            if (license != null) {
                licenseFileRepository.save(license);
                this.getPageCache().put(this.EB_SAVE, "true");
            }
            this.getView().showSuccessNotification(MultiLang.getSaveSuccessTip());
            this.getView().invokeOperation("close");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        if ("true".equals(this.getPageCache().get(this.EB_SAVE))) {
            this.getView().returnDataToParent((Object)"save_success");
        }
    }
}

