/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.mock.pay;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.ebg.aqap.business.payment.route.PayTypeEnum;
import kd.ebg.aqap.common.entity.biz.pay.PayDetail;
import kd.ebg.aqap.common.entity.biz.pay.PayResponse;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.service.biz.BizService;
import kd.ebg.egf.common.framework.biz.BizTypeEnum;

public class MockPayTestPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static String COMBO_PAY_TYPE = "pay_type";
    public static String COMBO_MERGE = "merge";
    public static String COMBO_PAY_TYPE_COMPANY = "company";
    public static String COMBO_PAY_TYPE_INDIVIDUAL = "individual";
    public static String COMBO_PAY_TYPE_REIM = "reim";
    public static String COMBO_PAY_TYPE_SALARY = "salary";
    public static String BASE_DATA_ACC_NO = "account";
    public static String COMBO_VALUE_FALSE = "false";
    public static String OPERATE_KEY_TEST = "test";
    public static String OPERATE_KEY_EXIT = "exit";
    public static String OPERATE_KEY_NEW_ENTRY = "newentry";
    public static String TEXT_BATCH_SEQ = "batch_seq";
    public static String ENTITY_NAME = "aqap_mock_pay_route";

    public void registerListener(EventObject e) {
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(BASE_DATA_ACC_NO);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (BASE_DATA_ACC_NO.equalsIgnoreCase(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setShowApproved(false);
        }
    }

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{COMBO_MERGE});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (COMBO_PAY_TYPE.equalsIgnoreCase(e.getProperty().getName())) {
            boolean isShow;
            String payType = (String)this.getModel().getValue(COMBO_PAY_TYPE);
            boolean bl = isShow = COMBO_PAY_TYPE_REIM.equalsIgnoreCase(payType) || COMBO_PAY_TYPE_SALARY.equalsIgnoreCase(payType);
            if (!isShow) {
                this.getModel().setValue(COMBO_MERGE, (Object)COMBO_VALUE_FALSE);
            }
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{COMBO_MERGE});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int count;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (OPERATE_KEY_TEST.equalsIgnoreCase(formOperate.getOperateKey())) {
            this.getModel().setValue(TEXT_BATCH_SEQ, (Object)String.valueOf(ID.genLongId()));
        } else if (OPERATE_KEY_NEW_ENTRY.equalsIgnoreCase(formOperate.getOperateKey()) && (count = this.getModel().getEntryRowCount("paymentinfo")) >= 100) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u652f\u4ed8\u4fe1\u606f\u6700\u5927\u6570\u91cf\u4ec5\u652f\u6301100\u6761\u3002", (String)"MockPayTestPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            FormOperate formOperate = (FormOperate)args.getSource();
            String operateKey = formOperate.getOperateKey();
            if (OPERATE_KEY_TEST.equalsIgnoreCase(operateKey)) {
                PayResponse payResponse = this.handle();
                if (payResponse.getException() != null) {
                    this.getView().showErrorNotification(payResponse.getException().getMessage());
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6d4b\u8bd5\u4ed8\u6b3e\u5b8c\u6210\u3002", (String)"MockPayTestPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                }
            } else if (OPERATE_KEY_EXIT.equalsIgnoreCase(operateKey)) {
                this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
                this.getView().close();
            }
        }
    }

    private PayResponse handle() {
        ArrayList<PayDetail> payDetails = new ArrayList<PayDetail>(16);
        String bizType = BizTypeEnum.PAY.getName();
        String payType = (String)this.getModel().getValue(COMBO_PAY_TYPE);
        String subBizType = this.getSubBizType(payType);
        boolean isMerge = Boolean.parseBoolean((String)this.getModel().getValue(COMBO_MERGE));
        boolean isUrgent = Boolean.parseBoolean((String)this.getModel().getValue("urgent"));
        String abstractMsg = (String)this.getModel().getValue("abstract_msg");
        Date bookDate = (Date)this.getModel().getValue("book_date");
        String batchSeqID = (String)this.getModel().getValue("batch_seq");
        DynamicObject currencyDynamicObj = (DynamicObject)this.getModel().getValue("currency");
        String bd_currency = String.valueOf(currencyDynamicObj.getLong("id"));
        String currency = currencyDynamicObj.getString("number");
        DynamicObject accountDynamicObj = (DynamicObject)this.getModel().getValue("account");
        String accNo = accountDynamicObj.getString("number");
        boolean isIndividual = !COMBO_PAY_TYPE_COMPANY.equalsIgnoreCase(payType);
        String useCn = this.getUseCN(payType);
        DynamicObjectCollection collection = (DynamicObjectCollection)this.getModel().getValue("paymentinfo");
        for (DynamicObject dynamicObject : collection) {
            PayDetail payDetail = new PayDetail();
            payDetail.setUseCN(useCn);
            payDetail.setIncomeType(isIndividual ? COMBO_PAY_TYPE_INDIVIDUAL : COMBO_PAY_TYPE_COMPANY);
            payDetail.setMergeFlag(isMerge);
            payDetail.setUrgent(isUrgent);
            payDetail.setAbstractMsg(abstractMsg);
            payDetail.setBookingTime(String.valueOf(bookDate.getTime()));
            payDetail.setBatchSeqID(batchSeqID);
            payDetail.setDetailSeqID(String.valueOf(ID.genLongId()));
            payDetail.setDetailBizNo(String.valueOf(ID.genLongId()));
            payDetail.setIncomeAreaCode("");
            payDetail.setIncomeCountry("");
            payDetail.setIncomeProvince("");
            payDetail.setIncomeCity("");
            payDetail.setUseCode("-1");
            String incomeAccNo = dynamicObject.getString("income_accno");
            payDetail.setIncomeAccNo(incomeAccNo);
            String incomeAccName = dynamicObject.getString("income_name");
            payDetail.setIncomeAccName(incomeAccName);
            BigDecimal amount = dynamicObject.getBigDecimal("amount");
            payDetail.setAmount(amount.setScale(2).toPlainString());
            String explanation = dynamicObject.getString("explanation");
            payDetail.setExplanation(explanation);
            payDetail.setIncomeBranchName("");
            payDetail.setIncomeBranchNo("");
            String incomeBankAddress = dynamicObject.getString("bank.address");
            payDetail.setIncomeBankAddress(incomeBankAddress);
            String incomeBankName = dynamicObject.getString("bank.name");
            payDetail.setIncomeBankName(incomeBankName);
            String incomeCnapsCode = dynamicObject.getString("bank.union_number");
            payDetail.setIncomeCnapsCode(incomeCnapsCode);
            String country = dynamicObject.getString("bank.country.name");
            payDetail.setIncomeCountry(country);
            String province = dynamicObject.getString("bank.province.name");
            payDetail.setIncomeProvince(province);
            String city = dynamicObject.getString("bank.city.name");
            payDetail.setIncomeCity(city);
            payDetail.setForce(false);
            payDetails.add(payDetail);
        }
        BizService bizService = (BizService)SpringContextUtil.getBean(BizService.class);
        PayResponse payResponse = bizService.mockPayTest(payDetails, accNo, bizType, subBizType, bd_currency, currency, batchSeqID);
        return payResponse;
    }

    private String getSubBizType(String payType) {
        if (COMBO_PAY_TYPE_REIM.equalsIgnoreCase(payType) || COMBO_PAY_TYPE_SALARY.equalsIgnoreCase(payType)) {
            return PayTypeEnum.PAY_FOR_SALARY.getName();
        }
        return PayTypeEnum.PAY.getName();
    }

    private String getUseCN(String payType) {
        if (COMBO_PAY_TYPE_COMPANY.equalsIgnoreCase(payType) || COMBO_PAY_TYPE_INDIVIDUAL.equalsIgnoreCase(payType)) {
            return ResManager.loadKDString((String)"\u4e1a\u52a1\u652f\u4ed8", (String)"MockPayTestPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        }
        if (COMBO_PAY_TYPE_REIM.equalsIgnoreCase(payType)) {
            return ResManager.loadKDString((String)"\u62a5\u9500", (String)"MockPayTestPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        }
        if (COMBO_PAY_TYPE_SALARY.equalsIgnoreCase(payType)) {
            return ResManager.loadKDString((String)"\u5de5\u8d44", (String)"MockPayTestPlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        }
        return "";
    }
}

