/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.paramsconfig;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.common.EbcAddBankListPlugin;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageRequest;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class LinkMonitorAcntSetting
extends EbcAddBankListPlugin {
    private static final String ENTITY_KEY_OBJECT_PROPERTIES = "aqap_object_properties";
    private static final String ENTITY_KEY_ACNT = "aqap_bank_acnt";
    private BankAcntRepository bankAcntRepository = (BankAcntRepository)SpringContextUtil.getBean(BankAcntRepository.class);

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        String SearchCondition = "";
        List fastFilterList = args.getFastQFilters();
        if (fastFilterList.size() > 0) {
            String[] param = String.valueOf(((QFilter)fastFilterList.get(0)).getValue()).split("#");
            SearchCondition = param[1];
        }
        this.getPageCache().put("SearchCondition", SearchCondition);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        this.getPageCache().put("bankLoginID", paramMap.get("bankLoginID").toString());
        final String customID = RequestContext.get().getTenantId();
        final IPageCache iPageCache = this.getPageCache();
        final String dataCountCacheKey = "page_data_data_count";
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return Integer.parseInt(iPageCache.get(dataCountCacheKey));
            }

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit + 1;
                int pageSize = limit;
                PageRequest pageRequest = PageRequest.of((int)(currentPage - 1), (int)pageSize);
                String SearchCondition = iPageCache.get("SearchCondition");
                Page bankAcnts = StringUtil.isNotNil(SearchCondition) ? LinkMonitorAcntSetting.this.bankAcntRepository.findByCustomIDAndBankLoginIDAndAcntAndEnable(customID, iPageCache.get("bankLoginID"), SearchCondition, "1", (Pageable)pageRequest) : LinkMonitorAcntSetting.this.bankAcntRepository.findByCustomIDAndBankLoginIDAndEnable(customID, iPageCache.get("bankLoginID"), "1", (Pageable)pageRequest);
                DynamicObjectCollection dObjectCollection = this.getCollection((Page<BankAcnt>)bankAcnts);
                List bankAcntList = bankAcnts.getContent();
                int dataCount = 0;
                if (CollectionUtil.isNotEmpty((Collection)bankAcntList)) {
                    dataCount = bankAcntList.size();
                }
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(dataCount);
                iPageCache.put(dataCountCacheKey, dataCount + "");
                return dObjectCollection;
            }

            private DynamicObjectCollection getCollection(Page<BankAcnt> details) {
                List bankAcntList = details.getContent();
                if (CollectionUtil.isNotEmpty((Collection)bankAcntList)) {
                    String bankVersionID = ((BankAcnt)details.getContent().get(0)).getBankVersionId();
                    QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{bankVersionID});
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_bank", (QFilter[])filter.toArray());
                    String bankVersionName = dynamicObject.getString("name");
                    String selectFields = "number, name, bank_login_id,bank_version_id,custom_id,city";
                    QFilter f = QFilter.of((String)"enable = ?", (Object[])new Object[]{"2"});
                    DynamicObjectCollection dCollection = QueryServiceHelper.query((String)LinkMonitorAcntSetting.ENTITY_KEY_ACNT, (String)selectFields, (QFilter[])f.toArray());
                    if (CollectionUtil.isEmpty((Collection)details.getContent())) {
                        return dCollection;
                    }
                    for (int i = 0; i < details.getContent().size(); ++i) {
                        BankAcnt d = (BankAcnt)details.getContent().get(i);
                        DynamicObject data = dCollection.addNew();
                        data.set("number", (Object)d.getAccNo());
                        data.set("name", (Object)d.getAccName());
                        data.set("city", (Object)d.getBankLoginId());
                        data.set("bank_version_id", (Object)bankVersionName);
                        data.set("custom_id", (Object)d.getCustomID());
                    }
                    return dCollection;
                }
                DynamicObjectType dt = BusinessDataServiceHelper.newDynamicObject((String)LinkMonitorAcntSetting.ENTITY_KEY_ACNT).getDynamicObjectType();
                return new DynamicObjectCollection(dt, null);
            }
        });
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List treeNodes;
        TreeView tree;
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap) && this.getPageCache().get("isFirstInit") == null && (tree = (TreeView)this.getView().getControl("treeview")) != null && !CollectionUtils.isEmpty((Collection)(treeNodes = ((TreeListView)((ListView)tree.getView()).getTreeListView()).getRoot().getChildren())) && paramMap.get("bank_version_id") != null) {
            for (TreeNode treeNode : treeNodes) {
                if (!paramMap.get("bank_version_id").equals(treeNode.getId())) continue;
                tree.focusNode(treeNode);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
    }
}

