/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.paramsconfig;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.report.CellStyle;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.model.repository.BankLoginLinkCheckRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.baseplugin.CompareEnum;
import kd.ebg.aqap.formplugin.pojo.bizinfo.BankVersionInfo;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.aqap.formplugin.util.CosmicDateUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageRequest;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.monitor.LoginLinkCheckInfo;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class LinkMonitorDetail
extends AbstractListPlugin {
    private static final String ENTITY_KEY_BANK_MONITOR = "aqap_login_link_monitor";
    private BankLoginLinkCheckRepository bankLoginLinkCheckDetail = (BankLoginLinkCheckRepository)SpringContextUtil.getBean(BankLoginLinkCheckRepository.class);
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap)) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (!fieldName.equals("update_time") || paramMap.get("trans_date_start") == null) continue;
                ArrayList l = new ArrayList(1);
                l.add(paramMap.get("trans_date_start"));
                l.add(paramMap.get("trans_date_end"));
                commonFilterColumn.setDefaultValues(l);
            }
            if (paramMap.get("bankLoginID") != null) {
                this.getPageCache().put("bankLoginID", paramMap.get("bankLoginID").toString());
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Object object;
        super.filterContainerSearchClick(args);
        String state = String.valueOf(args.getFilterValue("state"));
        String startDateTime = "";
        String endDateTime = "";
        if (state == null || "null".equalsIgnoreCase(state)) {
            state = "";
        }
        if ((object = args.getFilterValue("update_time")) instanceof List) {
            List list = (List)object;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                if (list.size() == 2) {
                    startDateTime = CosmicDateUtil.timeTranslate(sdf.parse((String)list.get(0) + " 00:00:00"));
                    endDateTime = CosmicDateUtil.timeTranslate(sdf.parse((String)list.get(1) + " 00:00:00"));
                } else if (list.size() == 1) {
                    startDateTime = CosmicDateUtil.timeTranslate(sdf.parse(CompareEnum.getCompareEnumByID((String)list.get(0)).getStartDate()));
                    endDateTime = CosmicDateUtil.timeTranslateBeforeMinute(sdf.parse(CompareEnum.getCompareEnumByID((String)list.get(0)).getEndDate()));
                }
            }
            catch (ParseException e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"LinkMonitorDetail_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), (Throwable)e);
            }
        }
        this.getPageCache().put("startDateTime", startDateTime);
        this.getPageCache().put("endDateTime", endDateTime);
        this.getPageCache().put("state", state);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String SearchCondition = this.getPageCache().get("SearchCondition");
        LocalDate startDate = LocalDate.now();
        LocalDate endDate = LocalDate.now();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (StringUtil.isNil(SearchCondition)) {
            if (this.getPageCache().get("isFirstInit") == null && paramMap.get("bankLoginID") != null) {
                this.getPageCache().put("startDateTime", (String)paramMap.get("trans_date_start"));
                this.getPageCache().put("endDateTime", (String)paramMap.get("trans_date_end"));
                this.getPageCache().put("bankLoginID", (String)paramMap.get("bankLoginID"));
                this.getPageCache().put("isFirstInit", "false");
            } else if (StringUtil.isNil(this.getPageCache().get("startDateTime"))) {
                Date end = new Date();
                Date start = DateUtil.preDay((Date)end, (int)7);
                this.getPageCache().put("startDateTime", DateUtil.formatDate((Date)start, (String)"yyyy-MM-dd HH:mm:ss"));
                this.getPageCache().put("endDateTime", DateUtil.formatDate((Date)end, (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        startDate = LocalDate.parse(this.getPageCache().get("startDateTime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        endDate = LocalDate.parse(this.getPageCache().get("endDateTime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        if (LocalDate.now().isBefore(endDate) && LocalDate.now().isBefore(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u548c\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u8d85\u8fc7\u4eca\u5929\u3002", (String)"LinkMonitorDetail_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            return;
        }
        if (LocalDate.now().isBefore(endDate)) {
            endDate = LocalDate.now();
        }
        final String customID = RequestContext.get().getTenantId();
        final IPageCache iPageCache = this.getPageCache();
        final String dataCountCacheKey = "page_data_data_count";
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return Integer.parseInt(iPageCache.get(dataCountCacheKey));
            }

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit + 1;
                int pageSize = limit;
                LocalDateTime dayFrom = LocalDateTime.parse(iPageCache.get("startDateTime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                LocalDateTime dayEnd = LocalDateTime.parse(iPageCache.get("endDateTime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                PageRequest pageRequest = PageRequest.of((int)(currentPage - 1), (int)pageSize);
                Page details = LinkMonitorDetail.this.bankLoginLinkCheckDetail.findByStateAndSearchTime(customID, iPageCache.get("bankLoginID"), iPageCache.get("state"), dayFrom, dayEnd, (Pageable)pageRequest);
                DynamicObjectCollection dObjectCollection = this.getCollection((Page<LoginLinkCheckInfo>)details);
                int dataCount = (int)details.getTotalElements();
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(dataCount);
                iPageCache.put(dataCountCacheKey, dataCount + "");
                return dObjectCollection;
            }

            private DynamicObjectCollection getCollection(Page<LoginLinkCheckInfo> details) {
                List<BankVersionInfo> bankVersionList = LinkMonitorDetail.this.infoService.getBankVersionInfoList();
                HashMap<String, String> banknames = new HashMap<String, String>(16);
                for (BankVersionInfo b : bankVersionList) {
                    banknames.put(b.getBankVersionID(), b.getBankVersionName());
                }
                int page = details.getNumber();
                int pageSize = details.getSize();
                String selectFields = "id, update_time, bank_loginid, bank_name, type, state, message";
                DynamicObjectCollection dCollection = QueryServiceHelper.query((String)LinkMonitorDetail.ENTITY_KEY_BANK_MONITOR, (String)selectFields, null);
                List detail = details.getContent();
                if (CollectionUtil.isEmpty((Collection)detail)) {
                    return dCollection;
                }
                for (int i = 0; i < details.getContent().size(); ++i) {
                    LoginLinkCheckInfo d = (LoginLinkCheckInfo)details.getContent().get(i);
                    DynamicObject data = dCollection.addNew();
                    data.set("id", (Object)(page * pageSize + i));
                    data.set("update_time", (Object)LocalDateUtil.localDateTime2Date((LocalDateTime)d.getUpdateTime()));
                    data.set("bank_loginid", (Object)d.getBankLoginID());
                    data.set("bank_name", banknames.get(d.getBankVersionID()));
                    data.set("type", (Object)d.getType());
                    if ("exception".equals(d.getStatus())) {
                        data.set("state", (Object)ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38", (String)"LinkMonitorDetail_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    } else if ("normal".equals(d.getStatus())) {
                        data.set("state", (Object)ResManager.loadKDString((String)"\u8fde\u63a5\u6b63\u5e38", (String)"LinkMonitorDetail_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    }
                    data.set("message", (Object)d.getMessage());
                }
                return dCollection;
            }
        });
    }

    public void packageData(PackageDataEvent evt) {
        Object obj = evt.getSource();
        DynamicObject rowData = evt.getRowData();
        String status = rowData.getString("state");
        int seq = rowData.getInt("id");
        if (obj instanceof ComboColumnDesc && "state".equals(((ComboColumnDesc)obj).getKey())) {
            if (PropertiesConstants.getValue((String)"CONNECT_EXCEPTION").equals(status)) {
                this.setListUnitStyle(seq, "#FB2323");
            } else if (PropertiesConstants.getValue((String)"CONNECT_NORMAL").equals(status)) {
                this.setListUnitStyle(seq, "#1BA854");
            }
        }
    }

    private void setListUnitStyle(int row, String color) {
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(16);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey("state");
        cellStyle.setRow(row);
        cellStyle.setForeColor(color);
        cellStyles.add(cellStyle);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setCellStyle(cellStyles);
    }
}

