/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.pay;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.ebg.aqap.formplugin.plugin.common.EBSITListPlugin;
import kd.ebg.aqap.formplugin.util.StringUtils;

public class PayRspCodePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String KEY_PAY_RSP = "aqap_pay_rsp";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("newentry".equalsIgnoreCase(operateKey)) {
            Long id = (Long)this.getModel().getDataEntity().get("interface.id");
            if (id == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u63a5\u53e3\u518d\u589e\u884c\u3002", (String)"PayRspCodePlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)this.getModel().getDataEntity().get("interface.name");
            String interfaceName = ormLocaleValue.get((Object)"zh_CN");
            if (StringUtils.isEmpty(interfaceName)) {
                interfaceName = ormLocaleValue.toString();
            }
            this.getView().getPageCache().put("interface_name", interfaceName);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String name = e.getEntryProp().getName();
        if (KEY_PAY_RSP.equalsIgnoreCase(name)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            String interface_name = this.getView().getPageCache().get("interface_name");
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_PAY_RSP);
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                entryGrid.getModel().setValue("interface_name", (Object)interface_name, rowDataEntity.getRowIndex());
            }
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("group");
        String bankVersionID = basedataEdit.getModel().getDataEntity().getString("group.number");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        qFilterList.add(new QFilter("number", "=", (Object)bankVersionID));
        showParameter.getTreeFilterParameter().setQFilters(qFilterList);
        showParameter.getListFilterParameter().setFilter(new QFilter("group.number", "=", (Object)bankVersionID));
        showParameter.getListFilterParameter().setFilter(new QFilter("biz_type.number", "in", (Object)Lists.newArrayList((Object[])new String[]{"pay", "queryPay", "overseaPay", "queryOverseaPay"})));
    }

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("interface");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        String tenantID = RequestContext.get().getTenantId();
        boolean isHide = EBSITListPlugin.TENANT_LIST.contains(tenantID);
        this.getView().setVisible(Boolean.valueOf(isHide), new String[]{"bar_save", "bar_submit", "bar_audit"});
        this.getModel().getDataEntity().set("interface", null);
        this.getView().updateView("interface");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }
}

