/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.pay;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.formplugin.plugin.pay.PayRuleConditionEnum;
import kd.ebg.aqap.formplugin.plugin.pay.PayRuleEnum;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.utils.log.OperationLogUtil;

public class PayRuleConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener,
ClickListener {
    public void afterBindData(EventObject e) {
        BaseView formShowParameter = (BaseView)e.getSource();
        OperationStatus status = formShowParameter.getFormShowParameter().getStatus();
        this.getPageCache().put("eb_pay_interface_status", status.name());
        if (status == OperationStatus.EDIT) {
            QFilter filter;
            DynamicObject[] dynamicObjects;
            String number = this.getModel().getDataEntity().getString("number");
            if (StringUtils.isNotEmpty(number) && (dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_pay_rule_config", (String)"sort_num", (QFilter[])(filter = QFilter.of((String)"number=?", (Object[])new Object[]{number})).toArray())) != null) {
                this.getSortNum(dynamicObjects[0].getInt("sort_num"));
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name", "group", "bd_interface"});
        } else if (status == OperationStatus.ADDNEW) {
            this.getSortNum(-1);
            this.showName();
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("group");
            String bankVersionID = basedataEdit.getModel().getDataEntity().getString("group.number");
            this.getView().setEnable(Boolean.valueOf(StringUtils.isEmpty(bankVersionID)), new String[]{"group"});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name"});
    }

    private int getSortNum(int num) {
        if (num > 0) {
            this.getModel().setValue("sort_num", (Object)num);
            return num;
        }
        BasedataEdit group = (BasedataEdit)this.getControl("group");
        String bankVersionID = group.getModel().getDataEntity().getString("group.number");
        int sort_num = 1;
        if (StringUtils.isNotEmpty(bankVersionID)) {
            QFilter filter;
            DynamicObject[] dynamicObjects;
            String number = this.getModel().getDataEntity().getString("number");
            boolean flag = true;
            if (StringUtils.isNotEmpty(number) && (dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_pay_rule_config", (String)"sort_num", (QFilter[])(filter = QFilter.of((String)"number=?", (Object[])new Object[]{number})).toArray())) != null && dynamicObjects.length > 0) {
                flag = false;
                sort_num = dynamicObjects[0].getInt("sort_num");
            }
            if (flag && (dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_pay_rule_config", (String)"", (QFilter[])(filter = QFilter.of((String)"group.number=?", (Object[])new Object[]{bankVersionID})).toArray())) != null) {
                sort_num = dynamicObjects.length + 1;
                this.getModel().getDataEntity().get("aqap_pay_rule");
                this.getView().updateView("aqap_pay_rule");
            }
        }
        this.getModel().setValue("sort_num", (Object)sort_num);
        this.getView().updateView("sort_num");
        return sort_num;
    }

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("bd_interface");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        TextEdit textEdit = (TextEdit)this.getView().getControl("value");
        textEdit.addClickListener((ClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("group");
        String bankVersionID = basedataEdit.getModel().getDataEntity().getString("group.number");
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        qFilterList.add(new QFilter("number", "=", (Object)bankVersionID));
        showParameter.getTreeFilterParameter().setQFilters(qFilterList);
        showParameter.getListFilterParameter().setFilter(new QFilter("group.number", "=", (Object)bankVersionID));
        showParameter.getListFilterParameter().setFilter(new QFilter("biz_type.number", "=", (Object)"pay"));
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        this.getSortNum(-1);
        this.showName();
    }

    private void showName() {
        BasedataEdit group = (BasedataEdit)this.getControl("group");
        String bankVersionID = group.getModel().getDataEntity().getString("group.number");
        if (StringUtils.isNotEmpty(bankVersionID)) {
            BasedataEdit bd_interface = (BasedataEdit)this.getControl("bd_interface");
            String bankCode = bd_interface.getModel().getDataEntity().getString("bd_interface.bank_code");
            String number = bankVersionID.toLowerCase(Locale.ENGLISH) + "-" + bankCode + "-" + Sequence.genSequence();
            this.getModel().setValue("number", (Object)number);
            this.getView().updateView("number");
            String name = bankVersionID.toLowerCase(Locale.ENGLISH) + "-" + bankCode;
            this.getModel().setValue("name", (Object)name);
            this.getView().updateView("name");
        }
    }

    public void click(EventObject event) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("aqap_pay_rule");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("aqap_pay_rule");
        if (selectRows.length == 1) {
            this.getPageCache().put("aqap_select_row", String.valueOf(selectRows[0]));
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRows[0]);
            PayRuleEnum payRuleEnum = PayRuleEnum.getEnumByName(dynamicObject.getString("key"));
            PayRuleConditionEnum payRuleConditionEnum = PayRuleConditionEnum.getEnumByName(dynamicObject.getString("condition"));
            if (payRuleEnum == PayRuleEnum.UNDEFINE) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u3010\u5339\u914d\u5b57\u6bb5\u3011\u53c2\u6570\u89c4\u5219\u3002", (String)"PayRuleConfigPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            if (payRuleConditionEnum == PayRuleConditionEnum.UNDEFINE) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u3010\u6761\u4ef6\u3011\u53c2\u6570\u89c4\u5219\u3002", (String)"PayRuleConfigPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("aqap_pay_rule_value");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("30%");
            styleCss.setHeight("30%");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setCustomParam("key", (Object)payRuleEnum.getName());
            formShowParameter.setCustomParam("value", (Object)dynamicObject.getString("value"));
            formShowParameter.setAppId("aqap");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "aqap_pay_rule_value"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String selectRowNum;
        Object returnValue;
        super.closedCallBack(e);
        if ("aqap_pay_rule_value".equalsIgnoreCase(e.getActionId()) && (returnValue = e.getReturnData()) != null && StringUtils.isNotEmpty(selectRowNum = this.getPageCache().get("aqap_select_row"))) {
            int selectRow = Integer.parseInt(selectRowNum);
            DynamicObjectCollection entity = this.getModel().getEntryEntity("aqap_pay_rule");
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
            dynamicObject.set("value", returnValue);
            this.getView().updateView("aqap_pay_rule");
        }
    }

    private void initCondition(PayRuleEnum payRuleEnum) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        if (payRuleEnum == PayRuleEnum.SUB_BIZ_TYPE || payRuleEnum == PayRuleEnum.SAME_BANK || payRuleEnum == PayRuleEnum.INDIVIDUAL || payRuleEnum == PayRuleEnum.MERGE || payRuleEnum == PayRuleEnum.CURRENCY) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(PayRuleConditionEnum.EQUAL.getDesc()));
            item.setValue(PayRuleConditionEnum.EQUAL.getName());
            comboItems.add(item);
        } else if (payRuleEnum == PayRuleEnum.AMOUNT) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(PayRuleConditionEnum.EQUAL.getDesc()));
            item.setValue(PayRuleConditionEnum.EQUAL.getName());
            comboItems.add(item);
            item = new ComboItem();
            item.setCaption(new LocaleString(PayRuleConditionEnum.GREATER.getDesc()));
            item.setValue(PayRuleConditionEnum.GREATER.getName());
            comboItems.add(item);
            item = new ComboItem();
            item.setCaption(new LocaleString(PayRuleConditionEnum.GREATER_EQUAL.getDesc()));
            item.setValue(PayRuleConditionEnum.GREATER_EQUAL.getName());
            comboItems.add(item);
            item = new ComboItem();
            item.setCaption(new LocaleString(PayRuleConditionEnum.LESS.getDesc()));
            item.setValue(PayRuleConditionEnum.LESS.getName());
            comboItems.add(item);
            item = new ComboItem();
            item.setCaption(new LocaleString(PayRuleConditionEnum.LESS_EQUAL.getDesc()));
            item.setValue(PayRuleConditionEnum.LESS_EQUAL.getName());
            comboItems.add(item);
        } else if (payRuleEnum == PayRuleEnum.USE_CN || payRuleEnum == PayRuleEnum.EXPLANATION) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(PayRuleConditionEnum.EQUAL.getDesc()));
            item.setValue(PayRuleConditionEnum.EQUAL.getName());
            comboItems.add(item);
            item = new ComboItem();
            item.setCaption(new LocaleString(PayRuleConditionEnum.LIKE.getDesc()));
            item.setValue(PayRuleConditionEnum.LIKE.getName());
            comboItems.add(item);
            item = new ComboItem();
            item.setCaption(new LocaleString(PayRuleConditionEnum.NOT_LIKE.getDesc()));
            item.setValue(PayRuleConditionEnum.NOT_LIKE.getName());
            comboItems.add(item);
        } else {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("condition");
        comboEdit.setComboItems(comboItems);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field = e.getProperty().getName();
        if ("key".equalsIgnoreCase(field)) {
            ChangeData[] changeData = e.getChangeSet();
            int selectRow = changeData[0].getRowIndex();
            String name = (String)changeData[0].getNewValue();
            PayRuleEnum payRuleEnum = PayRuleEnum.getEnumByName(name);
            if (payRuleEnum != PayRuleEnum.UNDEFINE) {
                this.initCondition(payRuleEnum);
                this.getView().updateView("condition", selectRow);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("aqap_pay_rule");
        int rows = dynamicObjectCollection.size();
        if ("newentry".equalsIgnoreCase(operateKey)) {
            for (int i = 0; i < rows; ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                String key = dynamicObject.getString("key");
                String condition = dynamicObject.getString("condition");
                String value = dynamicObject.getString("value");
                ArrayList<String> tips = new ArrayList<String>(3);
                if (StringUtils.isEmpty(key)) {
                    tips.add(ResManager.loadKDString((String)"\u3010\u5339\u914d\u5b57\u6bb5\u3011", (String)"PayRuleConfigPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty(condition)) {
                    tips.add(ResManager.loadKDString((String)"\u3010\u6761\u4ef6\u3011", (String)"PayRuleConfigPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty(value)) {
                    tips.add(ResManager.loadKDString((String)"\u3010\u503c\u3011", (String)"PayRuleConfigPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                }
                if (tips.size() <= 0) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u5b57\u6bb5:", (String)"PayRuleConfigPlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                for (String s : tips) {
                    sb.append(s);
                }
                sb.append(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"PayRuleConfigPlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(new LocaleString(sb.toString()).getLocaleValue());
                args.setCancel(true);
                return;
            }
            this.lockEntry(rows);
            this.resetKeyCombo(false);
        } else if ("deleteentry".equalsIgnoreCase(operateKey)) {
            this.lockEntry(rows - 2);
            this.resetKeyCombo(true);
        } else if ("save".equalsIgnoreCase(operateKey)) {
            for (int i = 0; i < rows; ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                String key = dynamicObject.getString("key");
                String condition = dynamicObject.getString("condition");
                String value = dynamicObject.getString("value");
                Object groupObj = this.getModel().getValue("group");
                String bankName = "";
                if (groupObj != null) {
                    DynamicObject bankDynamicObj = (DynamicObject)groupObj;
                    bankName = bankDynamicObj.getString("name");
                }
                String number = "";
                Object numberObj = this.getModel().getValue("number");
                if (numberObj != null) {
                    number = (String)numberObj;
                }
                this.operateLog(bankName, number, key, condition, value);
            }
        }
    }

    private void operateLog(String bankName, String number, String key, String condition, String value) {
        key = PayRuleEnum.getEnumByName(key).getDesc();
        condition = PayRuleConditionEnum.getEnumByName(condition).getDesc();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "BusinessPropertyFormPlugin_12", "ebg-aqap-formplugin");
        MultiLangEnumBridge descBridge = new MultiLangEnumBridge("%1$s\uff0c\u7f16\u53f7\u4e3a%2$s\u7684\u4ed8\u6b3e\u8def\u7531\u6761\u4ef6\uff1a%3$s %4$s %5$s\u3002", "PayRuleConfigPlugin_10", "ebg-aqap-formplugin");
        OperationLogUtil.recordInvoke((String)"aqap", (String)this.getView().getEntityId(), (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)descBridge, (String[])new String[]{bankName, number, key, condition, value});
    }

    private void lockEntry(int rows) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("aqap_pay_rule");
        List fieldEdits = entryGrid.getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            String fieldKey = fieldEdit.getFieldKey();
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("aqap_pay_rule");
            int totalRows = dynamicObjectCollection.size();
            for (int i = 0; i < totalRows; ++i) {
                if (i < rows) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{fieldKey});
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{fieldKey});
            }
        }
    }

    private void resetKeyCombo(boolean isDel) {
        List<String> names = this.getKeyName();
        if (isDel) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("aqap_pay_rule");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("aqap_pay_rule");
            int lastRow = dynamicObjectCollection.size() - 2;
            if (selectRows.length == 1) {
                int row = selectRows[0];
                String key = ((DynamicObject)dynamicObjectCollection.get(row)).getString("key");
                names.remove(key);
                key = lastRow < 0 ? ((DynamicObject)dynamicObjectCollection.get(0)).getString("key") : ((DynamicObject)dynamicObjectCollection.get(lastRow)).getString("key");
                names.remove(key);
            }
        }
        this.resetKeyCombo(names);
    }

    private void resetKeyCombo(List<String> names) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("key");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        ArrayList<PayRuleEnum> payRuleEnumList = new ArrayList<PayRuleEnum>(16);
        payRuleEnumList.addAll(PayRuleEnum.getPayRuleEnumList());
        for (String name : names) {
            PayRuleEnum payRuleEnum = PayRuleEnum.getEnumByName(name);
            payRuleEnumList.remove((Object)payRuleEnum);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(payRuleEnum.getDesc()));
            comboItem.setItemVisible(false);
            comboItem.setValue(payRuleEnum.getName());
            comboItems.add(comboItem);
        }
        for (PayRuleEnum payRuleEnum : payRuleEnumList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(payRuleEnum.getDesc()));
            comboItem.setItemVisible(true);
            comboItem.setValue(payRuleEnum.getName());
            comboItems.add(comboItem);
        }
        comboEdit.setComboItems(comboItems);
    }

    private List<String> getKeyName() {
        ArrayList<String> names = new ArrayList<String>(16);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("aqap_pay_rule");
        int rows = dynamicObjectCollection.size();
        for (int i = 0; i < rows; ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            String key = dynamicObject.getString("key");
            names.add(key);
        }
        return names;
    }
}

