/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.util;

import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.constant.BankTypeEnum;
import kd.ebg.aqap.common.model.constant.CertTypeEnum;

public class CertTypeUtil {
    public static Integer getCertType(String bankVersion) {
        Integer certType;
        if ("ALIPAY_CMP".equalsIgnoreCase(bankVersion)) {
            certType = CertTypeEnum.ALIPAY.getType();
        } else if ("WECHAT_DC".equalsIgnoreCase(bankVersion)) {
            certType = CertTypeEnum.WECHAT.getType();
        } else if (bankVersion.endsWith("_OPA")) {
            certType = CertTypeEnum.PLATEFORM.getType();
        } else {
            QFilter[] filters = new QFilter[]{QFilter.of((String)"number = ?", (Object[])new Object[]{bankVersion}), QFilter.of((String)"bank_type = ?", (Object[])new Object[]{String.valueOf(BankTypeEnum.waizi.getValue())})};
            boolean isOversea = QueryServiceHelper.exists((String)"aqap_bank", (QFilter[])filters);
            certType = isOversea ? CertTypeEnum.OVERSEAS.getType() : CertTypeEnum.CHN.getType();
        }
        return certType;
    }
}

