/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.service.biz;

import com.alibaba.fastjson.JSONException;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceRequest;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceRequestBody;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceResponse;
import kd.ebg.aqap.common.entity.biz.detail.DetailRequest;
import kd.ebg.aqap.common.entity.biz.detail.DetailRequestBody;
import kd.ebg.aqap.common.entity.biz.detail.DetailResponse;
import kd.ebg.aqap.common.entity.biz.monitor.MonitorRequest;
import kd.ebg.aqap.common.entity.biz.monitor.MonitorRequestBody;
import kd.ebg.aqap.common.entity.biz.monitor.MonitorResponse;
import kd.ebg.aqap.common.entity.biz.pay.PayBody;
import kd.ebg.aqap.common.entity.biz.pay.PayDetail;
import kd.ebg.aqap.common.entity.biz.pay.PayRequest;
import kd.ebg.aqap.common.entity.biz.pay.PayResponse;
import kd.ebg.aqap.common.model.BankLoginBean;
import kd.ebg.aqap.formplugin.exception.EBBizException;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.mservice.facade.utils.CommonUtils;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.framework.biz.BizTypeEnum;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKVN;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;
import net.sf.json.JSONObject;
import org.slf4j.MDC;

@Service
public class BizService {
    public static final String PAYTYPE_INDIVIDUAL = "individual";
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BizService.class);
    @Autowired
    private BankAcntRepository bankAcntRepository;
    @Autowired
    private BankLoginRepository bankLoginRepository;
    @Autowired
    private BankLoginConfigService bankLoginConfigService;

    private void initMDCLog(String sequenceID) {
        MDC.put((String)"logger_bank_no", (String)sequenceID);
        MDC.put((String)"logger_batch_no", (String)sequenceID);
        MDC.put((String)"logger_detail_no", (String)sequenceID);
    }

    @SdkDeprecated
    public BatchBalanceResponse todayBalance(String customerID, String accNo) {
        BankAcnt bankAcnt = this.bankAcntRepository.findByAccNoAndCustomID(accNo, customerID);
        BatchBalanceRequest balanceRequest = new BatchBalanceRequest();
        EBHeader header = new EBHeader();
        header.setAccNo(accNo);
        header.setBizType("batchBalance");
        header.setSubBizType("batch_balance");
        header.setClientName("COSMIC-EBG");
        header.setClientVersion("1.0");
        header.setCustomId(customerID);
        String bizSeqID = Sequence.gen18Sequence();
        JSONObject object = new JSONObject();
        object.put((Object)"loggerBatchNo", (Object)bizSeqID);
        object.put((Object)"loggerDetailNo", (Object)bizSeqID);
        object.put((Object)"loggerBankNo", (Object)bizSeqID);
        header.setExtData(object.toString());
        String currency = bankAcnt.getCurrency();
        if (StringUtil.isNil(currency)) {
            currency = "CNY";
        }
        header.setCurrency(currency);
        header.setRequestTime(System.currentTimeMillis());
        BatchBalanceRequestBody body = new BatchBalanceRequestBody();
        balanceRequest.setHeader(header);
        balanceRequest.setBody(body);
        body.setStartDate(LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        body.setEndDate(LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        body.setAccNos((List)Lists.newArrayList((Object[])new String[]{accNo}));
        try {
            this.initMDCLog(bizSeqID);
            this.logger.info(1, "\u9875\u9762\u67e5\u8be2\u8bf7\u6c42\u6570\u636e: \n{}", (Object)CommonUtils.prettyJson((String)JsonUtil.toJsonLine((Object)balanceRequest)));
            BatchBalanceResponse balanceResponse = (BatchBalanceResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"balance", (String)"balance", (Object[])new Object[]{balanceRequest});
            this.logger.info(2, "\u9875\u9762\u67e5\u8be2\u54cd\u5e94\u6570\u636e: \n{}", (Object)CommonUtils.prettyJson((String)JsonUtil.toJsonLine((Object)balanceResponse)));
            if (Objects.nonNull(balanceResponse) && Objects.nonNull(balanceResponse.getException())) {
                throw new EBBizException(balanceResponse.getException().getMessage());
            }
            return balanceResponse;
        }
        catch (JSONException e) {
            throw new EBBizException(e);
        }
    }

    public DetailResponse detail(String customerID, String accNo, LocalDate startDate, LocalDate endDate, String currency, Integer isKeyRepeat, int pageNum, int pageSize, boolean downloadFromBank) {
        DetailRequest detailRequest = new DetailRequest();
        DetailRequestBody body = new DetailRequestBody();
        detailRequest.setBody(body);
        EBHeader header = new EBHeader();
        detailRequest.setHeader(header);
        header.setAccNo(accNo);
        header.setBizType("detail");
        header.setSubBizType("");
        header.setClientName("COSMIC-EBG");
        header.setCustomId(customerID);
        header.setClientVersion("1.0");
        header.setCurrency(currency);
        header.setRequestTime(System.currentTimeMillis());
        String bizSeqID = Sequence.gen18Sequence();
        JSONObject object = new JSONObject();
        object.put((Object)"loggerBatchNo", (Object)bizSeqID);
        object.put((Object)"loggerDetailNo", (Object)bizSeqID);
        object.put((Object)"loggerBankNo", (Object)bizSeqID);
        header.setExtData(object.toString());
        body.setStartDate(startDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        body.setEndDate(endDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        body.setPageNum(pageNum);
        body.setPageSize(pageSize);
        body.setIsKeyRepeat(isKeyRepeat);
        body.setAsync(false);
        body.setDownloadFromBank(downloadFromBank);
        body.setSerialNo(accNo + startDate.format(DateTimeFormatter.BASIC_ISO_DATE) + endDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        try {
            this.initMDCLog(bizSeqID);
            this.logger.info(1, "\u9875\u9762\u67e5\u8be2\u8bf7\u6c42\u6570\u636e: \n{}", (Object)CommonUtils.prettyJson((String)JsonUtil.toJsonLine((Object)detailRequest)));
            DetailResponse detailResponse = (DetailResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"detail", (String)"detail", (Object[])new Object[]{detailRequest});
            this.logger.info(2, "\u9875\u9762\u67e5\u8be2\u54cd\u5e94\u6570\u636e: \n{}", (Object)CommonUtils.prettyJson((String)JsonUtil.toJsonLine((Object)detailResponse)));
            if (Objects.nonNull(detailResponse) && Objects.nonNull(detailResponse.getException())) {
                throw new EBBizException(detailResponse.getException().getMessage());
            }
            return detailResponse;
        }
        catch (JSONException e) {
            throw new EBBizException(e);
        }
    }

    public MonitorResponse ping(String customID, String bankLoginID) {
        MonitorRequest monitorRequest = new MonitorRequest();
        MonitorRequestBody body = new MonitorRequestBody();
        body.setBizType("ping");
        body.setSubType("ping");
        BankLoginKey key = new BankLoginKey();
        key.setCustomId(customID);
        key.setBankLoginId(bankLoginID);
        BankLogin bankLogin = this.bankLoginRepository.findById(key);
        if (bankLogin == null) {
            return new MonitorResponse();
        }
        String bankVersion = bankLogin.getBankVersionId();
        String bankName = bankLogin.getBankName();
        String data = com.alibaba.fastjson.JSONObject.toJSONString(this.getMonitorData(customID, bankLogin.getBankVersionId(), bankLoginID, bankLogin.getBankName()));
        if (StringUtil.isNil(data)) {
            throw new EBBizException(ResManager.loadKDString((String)"\u524d\u7f6e\u673aip\u6216\u7aef\u53e3\u914d\u7f6e\u9879\u4e0d\u5b58\u5728\u3002", (String)"BizService_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
        body.setData(data);
        monitorRequest.setBody(body);
        EBHeader header = new EBHeader();
        header.setAccNo(null);
        header.setCustomId(customID);
        header.setBizType("ping");
        header.setSubBizType("ping");
        header.setClientName("EBG AQAP");
        header.setClientVersion("1.0");
        header.setCurrency("CNY");
        header.setRequestTime(System.currentTimeMillis());
        String bizSeqID = Sequence.gen18Sequence();
        JSONObject object = new JSONObject();
        object.put((Object)"loggerBatchNo", (Object)bizSeqID);
        object.put((Object)"loggerDetailNo", (Object)bizSeqID);
        object.put((Object)"loggerBankNo", (Object)bizSeqID);
        object.put((Object)"bankVersionID", (Object)bankVersion);
        object.put((Object)"bankLoginID", (Object)bankLoginID);
        header.setExtData(object.toString());
        monitorRequest.setHeader(header);
        MonitorResponse monitorResponse = (MonitorResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"ping", (String)"ping", (Object[])new Object[]{monitorRequest});
        return monitorResponse;
    }

    public MonitorResponse exactPing(String customID, String bankLoginID, String ip, Integer port) {
        BankLoginKey key = new BankLoginKey();
        key.setCustomId(customID);
        key.setBankLoginId(bankLoginID);
        BankLogin bankLogin = this.bankLoginRepository.findById(key);
        if (bankLogin == null) {
            return new MonitorResponse();
        }
        String bankVersion = bankLogin.getBankVersionId();
        String data = com.alibaba.fastjson.JSONObject.toJSONString(this.getMonitorData(customID, bankLogin.getBankVersionId(), bankLoginID, bankLogin.getBankName(), ip, port));
        return this.proxyConnect(customID, bankVersion, bankLoginID, data);
    }

    private List<BankLoginBean> getMonitorData(String customID, String bankVersionID, String bankLoginID, String bankName) {
        ArrayList<BankLoginBean> bankLoginList = new ArrayList<BankLoginBean>(1);
        List configKVNS = this.bankLoginConfigService.getBankLoginConfigKVNList(bankLoginID, customID);
        String bankLoginIP = "";
        String bankLoginPort = "";
        for (BankLoginConfigKVN configKVN : configKVNS) {
            if ("ip".equalsIgnoreCase(configKVN.getBankConfigID())) {
                bankLoginIP = configKVN.getBankConfigValue();
                continue;
            }
            if (!"exchangePort".equalsIgnoreCase(configKVN.getBankConfigID())) continue;
            bankLoginPort = configKVN.getBankConfigValue();
        }
        if (StringUtil.isNotNil(bankLoginIP) && StringUtil.isNotNil(bankLoginPort)) {
            BankLoginBean bankLoginBean = new BankLoginBean();
            bankLoginBean.setIp(bankLoginIP);
            bankLoginBean.setPort(Integer.parseInt(bankLoginPort));
            bankLoginBean.setBankVersionId(bankVersionID);
            bankLoginBean.setBankLoginId(bankLoginID);
            bankLoginBean.setBankLoginName(bankName);
            bankLoginBean.setEmail("");
            bankLoginBean.setPhoneNum("");
            bankLoginList.add(bankLoginBean);
        }
        return bankLoginList;
    }

    private List<BankLoginBean> getMonitorData(String customID, String bankVersionID, String bankLoginID, String bankName, String bankLoginIP, Integer bankLoginPort) {
        ArrayList<BankLoginBean> bankLoginList = new ArrayList<BankLoginBean>(1);
        if (StringUtils.isEmpty((String)bankLoginIP)) {
            List configKVNS = this.bankLoginConfigService.getBankLoginConfigKVNList(bankLoginID, customID);
            for (BankLoginConfigKVN configKVN : configKVNS) {
                if (!"ip".equalsIgnoreCase(configKVN.getBankConfigID())) continue;
                bankLoginIP = configKVN.getBankConfigValue();
                break;
            }
        }
        if (StringUtil.isNotNil(bankLoginIP) && bankLoginPort > 0) {
            BankLoginBean bankLoginBean = new BankLoginBean();
            bankLoginBean.setIp(bankLoginIP);
            bankLoginBean.setPort(bankLoginPort.intValue());
            bankLoginBean.setBankVersionId(bankVersionID);
            bankLoginBean.setBankLoginId(bankLoginID);
            bankLoginBean.setBankLoginName(bankName);
            bankLoginBean.setEmail("");
            bankLoginBean.setPhoneNum("");
            bankLoginList.add(bankLoginBean);
        }
        return bankLoginList;
    }

    public MonitorResponse proxyConnect(String customID, String bankVersion, String bankLoginID, String data) {
        MonitorRequest monitorRequest = new MonitorRequest();
        MonitorRequestBody body = new MonitorRequestBody();
        body.setBizType("ping");
        body.setSubType("ping");
        body.setData(data);
        monitorRequest.setBody(body);
        EBHeader header = new EBHeader();
        header.setAccNo(null);
        header.setCustomId(customID);
        header.setBizType("ping");
        header.setSubBizType("ping");
        header.setClientName("EBG AQAP");
        header.setClientVersion("1.0");
        header.setCurrency("CNY");
        header.setRequestTime(System.currentTimeMillis());
        String bizSeqID = Sequence.gen18Sequence();
        JSONObject object = new JSONObject();
        object.put((Object)"loggerBatchNo", (Object)bizSeqID);
        object.put((Object)"loggerDetailNo", (Object)bizSeqID);
        object.put((Object)"loggerBankNo", (Object)bizSeqID);
        object.put((Object)"bankVersionID", (Object)bankVersion);
        object.put((Object)"bankLoginID", (Object)bankLoginID);
        header.setExtData(object.toString());
        monitorRequest.setHeader(header);
        return (MonitorResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"ping", (String)"ping", (Object[])new Object[]{monitorRequest});
    }

    public PayResponse mockPayTest(List<PayDetail> payDetails, String accNo, String bizType, String subBizType, String bd_currency, String currency, String batchSeqID) {
        String customID = RequestContext.get().getTenantId();
        EBHeader header = this.getEBHeader(customID, accNo, bizType, subBizType, bd_currency, currency, batchSeqID);
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (PayDetail payDetail : payDetails) {
            totalAmount = totalAmount.add(new BigDecimal(payDetail.getAmount()));
        }
        PayBody body = new PayBody();
        body.setBatchRollBack("true");
        body.setBatchBizNo(String.valueOf(ID.genLongId()));
        body.setBatchSeqID(batchSeqID);
        body.setFeeType(0);
        body.setTotalAmount(totalAmount.setScale(2).toPlainString());
        body.setTotalCount(payDetails.size());
        body.setDetails(payDetails);
        PayRequest payRequest = new PayRequest();
        payRequest.setHeader(header);
        payRequest.setBody(body);
        this.initMDCLog(batchSeqID);
        MDC.put((String)"bizName", (String)bizType);
        this.logger.info(1, "\u9875\u9762\u67e5\u8be2\u8bf7\u6c42\u6570\u636e: \n{}", (Object)CommonUtils.prettyJson((String)JsonUtil.toJsonLine((Object)payRequest)));
        PayResponse payResponse = (PayResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"mockPayTest", (String)"mockPayTest", (Object[])new Object[]{payRequest});
        this.logger.info(2, "\u9875\u9762\u67e5\u8be2\u54cd\u5e94\u6570\u636e: \n{}", (Object)CommonUtils.prettyJson((String)JsonUtil.toJsonLine((Object)payResponse)));
        return payResponse;
    }

    private EBHeader getEBHeader(String customID, String accNo, String bizType, String subBizType, String bd_currency, String currency, String bizSeqID) {
        EBHeader header = new EBHeader();
        header.setAccNo(accNo);
        header.setBizType(bizType);
        header.setSubBizType(subBizType);
        header.setClientName("COSMIC-EBG");
        header.setClientVersion("1.0");
        header.setCustomId(customID);
        JSONObject object = new JSONObject();
        object.put((Object)"loggerBatchNo", (Object)bizSeqID);
        object.put((Object)"loggerDetailNo", (Object)bizSeqID);
        object.put((Object)"loggerBankNo", (Object)bizSeqID);
        object.put((Object)"bd_currency", (Object)bd_currency);
        header.setExtData(object.toString());
        header.setCurrency(currency);
        header.setRequestTime(System.currentTimeMillis());
        header.setOperationName(BizTypeEnum.MOCK_PAY_TEST.getName());
        return header;
    }
}

