/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.util;

import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.utils.StringUtils;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.formplugin.exception.EBBizException;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.tenant.TenantAuth;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CertUtil.class);

    public static TenantAuth parse(InputStream inputStream) {
        TenantAuth auth = new TenantAuth();
        try {
            X509Certificate cert = CertUtil.getX509Certificate(inputStream);
            PublicKey publicKey = cert.getPublicKey();
            auth.setPublicKey(Base64.getEncoder().encodeToString(publicKey.getEncoded()));
            CertUtil.setTenantAuthInfo(auth, cert);
        }
        catch (Exception e) {
            throw new EBBizException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return auth;
    }

    private static X509Certificate getX509Certificate(InputStream inputStream) throws CertificateException {
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            return cert;
        }
        catch (CertificateException e) {
            logger.error(e.toString(), (Throwable)e);
            throw e;
        }
    }

    public static void setTenantAuthInfo(TenantAuth auth, X509Certificate cert) {
        String[] messages;
        Principal subjectDN = cert.getSubjectDN();
        for (String message : messages = subjectDN.getName().split(",")) {
            String[] map = message.split("=");
            String key = map[0].trim();
            String value = map[1].trim();
            if ("CN".equalsIgnoreCase(key)) {
                auth.setCommonName(value);
                auth.setCertificateName(value);
            }
            if (!"O".equalsIgnoreCase(key)) continue;
            auth.setOrganization(value);
        }
        String expireTimeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(cert.getNotAfter().getTime()));
        LocalDateTime expireTime = DTFactoryUtil.parseDateTime((String)expireTimeStr);
        auth.setExpireTime(expireTime);
    }

    public static CertInfo getCertExpireTimeInfo(InputStream inputStream, String pwd, String fileName, String bankVersionID) {
        if (StringUtil.isNullOrEmpty(pwd)) {
            if ("ALIPAY_CMP".equals(bankVersionID) || "ZSB_OPA".equalsIgnoreCase(bankVersionID)) {
                return CertUtil.getPublicKeyInfoV2(inputStream, fileName, bankVersionID);
            }
            return CertUtil.getPublicKeyInfo(inputStream, fileName, bankVersionID);
        }
        return CertUtil.getPrivateKeyInfo(inputStream, pwd, fileName, bankVersionID);
    }

    public static CertInfo getPrivateKeyInfo(InputStream inputStream, String privKeyPswdString, String fileName, String bankVersionID) {
        CertInfo result = null;
        String keyAlias = null;
        try {
            String type = "PKCS12";
            if (fileName.endsWith(".jks") || fileName.endsWith(".keystore")) {
                type = "JKS";
            }
            KeyStore keyStore = KeyStore.getInstance(type);
            char[] nPassword = null;
            nPassword = StringUtil.isNullOrEmpty(privKeyPswdString) ? null : privKeyPswdString.toCharArray();
            keyStore.load(inputStream, nPassword);
            Enumeration<String> enumeration = keyStore.aliases();
            if (enumeration.hasMoreElements()) {
                keyAlias = enumeration.nextElement();
            }
            Certificate certificate = keyStore.getCertificate(keyAlias);
            X509Certificate cert = CertUtil.getX509Certificate(new ByteArrayInputStream(certificate.getEncoded()));
            LocalDateTime expireTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(cert.getNotAfter().getTime()), ZoneId.systemDefault());
            result = new CertInfo();
            result.setCertPassword(privKeyPswdString);
            result.setExpireTime(expireTime);
            if ("GDB_OPA".equals(bankVersionID) && fileName.endsWith(".pfx")) {
                result.setFileContent(Base64.getEncoder().encodeToString(keyStore.getKey(keyAlias, privKeyPswdString.toCharArray()).getEncoded()));
            }
        }
        catch (Exception e) {
            logger.error("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return result;
    }

    public static CertInfo getPublicKeyInfo(InputStream inputStream, String fileName, String bankVersionID) {
        CertInfo result = null;
        try {
            X509Certificate cert = CertUtil.getX509Certificate(inputStream);
            LocalDateTime expireTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(cert.getNotAfter().getTime()), ZoneId.systemDefault());
            result = new CertInfo();
            result.setExpireTime(expireTime);
            if ("GDB_OPA".equals(bankVersionID) && fileName.endsWith(".cer")) {
                PublicKey publicKey = cert.getPublicKey();
                result.setFileContent(Base64.getEncoder().encodeToString(publicKey.getEncoded()));
            }
        }
        catch (Exception e) {
            logger.error("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return result;
    }

    public static CertInfo getPublicKeyInfoV2(InputStream inputStream, String fileName, String bankVersionID) {
        CertInfo result = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(inputStream);
            LocalDateTime expireTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(cert.getNotAfter().getTime()), ZoneId.systemDefault());
            result = new CertInfo();
            result.setExpireTime(expireTime);
            if ("GDB_OPA".equals(bankVersionID) && fileName.endsWith(".cer")) {
                PublicKey publicKey = cert.getPublicKey();
                result.setFileContent(Base64.getEncoder().encodeToString(publicKey.getEncoded()));
            }
        }
        catch (Exception e) {
            logger.error("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return result;
    }

    public static CertInfo getPublicKeyInfo4CMbc(InputStream inputStream) {
        CertInfo result = new CertInfo();
        try {
            X509Cert cert = new X509Cert(inputStream);
            LocalDateTime expireTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(cert.getNotAfter().getTime()), ZoneId.systemDefault());
            result.setExpireTime(expireTime);
        }
        catch (Exception e) {
            logger.error("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return result;
    }

    public static CertInfo getKeyInfoicbc(InputStream inputStream, TempFileCacheDownloadable.Content content, String pwd) {
        CertInfo certInfo = new CertInfo();
        try {
            certInfo.setExpireTime(LocalDateTime.of(2099, 12, 30, 23, 59, 59));
            if (StringUtils.isNotEmpty((CharSequence)pwd)) {
                certInfo.setCertPassword(pwd);
            }
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] var4 = new byte[content.getLength()];
            dataInputStream.read(var4);
            String result = new String(com.icbc.bcprov.org.bouncycastle.util.encoders.Base64.encode((byte[])var4));
            certInfo.setFileContent(result);
        }
        catch (Exception e) {
            logger.error("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25:{}", new Object[]{e.getMessage()});
        }
        return certInfo;
    }
}

