/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.util.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.SSLHandshakeException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.entity.biz.monitor.MonitorResponse;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.model.testnet.PingException;
import kd.ebg.aqap.common.model.testnet.Response;
import kd.ebg.aqap.common.model.testnet.State;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.service.biz.BizService;
import kd.ebg.egf.common.exception.EBErrorPriKeyCipherException;
import kd.ebg.egf.common.exception.EBErrorPubKeyCipherException;
import kd.ebg.egf.common.exception.EBPriKeyAbsentAliasException;
import kd.ebg.egf.common.exception.EBPubKeyAbsentAliasException;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKVN;
import kd.ebg.egf.common.model.proxy.BankLoginProxyConfig;
import kd.ebg.egf.common.repository.bank.config.BankLoginProxyConfigRepository;
import kd.ebg.egf.common.utils.net.NetUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TestConnect {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TestConnect.class);
    private static TestConnect instance = new TestConnect();
    private BankLoginConfigService bankLoginConfigService = (BankLoginConfigService)SpringContextUtil.getBean(BankLoginConfigService.class);
    String failMsg = ResManager.loadKDString((String)"%1$s %2$s \u5931\u8d25\uff1b", (String)"TestConnect_14", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
    String successMsg = ResManager.loadKDString((String)"%1$s %2$s \u6210\u529f\uff1b", (String)"TestConnect_15", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);

    public static TestConnect getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response tryConnect(String ip, int port) {
        Socket aSocket = new Socket();
        String address = NetUtil.getLocalhostStr();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(ip, port);
        String errMsg = "";
        String errReason = "";
        Response failResponse = Response.fail();
        failResponse.setState(State.COSMIC2BANK_ERROR);
        try {
            int connectTimeout = SystemPropertyConfig.getConnectTimeout();
            aSocket.connect(inetSocketAddress, connectTimeout * 1000);
        }
        catch (UnknownHostException e) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1 %2$s %3$s \u57df\u540d\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e0a\u8ff0\u670d\u52a1\u53ca\u94f6\u884c\u670d\u52a1\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestConnect_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), address, ip, port);
            errReason = ResManager.loadKDString((String)"\u57df\u540d\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e0a\u8ff0\u670d\u52a1\u53ca\u94f6\u884c\u670d\u52a1\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestConnect_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
            logger.error(errMsg, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1 %2$s %3$s \u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u4e0a\u8ff0\u670d\u52a1\u53ca\u94f6\u884c\u670d\u52a1\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestConnect_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), address, ip, port);
            errReason = ResManager.loadKDString((String)"\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u4e0a\u8ff0\u670d\u52a1\u53ca\u94f6\u884c\u670d\u52a1\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestConnect_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
            logger.error(errMsg, (Throwable)e);
        }
        catch (ConnectException e) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1 %2$s %3$s \u88ab\u62d2\u7edd\uff0c\u8bf7\u68c0\u67e5\u94f6\u884c\u670d\u52a1\u5730\u5740\u3001\u7aef\u53e3\u662f\u5426\u6b63\u786e\u53ca\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestConnect_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), address, ip, port);
            errReason = ResManager.loadKDString((String)"\u8fde\u63a5\u88ab\u62d2\u7edd\uff0c\u8bf7\u68c0\u67e5\u94f6\u884c\u670d\u52a1\u5730\u5740\u3001\u7aef\u53e3\u662f\u5426\u6b63\u786e\u53ca\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestConnect_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
            logger.error(errMsg, (Throwable)e);
        }
        catch (Exception e) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1 %2$s %3$s \u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u94f6\u884c\u670d\u52a1\u8fd0\u884c\u60c5\u51b5\u3002", (String)"TestConnect_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), address, ip, port);
            errReason = ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u94f6\u884c\u670d\u52a1\u8fd0\u884c\u60c5\u51b5\u3002", (String)"TestConnect_7", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
            logger.error(errMsg, (Throwable)e);
        }
        finally {
            try {
                aSocket.close();
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)errMsg)) {
            failResponse.setErrMsg(errMsg);
            failResponse.setErrReason(errReason);
            failResponse.setPort(port + "");
            failResponse.setLocalAddress(address);
            failResponse.setTargetIp(ip);
            return failResponse;
        }
        Response success = Response.success();
        success.setPort(port + "");
        success.setTargetIp(ip);
        return success;
    }

    public boolean isMonitorBizSuccess(MonitorResponse response) {
        return response.getException() == null || StringUtils.isEmpty((String)response.getException().getErrorClass());
    }

    public Response tryProxyConnect(String customID, String bankLoginID) {
        String errMsg;
        BizService bizService = (BizService)SpringContextUtil.getBean(BizService.class);
        MonitorResponse response = bizService.ping(customID, bankLoginID);
        if (this.isMonitorBizSuccess(response)) {
            return Response.success();
        }
        String errorClass = response.getException().getErrorClass();
        List configKVNS = this.bankLoginConfigService.getBankLoginConfigKVNList(bankLoginID, customID);
        BankLoginProxyConfig proxyConfig = BankLoginProxyConfigRepository.getInstance().findById(customID);
        if (Objects.isNull(proxyConfig)) {
            return Response.success();
        }
        String pIp = proxyConfig.getProxyHost();
        String pPort = proxyConfig.getProxyPort();
        String bIp = "";
        String bPort = "";
        for (BankLoginConfigKVN configKVN : configKVNS) {
            if ("ip".equalsIgnoreCase(configKVN.getBankConfigID())) {
                bIp = configKVN.getBankConfigValue();
                continue;
            }
            if (!"exchangePort".equalsIgnoreCase(configKVN.getBankConfigID())) continue;
            bPort = configKVN.getBankConfigValue();
        }
        Response failResponse = Response.fail();
        failResponse.setState(State.COSMIC2PROXY_ERROR);
        if (IllegalStateException.class.getName().equalsIgnoreCase(errorClass) || ConnectException.class.getName().equalsIgnoreCase(errorClass)) {
            errMsg = String.format(ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406\u670d\u52a1\u7aef\u53e3\uff1a%1$s %2$s \u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u4ee3\u7406\u7aef\u53e3\u662f\u5426\u4e3a\u516c\u7f51\u53ef\u8bbf\u95ee\u7aef\u53e3\u3002", (String)"TestConnect_8", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), pIp, pPort);
        } else if (SSLHandshakeException.class.getName().equalsIgnoreCase(errorClass) || IOException.class.getName().equalsIgnoreCase(errorClass)) {
            errMsg = ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406\u8bc1\u4e66\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u4ee3\u7406\u914d\u7f6e\u7684\u79c1\u94a5/\u516c\u94a5\u8bc1\u4e66\u6587\u4ef6\u3001\u522b\u540d\u53ca\u5bc6\u7801\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"TestConnect_9", (String)"ebg-aqap-formplugin", (Object[])new Object[0]);
        } else if (PingException.class.getName().equalsIgnoreCase(errorClass)) {
            failResponse.setState(State.PROXY2BANK_ERROR);
            errMsg = String.format(ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406 %1$s %2$s \u8fde\u63a5\u94f6\u884c\u670d\u52a1 %3$s %4$s \u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u94f6\u884c\u670d\u52a1\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestConnect_10", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), pIp, pPort, bIp, bPort);
        } else {
            errMsg = EBErrorPriKeyCipherException.class.getName().equalsIgnoreCase(errorClass) || EBErrorPubKeyCipherException.class.getName().equalsIgnoreCase(errorClass) ? ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406\u8bc1\u4e66\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u4ee3\u7406\u914d\u7f6e\u7684\u79c1\u94a5/\u516c\u94a5\u8bc1\u4e66\u6587\u4ef6\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"TestConnect_11", (String)"ebg-aqap-formplugin", (Object[])new Object[0]) : (EBPriKeyAbsentAliasException.class.getName().equalsIgnoreCase(errorClass) || EBPubKeyAbsentAliasException.class.getName().equalsIgnoreCase(errorClass) ? ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406\u8bc1\u4e66\u4ea4\u4e92\u5931\u8d25\uff0c\u8bc1\u4e66\u94fe\u4e0d\u5b58\u5728\u914d\u7f6e\u7684\u522b\u540d\u3002", (String)"TestConnect_12", (String)"ebg-aqap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8fde\u63a5\u7f51\u7edc\u4ee3\u7406\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u4ee3\u7406\u670d\u52a1\u8fd0\u884c\u60c5\u51b5\u3001\u5730\u5740\u53ca\u7aef\u53e3\u914d\u7f6e\u7684\u6b63\u786e\u6027\u3002", (String)"TestConnect_13", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
        failResponse.setErrMsg(errMsg);
        return failResponse;
    }

    public Response tryMultiProxyConnect(String customID, String bankLoginID, Map<String, Integer> portMap, Map<String, String> ipMap) {
        Integer port;
        BizService bizService = (BizService)SpringContextUtil.getBean(BizService.class);
        Response firstResponse = this.tryProxyConnect(customID, bankLoginID);
        if (!firstResponse.isSuccess() && firstResponse.isCosmic2ProxyStopped()) {
            return firstResponse;
        }
        List configKVNS = this.bankLoginConfigService.getBankLoginConfigKVNList(bankLoginID, customID);
        BankLoginProxyConfig proxyConfig = BankLoginProxyConfigRepository.getInstance().findById(customID);
        String pIp = proxyConfig.getProxyHost();
        String pPort = proxyConfig.getProxyPort();
        String bIp = "";
        String bPort = "";
        String fpIP = "";
        String fpPort = "";
        String signPort = "";
        for (BankLoginConfigKVN configKVN : configKVNS) {
            if ("ip".equalsIgnoreCase(configKVN.getBankConfigID())) {
                bIp = configKVN.getBankConfigValue();
                continue;
            }
            if ("exchangePort".equalsIgnoreCase(configKVN.getBankConfigID())) {
                bPort = configKVN.getBankConfigValue();
                continue;
            }
            if ("frontProxy_Port".equalsIgnoreCase(configKVN.getBankConfigID())) {
                fpPort = configKVN.getBankConfigValue();
                if (!portMap.containsKey("frontProxy_Port")) continue;
                fpPort = portMap.get("frontProxy_Port") + "";
                continue;
            }
            if ("front_proxy_ip".equalsIgnoreCase(configKVN.getBankConfigID())) {
                fpIP = configKVN.getBankConfigValue();
                if (!ipMap.containsKey("front_proxy_ip")) continue;
                fpIP = ipMap.get("front_proxy_ip");
                continue;
            }
            if (!"signPort".equalsIgnoreCase(configKVN.getBankConfigID())) continue;
            signPort = configKVN.getBankConfigValue();
            if (!portMap.containsKey("signPort")) continue;
            signPort = portMap.get("signPort") + "";
        }
        Response failResponse = Response.fail();
        StringBuilder resHead = new StringBuilder(String.format(ResManager.loadKDString((String)"\u7f51\u7edc\u4ee3\u7406 %1$s %2$s \u8fde\u63a5\u94f6\u884c\u670d\u52a1", (String)"TestConnect_16", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), pIp, pPort));
        StringBuilder res = new StringBuilder();
        if (!firstResponse.isSuccess()) {
            res.append(String.format(this.failMsg, bIp, bPort));
        } else {
            resHead.append(String.format(this.successMsg, bIp, bPort));
        }
        if (StringUtils.isNotEmpty((String)fpPort)) {
            String ip;
            if (!this.checkLegal(fpPort)) {
                failResponse.setErrMsg(ResManager.loadKDString((String)"\u4ee3\u7406\u7a0b\u5e8f\u7aef\u53e3\u683c\u5f0f\u6709\u8bef\u3002", (String)"TestConnect_17", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return failResponse;
            }
            port = Integer.parseInt(fpPort);
            String string = ip = StringUtils.isEmpty((String)fpIP) ? bIp : fpIP;
            if (!this.isMonitorBizSuccess(bizService.exactPing(customID, bankLoginID, ip, port))) {
                res.append(String.format(this.failMsg, ip, port));
            } else {
                resHead.append(String.format(this.successMsg, ip, port));
            }
        }
        if (StringUtils.isNotEmpty((String)signPort)) {
            if (!this.checkLegal(signPort)) {
                failResponse.setErrMsg(ResManager.loadKDString((String)"\u7b7e\u540d\u7aef\u53e3\u683c\u5f0f\u6709\u8bef\u3002", (String)"TestConnect_18", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return failResponse;
            }
            port = Integer.parseInt(signPort);
            if (!this.isMonitorBizSuccess(bizService.exactPing(customID, bankLoginID, bIp, port))) {
                res.append(String.format(this.failMsg, bIp, port));
            } else {
                resHead.append(String.format(this.successMsg, bIp, port));
            }
        }
        if (res.length() == 0) {
            return Response.success();
        }
        failResponse.setState(State.PROXY2BANK_ERROR);
        res.append("\uff0c").append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\u662f\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u94f6\u884c\u670d\u52a1\u7f51\u7edc\u8bbf\u95ee\u6743\u9650\u3002", (String)"TestConnect_19", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        resHead.append((CharSequence)res);
        failResponse.setErrMsg(StringUtils.norm((String)resHead.toString()));
        return failResponse;
    }

    public Response tryMultiProxyConnect(String customID, String bankLoginID) {
        return this.tryMultiProxyConnect(customID, bankLoginID, Maps.newHashMapWithExpectedSize((int)1), Maps.newHashMapWithExpectedSize((int)1));
    }

    public Response test(String customID, String bankLoginID, String ip, int port) {
        return this.bankLoginConfigService.isProxy(customID, bankLoginID) ? this.tryProxyConnect(customID, bankLoginID) : this.tryConnect(ip, port);
    }

    public Response test(String customID, String bankLoginID, String ip, int port, Map<String, Integer> portMap, Map<String, String> ipMap) {
        if (this.bankLoginConfigService.isProxy(customID, bankLoginID)) {
            return this.tryMultiProxyConnect(customID, bankLoginID, portMap, ipMap);
        }
        Response portResponse = this.test(customID, bankLoginID, ip, port);
        if (portMap.isEmpty()) {
            return portResponse;
        }
        Response spResponse = null;
        Response ppResponse = null;
        for (Map.Entry<String, Integer> entry : portMap.entrySet()) {
            if ("frontProxy_Port".equalsIgnoreCase(entry.getKey())) {
                String fpIp = ipMap.getOrDefault("front_proxy_ip", ip);
                ppResponse = this.test(customID, bankLoginID, fpIp, entry.getValue());
                continue;
            }
            spResponse = this.test(customID, bankLoginID, ip, entry.getValue());
        }
        ArrayList responses = Lists.newArrayList((Object[])new Response[]{portResponse});
        if (spResponse != null) {
            responses.add(spResponse);
        }
        if (ppResponse != null) {
            responses.add(ppResponse);
        }
        int size = responses.size();
        List<Response> successResponses = responses.stream().filter(Response::isSuccess).collect(Collectors.toList());
        List<Response> failResponses = responses.stream().filter(r -> !r.isSuccess()).collect(Collectors.toList());
        if (size == successResponses.size()) {
            return Response.success();
        }
        StringBuilder res = new StringBuilder(ResManager.loadKDString((String)"\u8fde\u63a5\u94f6\u884c\u670d\u52a1", (String)"TestConnect_20", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        successResponses.forEach(r -> res.append(r.getTargetIp()).append(" ").append(r.getPort()).append(ResManager.loadKDString((String)"\u6210\u529f\uff1b", (String)"TestConnect_21", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
        failResponses.forEach(r -> res.append(r.getTargetIp()).append(" ").append(r.getPort()).append(ResManager.loadKDString((String)"\u5931\u8d25\uff1b", (String)"TestConnect_22", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
        res.append("\uff0c").append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\u662f", (String)"TestConnect_23", (String)"ebg-aqap-formplugin", (Object[])new Object[0])).append(((Response)failResponses.get(0)).getErrReason());
        Response failRes = Response.fail();
        failRes.setErrMsg(StringUtils.norm((String)res.toString()));
        return failRes;
    }

    public boolean checkLegal(String port) {
        try {
            int v = Integer.parseInt(port);
            return v >= 0 && v <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

